/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.codereview.java.ast.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;

public class ASTHelperUtils {
    public static ASTNode getEnclosingASTNodeType(ASTNode node) {
        ASTNode parent = node.getParent();
        if (parent != null) {
            while (parent.getNodeType() != 1 && parent.getNodeType() != 55) {
                if ((parent = parent.getParent()) != null) continue;
                return null;
            }
            return parent;
        }
        return null;
    }

    public static boolean matchModifier(int nodeModifiers, int modifier) {
        boolean match = false;
        if (modifier == 11) {
            match = Modifier.isAbstract((int)nodeModifiers);
        } else if (modifier == 12) {
            match = Modifier.isFinal((int)nodeModifiers);
        } else if (modifier == 13) {
            match = Modifier.isNative((int)nodeModifiers);
        } else if (modifier == 16) {
            match = Modifier.isPrivate((int)nodeModifiers);
        } else if (modifier == 15) {
            match = Modifier.isProtected((int)nodeModifiers);
        } else if (modifier == 14) {
            match = Modifier.isPublic((int)nodeModifiers);
        } else if (modifier == 17) {
            match = Modifier.isPublic((int)nodeModifiers);
        } else if (modifier == 18) {
            match = Modifier.isSynchronized((int)nodeModifiers);
        } else if (modifier == 19) {
            match = Modifier.isStatic((int)nodeModifiers);
        } else if (modifier == 20) {
            match = Modifier.isTransient((int)nodeModifiers);
        }
        return match;
    }

    public static boolean matchBindingModifier(IBinding binding, int modifier) {
        if (binding != null) {
            return ASTHelperUtils.matchModifier(binding.getModifiers(), modifier);
        }
        return false;
    }

    public static boolean matchTypeModifier(ITypeBinding binding, int modifier) {
        boolean match = false;
        if (binding != null) {
            if (modifier == 8) {
                match = binding.isPrimitive();
            } else if (modifier == 2) {
                match = binding.isArray();
            } else if (modifier == 1) {
                match = binding.isAnnotation();
            } else if (modifier == 0) {
                match = binding.isAnonymous();
            } else if (modifier == 3) {
                match = binding.isClass();
            } else if (modifier == 2) {
                match = binding.isClass();
            } else if (modifier == 4) {
                match = binding.isDeprecated();
            } else if (modifier == 5) {
                match = binding.isEnum();
            } else if (modifier == 7) {
                match = binding.isLocal();
            } else if (modifier == 6) {
                match = binding.isInterface();
            } else if (modifier == 9) {
                match = binding.isNullType();
            } else if (modifier == 10) {
                match = binding.isNested();
            }
        }
        return match;
    }

    public static List getInterfaceList(ITypeBinding type) {
        try {
            List allInterfaces = ASTHelperUtils.getAllExtendedInterfaceTypes(type);
            List superClasses = ASTHelperUtils.getSuperTypes(type);
            Iterator iter = superClasses.iterator();
            while (iter.hasNext()) {
                allInterfaces.addAll(ASTHelperUtils.getAllExtendedInterfaceTypes((ITypeBinding)iter.next()));
            }
            return allInterfaces;
        }
        catch (NullPointerException nullPointerException) {
            return new LinkedList();
        }
    }

    public static List getAllExtendedInterfaceTypes(ITypeBinding type) {
        ArrayList<ITypeBinding> toReturn = new ArrayList<ITypeBinding>();
        ITypeBinding[] extendedInterfaces = type.getInterfaces();
        int numExtendedInterfaces = extendedInterfaces.length;
        if (numExtendedInterfaces == 0) {
            return toReturn;
        }
        int i = 0;
        while (i < numExtendedInterfaces) {
            toReturn.add(extendedInterfaces[i]);
            toReturn.addAll(ASTHelperUtils.getAllExtendedInterfaceTypes(extendedInterfaces[i]));
            ++i;
        }
        return toReturn;
    }

    public static List getSuperTypes(ITypeBinding type) {
        ArrayList<ITypeBinding> toReturn = new ArrayList<ITypeBinding>();
        if (!type.isClass()) {
            return toReturn;
        }
        ITypeBinding superType = type.getSuperclass();
        while (superType != null) {
            toReturn.add(superType);
            superType = superType.getSuperclass();
        }
        return toReturn;
    }

    public static boolean same(IMethodBinding declaration, IMethodBinding declaration2) {
        return ASTHelperUtils.sameMethodName(declaration, declaration2) && ASTHelperUtils.sameParameters(declaration, declaration2) && ASTHelperUtils.sameReturnType(declaration, declaration2);
    }

    public static boolean sameMethodName(IMethodBinding declaration, IMethodBinding declaration2) {
        return declaration.getName().equals(declaration2.getName());
    }

    public static boolean sameReturnType(IMethodBinding declaration, IMethodBinding declaration2) {
        return declaration.getReturnType().getQualifiedName().equals(declaration2.getReturnType().getQualifiedName());
    }

    public static boolean sameParameters(IMethodBinding declaration, IMethodBinding declaration2) {
        ITypeBinding[] declares2;
        ITypeBinding[] declares = declaration.getParameterTypes();
        if (declares.length == (declares2 = declaration2.getParameterTypes()).length) {
            int index = 0;
            while (index < declares.length) {
                if (!declares[index].getQualifiedName().equals(declares2[index].getQualifiedName())) {
                    return false;
                }
                ++index;
            }
            return true;
        }
        return false;
    }
}

