/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.codereview.java.internal;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.tptp.platform.analysis.core.logging.Log;
import org.eclipse.tptp.platform.analysis.core.rule.IAnalysisRule;

public class CodeReviewRealtimeResult {
    IResource resource;
    IAnalysisRule rule;
    int lineNumber;
    int startPos;
    int endPos;
    IMarker marker;

    public CodeReviewRealtimeResult(IResource resource, IAnalysisRule rule, int startPos, int endPos, int lineNumber) {
        this.resource = resource;
        this.rule = rule;
        this.startPos = startPos;
        this.endPos = endPos;
        this.lineNumber = lineNumber;
    }

    public void createMarker() {
        try {
            this.marker = this.resource.createMarker("org.eclipse.tptp.platform.analysis.codereview.java.analysismarker");
            this.marker.setAttribute("priority", 1);
            this.marker.setAttribute("priority", 1);
            this.marker.setAttribute("severity", 2);
            this.marker.setAttribute("charStart", this.startPos);
            this.marker.setAttribute("charEnd", this.endPos);
            this.marker.setAttribute("lineNumber", this.lineNumber);
            this.marker.setAttribute("message", (Object)this.rule.getLabelWithVariables());
        }
        catch (CoreException coreException) {
            this.marker = null;
        }
    }

    public void destroyMarker() {
        if (this.marker != null) {
            try {
                this.marker.delete();
            }
            catch (CoreException e) {
                Log.severe((String)"", (Throwable)e);
            }
        }
    }

    public boolean equals(CodeReviewRealtimeResult result) {
        return this.rule.equals(result.rule) && this.lineNumber == result.lineNumber && this.startPos == result.startPos && this.endPos == result.endPos;
    }
}

