/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.ui;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tptp.platform.analysis.core.element.IAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.rule.IAnalysisRule;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class AnalysisUIPlugin
extends AbstractUIPlugin {
    private static final String TRANSLATE_PATH_ARGUMENT = "$nl$";
    private static final String IMAGES = "icons";
    private static AnalysisUIPlugin plugin;
    private static Hashtable iconCache;
    private static Image unknownImage;
    static /* synthetic */ Class class$0;

    public AnalysisUIPlugin() {
        plugin = this;
        iconCache = new Hashtable();
    }

    public static String getPluginId() {
        return Platform.getBundle((String)"org.eclipse.tptp.platform.analysis.core.ui").getSymbolicName();
    }

    public static Image getImage(URL url) {
        if (url != null) {
            String urlStr = url.toExternalForm();
            Image img = (Image)iconCache.get(urlStr);
            if (img == null) {
                img = ImageDescriptor.createFromURL((URL)url).createImage();
                iconCache.put(urlStr, img);
            }
            return img;
        }
        if (unknownImage == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.ISharedImages");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            unknownImage = ImageDescriptor.createFromFile((Class)clazz, (String)"IMG_OBJS_WARN_TSK").createImage();
        }
        return unknownImage;
    }

    public static Image getImage(String filename) {
        return AnalysisUIPlugin.getImage(null, filename);
    }

    public static Image getImage(String pluginId, String filename) {
        String innerPluginId = pluginId == null ? AnalysisUIPlugin.getPluginId() : pluginId;
        URL url = null;
        Bundle bundle = Platform.getBundle((String)innerPluginId);
        if (bundle != null && (url = Platform.find((Bundle)bundle, (IPath)new Path(filename))) != null) {
            String urlStr = url.toExternalForm();
            Image img = (Image)iconCache.get(urlStr);
            if (img == null) {
                img = ImageDescriptor.createFromURL((URL)url).createImage();
                iconCache.put(urlStr, img);
            }
            return img;
        }
        if (unknownImage == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.ISharedImages");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            unknownImage = ImageDescriptor.createFromFile((Class)clazz, (String)"IMG_OBJS_WARN_TSK").createImage();
        }
        return unknownImage;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static AnalysisUIPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String filename) {
        IPath path = new Path(TRANSLATE_PATH_ARGUMENT).append("icons/" + filename);
        try {
            return ImageDescriptor.createFromURL((URL)plugin.find(path));
        }
        catch (Exception exception) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static String getStylesheet(String namespace, String filePath) {
        StringBuffer sb = new StringBuffer();
        Bundle bundle = Platform.getBundle((String)namespace);
        try {
            String location = Platform.resolve((URL)Platform.find((Bundle)bundle, (IPath)new Path(filePath))).toExternalForm();
            location = location.substring(6);
            BufferedReader bs = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(location), "UTF-16"));
            String s = bs.readLine();
            while (s != null) {
                sb.append(s).append("\n");
                s = bs.readLine();
            }
            bs.close();
        }
        catch (IOException iOException) {}
        return sb.toString();
    }

    public static void sortAnalysisElements(List list) {
        AnalysisUIPlugin.quickSort(list, 0, list.size() - 1);
    }

    /*
     * Unable to fully structure code
     */
    private static void quickSort(List list, int lo0, int hi0) {
        block5: {
            lo = lo0;
            hi = hi0;
            mid = null;
            if (hi0 <= lo0) break block5;
            mid = (IAnalysisElement)list.get((lo0 + hi0) / 2);
            ** GOTO lbl17
            {
                ++lo;
                do {
                    if (lo < hi0 && AnalysisUIPlugin.compare((IAnalysisElement)list.get(lo), mid) < 0) continue block0;
                    while (hi > lo0 && AnalysisUIPlugin.compare((IAnalysisElement)list.get(hi), mid) > 0) {
                        --hi;
                    }
                    if (lo > hi) continue;
                    AnalysisUIPlugin.swap(list, lo, hi);
                    ++lo;
                    --hi;
lbl17:
                    // 3 sources

                } while (lo <= hi);
            }
            if (lo0 < hi) {
                AnalysisUIPlugin.quickSort(list, lo0, hi);
            }
            if (lo < hi0) {
                AnalysisUIPlugin.quickSort(list, lo, hi0);
            }
        }
    }

    private static void swap(List list, int i, int j) {
        IAnalysisElement temp = (IAnalysisElement)list.get(i);
        list.set(i, list.get(j));
        list.set(j, temp);
    }

    private static int compare(IAnalysisElement si1, IAnalysisElement si2) {
        String s1 = null;
        s1 = si1.getElementType() == 3 ? UCharacter.toLowerCase((String)((IAnalysisRule)si1).getLabelWithVariables()) : UCharacter.toLowerCase((String)si1.getLabel());
        String s2 = null;
        String string = s2 = si2.getElementType() == 3 ? UCharacter.toLowerCase((String)((IAnalysisRule)si2).getLabelWithVariables()) : UCharacter.toLowerCase((String)si2.getLabel());
        if (s1.equals(s2)) {
            return 0;
        }
        int maxLen = s1.length();
        if (s2.length() < maxLen) {
            maxLen = s2.length();
        }
        int iCtr = 0;
        while (iCtr < maxLen) {
            if (UTF16.charAt((String)s1, (int)iCtr) < UTF16.charAt((String)s2, (int)iCtr)) {
                return -1;
            }
            if (UTF16.charAt((String)s1, (int)iCtr) > UTF16.charAt((String)s2, (int)iCtr)) {
                return 1;
            }
            ++iCtr;
        }
        if (s1.length() < s2.length()) {
            return -1;
        }
        if (s1.length() > s2.length()) {
            return 1;
        }
        return 0;
    }
}

