/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.ui.internal.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.tptp.platform.analysis.core.logging.Log;
import org.eclipse.tptp.platform.analysis.core.ui.internal.launch.AnalysisLaunchConfigurationDelegate;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class AnalyzeLastAction
implements IWorkbenchWindowActionDelegate {
    public static final String ANALYZE_MODE = "analyze";
    private IAction fAction;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        try {
            ILaunchConfiguration configuration = this.getLastLaunch();
            if (configuration != null && configuration.supportsMode(this.getMode())) {
                DebugUITools.launch((ILaunchConfiguration)configuration, (String)this.getMode());
            }
        }
        catch (CoreException ce) {
            Log.severe((String)"", (Throwable)ce);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.fAction == null) {
            this.fAction = action;
            action.setEnabled(this.existsConfigTypesForMode());
        }
    }

    private boolean existsConfigTypesForMode() {
        ILaunchConfigurationType[] configTypes = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
        int i = 0;
        while (i < configTypes.length) {
            ILaunchConfigurationType configType = configTypes[i];
            if (configType.supportsMode(this.getMode())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected ILaunchConfiguration getLastLaunch() {
        return AnalysisLaunchConfigurationDelegate.getLastLaunch();
    }

    public String getMode() {
        return ANALYZE_MODE;
    }

    public String getLaunchGroupId() {
        return "org.eclipse.tptp.platform.analysis.core.ui.launchGroup.analysis";
    }
}

