/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.ui.internal.help;

import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.analysis.core.logging.Log;
import org.eclipse.tptp.platform.analysis.core.ui.internal.help.HelpUtil;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;

public class TreeSelectionChanged
implements ISelectionChangedListener {
    public static final int VIEW_REFERENCE_STYLE = 0;
    public static final int DIALOG_STYLE = 1;
    private int helpStyle = 0;

    public TreeSelectionChanged(int helpStyle) {
        if (helpStyle != 0 && helpStyle != 1) {
            Log.severe((String)"Invalid help style");
        }
        this.helpStyle = helpStyle;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection s = event.getSelection();
        if (s.isEmpty()) {
            return;
        }
        if (!(s instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)s;
        Object firstSelected = ss.getFirstElement();
        if (this.helpStyle == 0 && this.isContextHelpViewDisplayed() || this.helpStyle == 1 && this.isContextHelpDialogDisplayed()) {
            HelpUtil.displayHelp(firstSelected);
        }
    }

    private boolean isContextHelpDialogDisplayed() {
        Shell[] shells = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getShells();
        int i = 0;
        while (i < shells.length) {
            Object data = shells[i].getData();
            if (data instanceof TrayDialog && ((TrayDialog)data).getTray() != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isContextHelpViewDisplayed() {
        IViewReference[] vrs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
        int i = 0;
        while (i < vrs.length) {
            if (vrs[i].getId().equals("org.eclipse.help.ui.HelpView") && vrs[i].getView(false) != null) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

