/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.ui.internal.launch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tptp.platform.analysis.core.AnalysisCorePlugin;
import org.eclipse.tptp.platform.analysis.core.CoreMessages;
import org.eclipse.tptp.platform.analysis.core.element.IAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.history.AnalysisHistory;
import org.eclipse.tptp.platform.analysis.core.history.AnalysisHistoryElement;
import org.eclipse.tptp.platform.analysis.core.history.AnalysisHistoryFactory;
import org.eclipse.tptp.platform.analysis.core.logging.Log;
import org.eclipse.tptp.platform.analysis.core.manager.AbstractAnalysisProviderManager;
import org.eclipse.tptp.platform.analysis.core.manager.IAnalysisListener;
import org.eclipse.tptp.platform.analysis.core.manager.IAnalysisProviderManager;
import org.eclipse.tptp.platform.analysis.core.rule.IAnalysisRule;
import org.eclipse.tptp.platform.analysis.core.rule.RuleParameter;
import org.eclipse.tptp.platform.analysis.core.ui.UIMessages;
import org.eclipse.tptp.platform.analysis.core.ui.internal.model.ResultsModel;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class AnalysisLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    private static ILaunchConfiguration lastLaunch;

    public void launch(ILaunchConfiguration inputConf, String mode, ILaunch launch, IProgressMonitor parentProgress) throws CoreException {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.tptp.platform.analysis.core.ui.views.ResultsView");
                }
                catch (PartInitException e) {
                    Log.severe((String)UIMessages.RESULT_VIEW_CREATE_ERROR_, (Throwable)e);
                }
            }
        });
        ILaunchConfiguration conf = inputConf;
        if (conf == null) {
            conf = lastLaunch;
        }
        try {
            AnalysisHistory history = AnalysisHistoryFactory.instance().createAnalysisHistory(conf.getName());
            this.buildSelectionList(conf, history);
            List managers = AbstractAnalysisProviderManager.getProviderManagers();
            Iterator it = managers.iterator();
            while (it.hasNext()) {
                IAnalysisProviderManager manager = (IAnalysisProviderManager)it.next();
                manager.addAnalysisListener((IAnalysisListener)ResultsModel.instance());
                int scope = conf.getAttribute("analysisInput", 0);
                if (scope == 0) {
                    this.analyzeWorkspace(conf, manager, history);
                    continue;
                }
                if (scope == 1) {
                    this.analyzeWorkingset(conf, manager, history);
                    continue;
                }
                if (scope == 2) {
                    this.analyzeProject(conf, manager, history);
                    continue;
                }
                if (scope != 3) continue;
                this.analyzeSingle(conf, manager, history);
            }
        }
        catch (CoreException e) {
            Log.severe((String)CoreMessages.PROVIDER_BUILD_ERROR_, (Throwable)e);
        }
        lastLaunch = conf;
    }

    private void analyzeWorkspace(ILaunchConfiguration conf, IAnalysisProviderManager manager, AnalysisHistory history) {
        ArrayList<IProject> list = new ArrayList<IProject>();
        IProject[] projectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int iCtr = 0;
        while (iCtr < projectArray.length) {
            if (projectArray[iCtr].isOpen()) {
                list.add(projectArray[iCtr]);
            }
            ++iCtr;
        }
        manager.analyze(history, list);
    }

    private void analyzeWorkingset(ILaunchConfiguration conf, IAnalysisProviderManager manager, AnalysisHistory history) {
        ArrayList<IAdaptable> list = new ArrayList<IAdaptable>();
        try {
            List projects = conf.getAttribute("analysisWorkingSetList", new ArrayList());
            IWorkingSetManager wsMgr = AnalysisCorePlugin.getDefault().getWorkbench().getWorkingSetManager();
            Iterator it2 = projects.iterator();
            while (it2.hasNext()) {
                IWorkingSet ws = wsMgr.getWorkingSet((String)it2.next());
                if (ws == null) continue;
                IAdaptable[] adapt = ws.getElements();
                int iCtr = 0;
                while (iCtr < adapt.length) {
                    if (adapt[iCtr] instanceof IResource) {
                        list.add(adapt[iCtr]);
                    }
                    ++iCtr;
                }
            }
            manager.analyze(history, list);
        }
        catch (CoreException e) {
            Log.severe((String)"", (Throwable)e);
        }
    }

    private void analyzeProject(ILaunchConfiguration conf, IAnalysisProviderManager manager, AnalysisHistory history) {
        ArrayList<IProject> list = new ArrayList<IProject>();
        try {
            List projects = conf.getAttribute("analysisProjectList", new ArrayList());
            Iterator it2 = projects.iterator();
            while (it2.hasNext()) {
                list.add(ResourcesPlugin.getWorkspace().getRoot().getProject((String)it2.next()));
            }
            manager.analyze(history, list);
        }
        catch (CoreException e) {
            Log.severe((String)"", (Throwable)e);
        }
    }

    private void analyzeSingle(ILaunchConfiguration conf, IAnalysisProviderManager manager, AnalysisHistory history) {
        ArrayList list = new ArrayList();
        try {
            List resource = conf.getAttribute("analysisResource", new ArrayList());
            Iterator it2 = resource.iterator();
            while (it2.hasNext()) {
                list.add(it2.next());
            }
            manager.analyze(history, list);
        }
        catch (CoreException e) {
            Log.severe((String)"", (Throwable)e);
        }
    }

    private void buildSelectionList(ILaunchConfiguration conf, AnalysisHistory history) {
        List managers = AbstractAnalysisProviderManager.getProviderManagers();
        Iterator it = managers.iterator();
        while (it.hasNext()) {
            IAnalysisProviderManager manager = (IAnalysisProviderManager)it.next();
            this.buildChildren(conf, history, (IAnalysisElement)manager, null);
        }
    }

    private void buildChildren(ILaunchConfiguration conf, AnalysisHistory history, IAnalysisElement parent, AnalysisHistoryElement parentNode) {
        List elements = parent.getOwnedElements();
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            IAnalysisElement element = (IAnalysisElement)it.next();
            try {
                IAnalysisRule rule;
                if (!conf.getAttribute(element.getId(), false)) continue;
                AnalysisHistoryElement node = new AnalysisHistoryElement(history, parentNode, element);
                if (element instanceof IAnalysisRule && (rule = (IAnalysisRule)element).getParameterCount() > 0) {
                    List list = rule.getParameterList();
                    Iterator it2 = list.iterator();
                    while (it2.hasNext()) {
                        RuleParameter rv = (RuleParameter)it2.next();
                        rv.setValue(conf.getAttribute(String.valueOf(element.getId()) + ".variable." + rv.getName(), rv.getValue()));
                    }
                    node.setRuleVariables(list);
                }
                if (element.getOwnedElements() == null) continue;
                this.buildChildren(conf, history, element, node);
            }
            catch (CoreException e) {
                Log.severe((String)"", (Throwable)e);
            }
        }
    }

    public static ILaunchConfiguration getLastLaunch() {
        return lastLaunch;
    }
}

