/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.ui.internal.launch;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.tptp.platform.analysis.core.configuration.IAnalysisConfiguration;
import org.eclipse.tptp.platform.analysis.core.element.IAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.logging.Log;
import org.eclipse.tptp.platform.analysis.core.rule.IAnalysisRule;
import org.eclipse.tptp.platform.analysis.core.rule.RuleDetailProvider;
import org.eclipse.tptp.platform.analysis.core.ui.UIMessages;
import org.eclipse.tptp.platform.analysis.core.ui.details.IDetailProvider;
import org.eclipse.tptp.platform.analysis.core.ui.internal.launch.VariableComposite;

public class ConfigurationComposite
extends Composite {
    public static final String FIELD_ID = "id";
    public static final String FIELD_CLASS = "class";
    public static final String FIELD_LABEL = "label";
    private VariableComposite variableComposite;
    private TabFolder tabs;
    private IAnalysisConfiguration config;
    private IAnalysisElement element;
    private HashMap detailProviderMap;

    public ConfigurationComposite(Composite parent) {
        super(parent, 0);
        GridData data = new GridData(1808);
        super.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(1, false);
        super.setLayout((Layout)layout);
        new Label((Composite)this, 0).setText(UIMessages.provider_tab_configuration_description);
        this.tabs = new TabFolder((Composite)this, 0);
        this.tabs.setLayoutData((Object)data);
        this.detailProviderMap = new HashMap();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.tptp.platform.analysis.core.ui.analysisDetailProvider");
        IExtension[] extensions = extensionPoint.getExtensions();
        int iCtr = 0;
        while (iCtr < extensions.length) {
            IConfigurationElement[] elements = extensions[iCtr].getConfigurationElements();
            int jCtr = 0;
            while (jCtr < elements.length) {
                ConfigurationDetailProvider detailDescriptor = new ConfigurationDetailProvider();
                String id = elements[jCtr].getAttribute(FIELD_ID);
                detailDescriptor.label = elements[jCtr].getAttribute(FIELD_LABEL);
                try {
                    detailDescriptor.detailProvider = (IDetailProvider)Class.forName(elements[jCtr].getAttribute(FIELD_CLASS)).newInstance();
                    detailDescriptor.detailProvider.initializeDetails((Composite)this.tabs);
                    this.detailProviderMap.put(id, detailDescriptor);
                }
                catch (Exception e) {
                    Log.severe((String)"", (Throwable)e);
                }
                ++jCtr;
            }
            ++iCtr;
        }
    }

    public void showDetails(IAnalysisElement showElement) {
        List details;
        IAnalysisRule rule;
        if (showElement != null) {
            this.changing();
        }
        this.element = showElement;
        int selectedTab = this.tabs.getSelectionIndex();
        this.tabs.setVisible(false);
        while (this.tabs.getItemCount() > 0) {
            this.tabs.getItem(0).dispose();
        }
        this.variableComposite = null;
        if (this.element instanceof IAnalysisRule && (rule = (IAnalysisRule)this.element).getVisibleVariableCount() > 0) {
            TabItem variableTab = new TabItem(this.tabs, 0);
            variableTab.setText(UIMessages.provider_tab_configuration_variables);
            this.variableComposite = new VariableComposite((Composite)this.tabs, rule);
            variableTab.setControl((Control)this.variableComposite);
        }
        if ((details = this.element.getDetailProviders()) != null) {
            Iterator it = details.iterator();
            while (it.hasNext()) {
                RuleDetailProvider provider = (RuleDetailProvider)it.next();
                try {
                    String id = provider.getProviderId();
                    ConfigurationDetailProvider descriptor = (ConfigurationDetailProvider)this.detailProviderMap.get(id);
                    TabItem detailTab = new TabItem(this.tabs, 0);
                    detailTab.setText(descriptor.label);
                    detailTab.setControl((Control)descriptor.detailProvider.createDetails(provider));
                }
                catch (Exception e) {
                    Log.severe((String)"", (Throwable)e);
                }
            }
        }
        if (this.config != null) {
            this.config.saveConfiguration(this.element);
        }
        this.config = this.element.getConfiguration();
        if (this.config != null) {
            this.config.addTabItems(this.tabs, this.element);
            this.config.loadConfiguration(this.element);
        }
        this.tabs.setVisible(true);
        if (this.tabs.getItemCount() > selectedTab) {
            this.tabs.setSelection(selectedTab);
        }
    }

    public void save() {
        this.variableComposite.changing();
    }

    private void changing() {
        if (this.variableComposite != null) {
            this.variableComposite.changing();
        }
    }

    public IAnalysisConfiguration getConfig() {
        return this.config;
    }

    public IAnalysisElement getElement() {
        return this.element;
    }

    class ConfigurationDetailProvider {
        public String label;
        public IDetailProvider detailProvider;

        ConfigurationDetailProvider() {
        }
    }
}

