/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.ui.internal.launch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.tptp.platform.analysis.core.logging.Log;
import org.eclipse.tptp.platform.analysis.core.ui.AnalysisUIPlugin;
import org.eclipse.tptp.platform.analysis.core.ui.UIMessages;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class InputTab
extends AbstractLaunchConfigurationTab
implements SelectionListener {
    public static final String CONTEXT_HELP_ID = "org.eclipse.tptp.platform.analysis.core.ui.InputTab";
    private Button radioAll;
    private Button radioWorkingSet;
    private Button radioProjects;
    private Button buttonSelectAll;
    private Button buttonDeselectAll;
    private Table workingSetList;
    private Table projectList;

    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, CONTEXT_HELP_ID);
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(1, false));
        content.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)content);
        this.radioAll = new Button(content, 16);
        this.radioAll.setSelection(true);
        this.radioAll.setText(UIMessages.input_radio_all);
        this.radioAll.setLayoutData((Object)new GridData(768));
        this.radioAll.addSelectionListener((SelectionListener)this);
        this.radioWorkingSet = new Button(content, 16);
        this.radioWorkingSet.setText(UIMessages.input_radio_workingSet);
        this.radioWorkingSet.setLayoutData((Object)new GridData(768));
        this.radioWorkingSet.addSelectionListener((SelectionListener)this);
        this.createWorkingSetGroup(content);
        Label invisible3 = new Label(content, 0);
        invisible3.setLayoutData((Object)new GridData(768));
        this.radioProjects = new Button(content, 16);
        this.radioProjects.setSelection(false);
        this.radioProjects.setText(UIMessages.input_radio_projects);
        this.radioProjects.setLayoutData((Object)new GridData(768));
        this.radioProjects.addSelectionListener((SelectionListener)this);
        this.createProjectGroup(content);
    }

    private void createWorkingSetGroup(Composite content) {
        this.workingSetList = new Table(content, 2820);
        GridData data = new GridData(1808);
        data.verticalSpan = 6;
        data.heightHint = 210;
        data.horizontalIndent = 25;
        this.workingSetList.setLayoutData((Object)data);
        this.workingSetList.addSelectionListener((SelectionListener)this);
        IWorkingSetManager wsMgr = AnalysisUIPlugin.getDefault().getWorkbench().getWorkingSetManager();
        IWorkingSet[] workingSets = wsMgr.getWorkingSets();
        int iCtr = 0;
        while (iCtr < workingSets.length) {
            if ("org.eclipse.ui.resourceWorkingSetPage".equals(workingSets[iCtr].getId())) {
                TableItem item = new TableItem(this.workingSetList, 0);
                item.setText(workingSets[iCtr].getName());
                item.setImage(new Image((Device)this.workingSetList.getDisplay(), workingSets[iCtr].getImage().getImageData()));
            }
            ++iCtr;
        }
    }

    private void createProjectGroup(Composite content) {
        this.projectList = new Table(content, 2852);
        GridData data = new GridData(1808);
        data.horizontalSpan = 5;
        data.verticalSpan = 6;
        data.horizontalIndent = 25;
        this.projectList.setLayoutData((Object)data);
        this.projectList.addSelectionListener((SelectionListener)this);
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int iCtr = 0;
        while (iCtr < projects.length) {
            if (projects[iCtr].isOpen()) {
                TableItem item = new TableItem(this.projectList, 32);
                item.setText(projects[iCtr].getName());
                item.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT"));
            }
            ++iCtr;
        }
        Label invisible = new Label(content, 0);
        data = new GridData(768);
        data.horizontalSpan = 3;
        invisible.setLayoutData((Object)data);
        Composite buttons = new Composite(content, 0);
        buttons.setLayoutData((Object)new GridData(1808));
        this.buttonSelectAll = new Button(buttons, 8);
        this.buttonSelectAll.setText(UIMessages.input_button_selectAll);
        this.buttonSelectAll.setLayoutData((Object)new GridData(768));
        this.buttonSelectAll.addSelectionListener((SelectionListener)this);
        this.buttonDeselectAll = new Button(buttons, 8);
        this.buttonDeselectAll.setText(UIMessages.input_button_deselectAll);
        this.buttonDeselectAll.setLayoutData((Object)new GridData(768));
        this.buttonDeselectAll.addSelectionListener((SelectionListener)this);
        this.projectList.setEnabled(false);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.radioAll)) {
            this.enableAll();
            this.updateLaunchConfigurationDialog();
        }
        if (e.getSource().equals(this.radioWorkingSet)) {
            this.enableWorkingSetList();
            this.updateLaunchConfigurationDialog();
        } else if (e.getSource().equals(this.radioProjects)) {
            this.enablePojectList();
            this.updateLaunchConfigurationDialog();
        } else if (e.getSource().equals(this.buttonSelectAll)) {
            TableItem[] items = this.projectList.getItems();
            int jCtr = 0;
            while (jCtr < items.length) {
                items[jCtr].setChecked(true);
                ++jCtr;
            }
        } else if (e.getSource().equals(this.buttonDeselectAll)) {
            TableItem[] items = this.projectList.getItems();
            int jCtr = 0;
            while (jCtr < items.length) {
                items[jCtr].setChecked(false);
                ++jCtr;
            }
        } else if (e.getSource().equals(this.projectList)) {
            this.updateLaunchConfigurationDialog();
        } else if (e.getSource().equals(this.workingSetList)) {
            this.updateLaunchConfigurationDialog();
        }
    }

    private void enableAll() {
        this.radioAll.setSelection(true);
        this.radioWorkingSet.setSelection(false);
        this.radioProjects.setSelection(false);
        this.projectList.setEnabled(false);
        this.workingSetList.setEnabled(false);
        this.workingSetList.setEnabled(false);
        this.projectList.setEnabled(false);
        this.projectList.deselectAll();
        TableItem[] items = this.projectList.getItems();
        int jCtr = 0;
        while (jCtr < items.length) {
            items[jCtr].setChecked(false);
            ++jCtr;
        }
    }

    private void enableWorkingSetList() {
        this.radioAll.setSelection(false);
        this.radioWorkingSet.setSelection(true);
        this.radioProjects.setSelection(false);
        this.projectList.setEnabled(false);
        this.workingSetList.setEnabled(true);
        this.workingSetList.setEnabled(true);
        this.projectList.setEnabled(false);
        this.projectList.deselectAll();
        TableItem[] items = this.projectList.getItems();
        int jCtr = 0;
        while (jCtr < items.length) {
            items[jCtr].setChecked(false);
            ++jCtr;
        }
        Control[] controls = this.projectList.getChildren();
        int jCtr2 = 0;
        while (jCtr2 < controls.length) {
            controls[jCtr2].setEnabled(false);
            ++jCtr2;
        }
    }

    private void enablePojectList() {
        this.radioAll.setSelection(false);
        this.radioWorkingSet.setSelection(false);
        this.radioProjects.setSelection(true);
        this.projectList.setEnabled(true);
        this.workingSetList.setEnabled(false);
        this.workingSetList.setEnabled(false);
        this.projectList.setEnabled(true);
        this.workingSetList.deselectAll();
        Control[] controls = this.projectList.getChildren();
        int jCtr = 0;
        while (jCtr < controls.length) {
            controls[jCtr].setEnabled(true);
            ++jCtr;
        }
    }

    private void selectWorkingSet(List list) {
        TableItem[] items = this.workingSetList.getItems();
        int jCtr = 0;
        while (jCtr < items.length) {
            int iCtr = 0;
            while (iCtr < list.size()) {
                if (items[jCtr].getText().equals(list.get(iCtr))) {
                    this.workingSetList.select(jCtr);
                }
                ++iCtr;
            }
            ++jCtr;
        }
    }

    private void selectProjects(List list) {
        TableItem[] items = this.projectList.getItems();
        int jCtr = 0;
        while (jCtr < items.length) {
            items[jCtr].setChecked(false);
            ++jCtr;
        }
        int iCtr = 0;
        while (iCtr < list.size()) {
            String select = (String)list.get(iCtr);
            int jCtr2 = 0;
            while (jCtr2 < items.length) {
                if (items[jCtr2].getText().equals(select)) {
                    items[jCtr2].setChecked(true);
                }
                ++jCtr2;
            }
            ++iCtr;
        }
    }

    public boolean isValid(ILaunchConfiguration conf) {
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy wc) {
        wc.setAttribute("analysisInput", 0);
        wc.setAttribute("analysisWorkspace", new ArrayList());
        wc.setAttribute("analysisProjectList", new ArrayList());
        wc.setAttribute("analysisWorkingSetList", new ArrayList());
    }

    public void initializeFrom(ILaunchConfiguration conf) {
        try {
            this.enableWorkingSetList();
            this.workingSetList.deselectAll();
            this.projectList.deselectAll();
            int radioSelection = conf.getAttribute("analysisInput", 0);
            if (radioSelection == 0) {
                this.enableAll();
            } else if (radioSelection == 1) {
                this.enableWorkingSetList();
                this.selectWorkingSet(conf.getAttribute("analysisWorkingSetList", new ArrayList()));
            } else {
                this.enablePojectList();
                this.selectProjects(conf.getAttribute("analysisProjectList", new ArrayList()));
            }
        }
        catch (Exception e) {
            Log.severe((String)UIMessages.INPUT_TAB_ERROR_, (Throwable)e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        if (this.radioAll.getSelection()) {
            wc.setAttribute("analysisInput", 0);
            wc.setAttribute("analysisWorkingSetList", new ArrayList());
            wc.setAttribute("analysisProjectList", new ArrayList());
        } else if (this.radioWorkingSet.getSelection()) {
            TableItem[] items = this.workingSetList.getSelection();
            ArrayList<String> l = new ArrayList<String>();
            int iCtr = 0;
            while (iCtr < items.length) {
                l.add(items[iCtr].getText());
                ++iCtr;
            }
            wc.setAttribute("analysisInput", 1);
            wc.setAttribute("analysisWorkingSetList", l);
            wc.setAttribute("analysisProjectList", new ArrayList());
        } else {
            ArrayList<String> l = new ArrayList<String>();
            TableItem[] items = this.projectList.getItems();
            int jCtr = 0;
            while (jCtr < items.length) {
                if (items[jCtr].getChecked()) {
                    l.add(items[jCtr].getText());
                }
                ++jCtr;
            }
            wc.setAttribute("analysisInput", 2);
            wc.setAttribute("analysisProjectList", l);
            wc.setAttribute("analysisWorkingSetList", new ArrayList());
        }
    }

    public String getName() {
        return UIMessages.input_tab_name;
    }

    public Image getImage() {
        return AnalysisUIPlugin.getImageDescriptor("analysisinput_nav.gif").createImage();
    }
}

