/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.ui.internal.launch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tptp.platform.analysis.core.AnalysisCorePlugin;
import org.eclipse.tptp.platform.analysis.core.element.IAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.rule.IAnalysisRule;
import org.eclipse.tptp.platform.analysis.core.ui.AnalysisUIPlugin;
import org.eclipse.tptp.platform.analysis.core.ui.UIMessages;
import org.eclipse.tptp.platform.analysis.core.ui.internal.launch.DomainComposite;
import org.eclipse.tptp.platform.analysis.core.ui.internal.launch.ElementDetailsDialog;
import org.eclipse.tptp.platform.analysis.core.ui.internal.model.DomainModel;
import org.eclipse.ui.PlatformUI;

public class ProviderTab
extends AbstractLaunchConfigurationTab
implements SelectionListener {
    public static final String CONTEXT_HELP_ID = "org.eclipse.tptp.platform.analysis.core.ui.ProviderTab";
    private final String FILE_FILTER = "*.xml";
    private DomainComposite dc;
    private Composite content;
    private Button importButton;
    private Button exportButton;
    private Button detailsButton;
    private Button templateSet;
    private Combo templateCombo;
    private static List ruleSetIdList = null;
    private static Map ruleSetMap = null;
    private static Map ruleSetLabel = null;

    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, CONTEXT_HELP_ID);
        this.content = new Composite(parent, 0);
        this.content.setLayout((Layout)new GridLayout(1, false));
        this.content.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)this.content);
        this.dc = new DomainComposite(this.content);
        this.dc.getDomainTree().addSelectionListener((SelectionListener)this);
        Composite buttonComp = new Composite(this.content, 0);
        buttonComp.setLayout((Layout)new GridLayout(4, false));
        buttonComp.setLayoutData((Object)new GridData(768));
        this.importButton = new Button(buttonComp, 8);
        this.importButton.setText(UIMessages.provider_tab_button_import);
        this.importButton.setToolTipText(UIMessages.provider_tab_button_tooltip_import);
        this.importButton.addSelectionListener((SelectionListener)this);
        this.exportButton = new Button(buttonComp, 8);
        this.exportButton.setText(UIMessages.provider_tab_button_export);
        this.exportButton.setToolTipText(UIMessages.provider_tab_button_tooltip_export);
        this.exportButton.addSelectionListener((SelectionListener)this);
        this.detailsButton = new Button(buttonComp, 8);
        this.detailsButton.setText(UIMessages.provider_tab_button_details);
        this.detailsButton.setToolTipText(UIMessages.provider_tab_button_tooltip_details);
        this.detailsButton.addSelectionListener((SelectionListener)this);
        this.detailsButton.setEnabled(false);
        Composite gapComp = new Composite(this.content, 0);
        gapComp.setLayout((Layout)new GridLayout(1, false));
        gapComp.setLayoutData((Object)new GridData(768));
        Composite templateComp = new Composite(this.content, 0);
        templateComp.setLayout((Layout)new GridLayout(3, false));
        templateComp.setLayoutData((Object)new GridData(768));
        new Label(templateComp, 0).setText(UIMessages.provider_tab_templates_label);
        this.templateCombo = new Combo(templateComp, 0);
        this.templateCombo.setLayoutData((Object)new GridData(768));
        this.loadRuleTemplates();
        this.templateSet = new Button(templateComp, 8);
        this.templateSet.setText(UIMessages.provider_tab_templates_button);
        this.templateSet.setToolTipText(UIMessages.provider_tab_templates_button_tooltip);
        this.templateSet.addSelectionListener((SelectionListener)this);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.importButton)) {
            this.handleImport();
        } else if (e.getSource().equals(this.exportButton)) {
            this.handleExport();
        } else if (e.getSource().equals(this.templateSet)) {
            this.handleRuleSet();
        } else if (e.getSource().equals(this.detailsButton)) {
            this.handleElementDetails();
        } else if (e.getSource().equals(this.dc.getDomainTree())) {
            IAnalysisElement element = (IAnalysisElement)e.item.getData();
            this.dc.getDomainTree().redraw();
            this.updateLaunchConfigurationDialog();
            if (element != null && element.getElementType() == 3) {
                IAnalysisRule rule = (IAnalysisRule)element;
                if (rule.getParameterCount() > 0) {
                    this.detailsButton.setEnabled(true);
                } else {
                    this.detailsButton.setEnabled(false);
                }
            }
        }
    }

    private void handleElementDetails() {
        IStructuredSelection selection = (IStructuredSelection)this.dc.getDomainTreeViewer().getSelection();
        IAnalysisRule element = (IAnalysisRule)selection.getFirstElement();
        Point pt = this.getShell().getLocation();
        pt.x += 200;
        pt.y += 210;
        Rectangle rect = this.dc.getDomainTree().getSelection()[0].getBounds();
        pt.x += rect.x;
        pt.y += rect.y;
        ElementDetailsDialog dlg = new ElementDetailsDialog(this.getShell(), (IAnalysisElement)element, pt.x, pt.y);
        dlg.open();
        this.dc.getDomainTreeViewer().refresh(true);
    }

    private void handleRuleSet() {
        int index = this.templateCombo.getSelectionIndex();
        if (index >= 0) {
            DomainModel.getInstance().reset();
            String id = (String)ruleSetIdList.get(index);
            ArrayList item = (ArrayList)ruleSetMap.get(id);
            List ruleList = (List)item.get(0);
            Iterator it = ruleList.iterator();
            while (it.hasNext()) {
                IAnalysisElement element = AnalysisCorePlugin.getAnalysisElement((String)((String)it.next()));
                if (element == null) continue;
                DomainModel.getInstance().selectTreeItem(element, true);
            }
            List categoryList = (List)item.get(1);
            Iterator it2 = categoryList.iterator();
            while (it2.hasNext()) {
                IAnalysisElement element = AnalysisCorePlugin.getAnalysisElement((String)((String)it2.next()));
                if (element == null) continue;
                DomainModel.getInstance().selectTreeItem(element, true);
            }
            DomainModel.getInstance().updateTree();
        }
    }

    private void handleExport() {
        FileDialog dialog = new FileDialog(AnalysisUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.xml"});
        String path = dialog.open();
        if (path != null) {
            DomainModel.getInstance().exportToFile(path);
        }
    }

    private void handleImport() {
        FileDialog dialog = new FileDialog(AnalysisUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.xml"});
        String path = dialog.open();
        if (path != null) {
            DomainModel.getInstance().importFromFile(path);
        }
        DomainModel.getInstance().updateTree();
    }

    public boolean isValid(ILaunchConfiguration conf) {
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy wc) {
    }

    public void initializeFrom(ILaunchConfiguration conf) {
        this.dc.load(conf);
    }

    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        this.dc.save(wc);
    }

    public String getName() {
        return UIMessages.provider_tab_name;
    }

    public Image getImage() {
        return AnalysisUIPlugin.getImageDescriptor("analysisrules_nav.gif").createImage();
    }

    private void loadRuleTemplates() {
        if (ruleSetIdList == null) {
            ruleSetIdList = new ArrayList();
            ruleSetMap = new HashMap();
            ruleSetLabel = new HashMap();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.tptp.platform.analysis.core.analysisRuleSet");
            IExtension[] extensions = extensionPoint.getExtensions();
            int iCtr = 0;
            while (iCtr < extensions.length) {
                IConfigurationElement[] elements = extensions[iCtr].getConfigurationElements();
                int jCtr = 0;
                while (jCtr < elements.length) {
                    String id = elements[jCtr].getAttribute("id");
                    if (!id.equals("REALTIME")) {
                        String label = elements[jCtr].getAttribute("label");
                        if (label == null) {
                            label = "";
                        }
                        ArrayList item = null;
                        ArrayList<String> ruleItems = null;
                        ArrayList<String> categoryItems = null;
                        int index = ruleSetIdList.indexOf(id);
                        if (index >= 0) {
                            item = (ArrayList)ruleSetMap.get(id);
                            ruleItems = (ArrayList<String>)item.get(0);
                            categoryItems = (ArrayList<String>)item.get(1);
                            if (label.length() > 0) {
                                ruleSetLabel.put(id, label);
                            }
                        } else {
                            ruleSetIdList.add(id);
                            item = new ArrayList();
                            ruleItems = new ArrayList<String>();
                            item.add(ruleItems);
                            categoryItems = new ArrayList<String>();
                            item.add(categoryItems);
                            ruleSetMap.put(id, item);
                            ruleSetLabel.put(id, label);
                        }
                        IConfigurationElement[] children = elements[jCtr].getChildren("analysisRuleSetRule");
                        int kCtr = 0;
                        while (kCtr < children.length) {
                            ruleItems.add(children[kCtr].getAttribute("id"));
                            ++kCtr;
                        }
                        children = elements[jCtr].getChildren("analysisRuleSetCategory");
                        kCtr = 0;
                        while (kCtr < children.length) {
                            categoryItems.add(children[kCtr].getAttribute("id"));
                            ++kCtr;
                        }
                    }
                    ++jCtr;
                }
                ++iCtr;
            }
        }
        Iterator it = ruleSetIdList.iterator();
        while (it.hasNext()) {
            this.templateCombo.add((String)ruleSetLabel.get(it.next()));
        }
    }
}

