/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.ui.internal.launch;

import com.ibm.icu.text.NumberFormat;
import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.analysis.core.rule.IAnalysisRule;
import org.eclipse.tptp.platform.analysis.core.rule.RuleParameter;

public class VariableComposite
extends Composite {
    private static final String BLANK = "";
    private static final String TRUE = "true";
    private IAnalysisRule rule;
    private Control[] textFields;
    private List ruleVariableList;

    public VariableComposite(Composite parent, IAnalysisRule rule) {
        super(parent, 0);
        this.rule = rule;
        super.setLayoutData((Object)new GridData(1808));
        super.setLayout((Layout)new GridLayout(1, false));
        this.ruleVariableList = rule.getParameterList();
        this.textFields = new Control[this.ruleVariableList.size()];
        int fieldCount = 0;
        Iterator it = this.ruleVariableList.iterator();
        while (it.hasNext()) {
            RuleParameter rv = (RuleParameter)it.next();
            if (rv.getLabel() == null || rv.getLabel().length() <= 0) continue;
            new Label((Composite)this, 0).setText(rv.getLabel());
            if (rv.getStyle() == null) continue;
            if (rv.isTextStyle()) {
                this.textFields[fieldCount] = new Text((Composite)this, 2048);
                ((Text)this.textFields[fieldCount]).setText(rv.getValue());
                this.textFields[fieldCount].setLayoutData((Object)new GridData(768));
                ++fieldCount;
                continue;
            }
            if (rv.isCheckStyle()) {
                this.textFields[fieldCount] = new Button((Composite)this, 32);
                if (rv.getValue().equals(TRUE)) {
                    ((Button)this.textFields[fieldCount]).setSelection(true);
                }
                this.textFields[fieldCount].setLayoutData((Object)new GridData(768));
                ++fieldCount;
                continue;
            }
            if (!rv.isComboStyle() || rv.getComboValues() == null) continue;
            Combo c = new Combo((Composite)this, 2048);
            this.textFields[fieldCount] = c;
            Iterator it2 = rv.getComboValues().iterator();
            while (it2.hasNext()) {
                c.add((String)it2.next());
            }
            try {
                c.select(NumberFormat.getIntegerInstance().parse(rv.getValue()).intValue());
            }
            catch (ParseException parseException) {
                c.select(0);
            }
            this.textFields[fieldCount].setLayoutData((Object)new GridData(768));
            ++fieldCount;
        }
    }

    public void changing() {
        int iCtr = 0;
        while (iCtr < this.textFields.length) {
            RuleParameter rv = (RuleParameter)this.ruleVariableList.get(iCtr);
            if (rv.getLabel() != null && rv.getStyle() != null) {
                if (rv.isTextStyle()) {
                    if (rv.isStringType() || rv.isIntegerType() && this.isValid(rv, ((Text)this.textFields[iCtr]).getText())) {
                        rv.setValue(((Text)this.textFields[iCtr]).getText());
                    } else {
                        ((Text)this.textFields[iCtr]).setText(rv.getValue());
                    }
                } else if (rv.isCheckStyle()) {
                    rv.setValue(BLANK + ((Button)this.textFields[iCtr]).getSelection());
                } else if (rv.isComboStyle()) {
                    rv.setValue(BLANK + ((Combo)this.textFields[iCtr]).getSelectionIndex());
                }
                this.rule.addParameter(rv);
            }
            ++iCtr;
        }
    }

    public boolean isValid(RuleParameter parameter, String value) {
        if (parameter.isIntegerType()) {
            try {
                NumberFormat.getIntegerInstance().parse(value).intValue();
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }
        return true;
    }
}

