/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.ui.internal.model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tptp.platform.analysis.core.AnalysisCorePlugin;
import org.eclipse.tptp.platform.analysis.core.element.IAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.logging.Log;
import org.eclipse.tptp.platform.analysis.core.manager.AbstractAnalysisProviderManager;
import org.eclipse.tptp.platform.analysis.core.manager.IAnalysisProviderManager;
import org.eclipse.tptp.platform.analysis.core.rule.IAnalysisRule;
import org.eclipse.tptp.platform.analysis.core.rule.RuleParameter;
import org.eclipse.tptp.platform.analysis.core.ui.AnalysisUIPlugin;
import org.eclipse.tptp.platform.analysis.core.ui.UIMessages;
import org.eclipse.tptp.platform.analysis.core.ui.internal.model.DomainNode;

public class DomainModel
implements SelectionListener,
TreeListener {
    private static DomainModel instance;
    private HashMap elementNodeMap;
    private TreeViewer viewer;

    public DomainModel(TreeViewer viewer) {
        instance = this;
        this.viewer = viewer;
    }

    public static DomainModel getInstance() {
        return instance;
    }

    public void initialize() {
        this.elementNodeMap = new HashMap();
        List managers = AbstractAnalysisProviderManager.getProviderManagers();
        AnalysisUIPlugin.sortAnalysisElements(managers);
        Iterator it = managers.iterator();
        while (it.hasNext()) {
            IAnalysisProviderManager manager = (IAnalysisProviderManager)it.next();
            this.elementNodeMap.put(manager, new DomainNode());
            this.initialize((IAnalysisElement)manager);
        }
    }

    private void initialize(IAnalysisElement parent) {
        if (parent.getOwnedElements() != null) {
            AnalysisUIPlugin.sortAnalysisElements(parent.getOwnedElements());
            Iterator it = parent.getOwnedElements().iterator();
            while (it.hasNext()) {
                IAnalysisElement element = (IAnalysisElement)it.next();
                this.elementNodeMap.put(element, new DomainNode());
                this.initialize(element);
            }
        }
    }

    public void reset() {
        List managers = AbstractAnalysisProviderManager.getProviderManagers();
        Iterator it = managers.iterator();
        while (it.hasNext()) {
            this.reset((IAnalysisElement)((IAnalysisProviderManager)it.next()));
        }
        this.resetTree();
    }

    private void reset(IAnalysisElement parent) {
        if (parent.getOwnedElements() != null) {
            int iCtr = 0;
            while (iCtr < parent.getOwnedElements().size()) {
                IAnalysisElement element = (IAnalysisElement)parent.getOwnedElements().get(iCtr);
                DomainNode node = this.getDomainNode(element);
                if (node == null) {
                    node = new DomainNode();
                    this.elementNodeMap.put(element, node);
                }
                node.setGrayed(false);
                node.setChecked(false);
                if (element.getOwnedElements() != null) {
                    this.reset(element);
                }
                ++iCtr;
            }
        }
    }

    private void resetTree() {
        TreeItem[] items = this.viewer.getTree().getItems();
        this.resetTree(items);
        this.viewer.refresh(true);
        this.viewer.getTree().update();
    }

    private void resetTree(TreeItem[] items) {
        int iCtr = 0;
        while (iCtr < items.length) {
            IAnalysisElement element = (IAnalysisElement)items[iCtr].getData();
            if (element != null) {
                items[iCtr].setChecked(false);
                items[iCtr].setGrayed(false);
                TreeItem[] children = items[iCtr].getItems();
                if (children.length > 0) {
                    this.resetTree(children);
                }
            }
            ++iCtr;
        }
    }

    public void load(ILaunchConfiguration conf) {
        this.reset();
        List managers = AbstractAnalysisProviderManager.getProviderManagers();
        Iterator it = managers.iterator();
        while (it.hasNext()) {
            IAnalysisProviderManager manager = (IAnalysisProviderManager)it.next();
            this.load(conf, (IAnalysisElement)manager);
        }
        this.updateTree();
    }

    private void load(ILaunchConfiguration conf, IAnalysisElement parent) {
        if (parent.getOwnedElements() != null) {
            int iCtr = 0;
            while (iCtr < parent.getOwnedElements().size()) {
                IAnalysisRule rule;
                IAnalysisElement element = (IAnalysisElement)parent.getOwnedElements().get(iCtr);
                DomainNode node = this.getDomainNode(element);
                node.setGrayed(false);
                try {
                    node.setChecked(conf.getAttribute(element.getId(), false));
                }
                catch (CoreException e) {
                    Log.severe((String)("Unable to load: " + element.getId()));
                    Log.severe((String)"", (Throwable)e);
                }
                if (element instanceof IAnalysisRule && (rule = (IAnalysisRule)element).getParameterCount() > 0) {
                    List list = rule.getParameterList();
                    Iterator it2 = list.iterator();
                    while (it2.hasNext()) {
                        RuleParameter rv = (RuleParameter)it2.next();
                        try {
                            rv.setValue(conf.getAttribute(String.valueOf(element.getId()) + ".variable." + rv.getName(), ""));
                        }
                        catch (CoreException coreException) {
                            Log.severe((String)("Unable to load variable:" + element.getId() + ".variable." + rv.getName()));
                        }
                    }
                }
                if (node.isChecked()) {
                    this.greyParentTreeItems(element);
                    this.load(conf, element);
                }
                ++iCtr;
            }
        }
    }

    public void save(ILaunchConfigurationWorkingCopy conf) {
        List managers = AbstractAnalysisProviderManager.getProviderManagers();
        Iterator it = managers.iterator();
        while (it.hasNext()) {
            IAnalysisProviderManager manager = (IAnalysisProviderManager)it.next();
            this.save(conf, (IAnalysisElement)manager);
        }
    }

    private void save(ILaunchConfigurationWorkingCopy conf, IAnalysisElement parent) {
        if (parent.getOwnedElements() != null) {
            Iterator it = parent.getOwnedElements().iterator();
            while (it.hasNext()) {
                IAnalysisRule rule;
                IAnalysisElement element = (IAnalysisElement)it.next();
                DomainNode node = this.getDomainNode(element);
                conf.setAttribute(element.getId(), node.isChecked());
                if (element instanceof IAnalysisRule && (rule = (IAnalysisRule)element).getParameterCount() > 0) {
                    List list = rule.getParameterList();
                    Iterator it2 = list.iterator();
                    while (it2.hasNext()) {
                        RuleParameter rv = (RuleParameter)it2.next();
                        conf.setAttribute(String.valueOf(element.getId()) + ".variable." + rv.getName(), rv.getValue());
                    }
                }
                if (element.getOwnedElements() == null) continue;
                this.save(conf, element);
            }
        }
    }

    public void exportToFile(String filePath) {
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-16"));
            List managers = AbstractAnalysisProviderManager.getProviderManagers();
            Iterator it = managers.iterator();
            while (it.hasNext()) {
                this.exportToFile(bw, (IAnalysisElement)((IAnalysisProviderManager)it.next()));
            }
            bw.close();
        }
        catch (Exception e) {
            Log.severe((String)UIMessages.XML_EXPORT_ERROR_, (Throwable)e);
        }
    }

    private void exportToFile(BufferedWriter bw, IAnalysisElement parent) throws CoreException, IOException {
        if (parent.getOwnedElements() != null) {
            Iterator it = parent.getOwnedElements().iterator();
            while (it.hasNext()) {
                IAnalysisRule rule;
                IAnalysisElement element = (IAnalysisElement)it.next();
                DomainNode node = this.getDomainNode(element);
                if (node.isChecked()) {
                    bw.write(String.valueOf(element.getId()) + "\r\n");
                }
                if (element instanceof IAnalysisRule && (rule = (IAnalysisRule)element).getParameterCount() > 0) {
                    List list = rule.getParameterList();
                    Iterator it2 = list.iterator();
                    while (it2.hasNext()) {
                        RuleParameter rv = (RuleParameter)it2.next();
                        bw.write(String.valueOf(element.getId()) + ".variable." + rv.getName() + "," + rv.getValue() + "\r\n");
                    }
                }
                if (element.getOwnedElements() == null) continue;
                this.exportToFile(bw, element);
            }
        }
    }

    public void importFromFile(String filePath) {
        this.reset();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-16"));
            String id = br.readLine();
            while (id != null) {
                int index = id.indexOf(".variable.");
                if (index == -1) {
                    IAnalysisElement element = AnalysisCorePlugin.getAnalysisElement((String)id);
                    DomainNode node = this.getDomainNode(element);
                    node.setChecked(true);
                    node.setGrayed(false);
                    this.selectParentTreeItems(element, true);
                    this.greyParentTreeItems(element);
                } else {
                    int commaIndex = id.indexOf(",");
                    String ruleId = id.substring(0, index);
                    String variable = id.substring(index + 10, commaIndex);
                    String value = id.substring(commaIndex + 1);
                    IAnalysisRule rule = (IAnalysisRule)AnalysisCorePlugin.getAnalysisElement((String)ruleId);
                    RuleParameter rv = rule.getParameter(variable);
                    rv.setValue(value);
                }
                id = br.readLine();
            }
            br.close();
        }
        catch (Exception e) {
            Log.severe((String)UIMessages.XML_EXPORT_ERROR_, (Throwable)e);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        TreeItem item = (TreeItem)e.item;
        IAnalysisElement element = (IAnalysisElement)item.getData();
        DomainNode node = this.getDomainNode(element);
        if (e.detail == 32) {
            node.setChecked(item.getChecked());
            if (node.isChecked()) {
                this.selectParentTreeItems(element, true);
            }
            node.setGrayed(false);
            if (element.getOwnedElements() != null) {
                this.selectChildTreeItems(element.getOwnedElements(), node.isChecked());
            }
            this.greyParentTreeItems(element);
            this.updateTree();
        }
    }

    private void selectParentTreeItems(IAnalysisElement element, boolean state) {
        IAnalysisElement parentElement = element.getOwner();
        do {
            DomainNode node = this.getDomainNode(parentElement);
            node.setChecked(state);
        } while ((parentElement = parentElement.getOwner()) != null);
    }

    private void selectChildTreeItems(List childItems, boolean state) {
        int jCtr = 0;
        while (jCtr < childItems.size()) {
            IAnalysisElement element = (IAnalysisElement)childItems.get(jCtr);
            this.selectTreeItem(element, state);
            List list = element.getOwnedElements();
            if (list != null) {
                this.selectChildTreeItems(list, state);
            }
            ++jCtr;
        }
    }

    public void selectTreeItem(IAnalysisElement element, boolean state) {
        DomainNode node = this.getDomainNode(element);
        node.setChecked(state);
        node.setGrayed(false);
        this.selectParentTreeItems(element, state);
        List children = element.getOwnedElements();
        if (children != null) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                this.selectTreeItem((IAnalysisElement)it.next(), state);
            }
        }
        this.greyParentTreeItems(element);
    }

    public void greyParentTreeItems(IAnalysisElement element) {
        IAnalysisElement parentElement = element.getOwner();
        do {
            int childrenSelected = 0;
            List children = parentElement.getOwnedElements();
            if (children != null) {
                int iCtr = 0;
                while (iCtr < children.size()) {
                    IAnalysisElement child = (IAnalysisElement)children.get(iCtr);
                    DomainNode node = this.getDomainNode(child);
                    if (node.isChecked()) {
                        ++childrenSelected;
                    }
                    ++iCtr;
                }
            }
            DomainNode node = this.getDomainNode(parentElement);
            node.setGrayed(childrenSelected < children.size());
            if (childrenSelected == 0) {
                node.setChecked(false);
                node.setGrayed(false);
                continue;
            }
            node.setChecked(true);
        } while ((parentElement = parentElement.getOwner()) != null);
    }

    public void updateTree() {
        TreeItem[] items = this.viewer.getTree().getItems();
        this.updateTree(items);
        this.viewer.refresh(true);
        this.viewer.getTree().update();
    }

    private void updateTree(TreeItem[] items) {
        int iCtr = 0;
        while (iCtr < items.length) {
            IAnalysisElement element = (IAnalysisElement)items[iCtr].getData();
            if (element != null) {
                DomainNode node = this.getDomainNode(element);
                items[iCtr].setChecked(node.isChecked());
                items[iCtr].setGrayed(node.isGrayed());
                TreeItem[] children = items[iCtr].getItems();
                if (children.length > 0) {
                    this.updateTree(children);
                }
            }
            ++iCtr;
        }
    }

    public int getEnabledRuleCount(IAnalysisElement startElement) {
        int iCtr = 0;
        if (startElement.getOwnedElements() != null) {
            Iterator it = startElement.getOwnedElements().iterator();
            while (it.hasNext()) {
                DomainNode node;
                IAnalysisElement element = (IAnalysisElement)it.next();
                if (element instanceof IAnalysisRule && (node = this.getDomainNode(element)) != null && node.isChecked()) {
                    ++iCtr;
                }
                if (element.getOwnedElements() == null) continue;
                iCtr += this.getEnabledRuleCount(element);
            }
        }
        return iCtr;
    }

    public int getRuleCount(IAnalysisElement startElement) {
        int iCtr = 0;
        if (startElement.getOwnedElements() != null) {
            Iterator it = startElement.getOwnedElements().iterator();
            while (it.hasNext()) {
                IAnalysisElement element = (IAnalysisElement)it.next();
                if (element instanceof IAnalysisRule) {
                    ++iCtr;
                }
                if (element.getOwnedElements() == null) continue;
                iCtr += this.getRuleCount(element);
            }
        }
        return iCtr;
    }

    private DomainNode getDomainNode(IAnalysisElement element) {
        return (DomainNode)this.elementNodeMap.get(element);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void treeCollapsed(TreeEvent e) {
    }

    public void treeExpanded(TreeEvent e) {
        this.updateCheckboxes((TreeItem)e.item);
    }

    private void updateCheckboxes(TreeItem item) {
        TreeItem[] items = item.getItems();
        int iCtr = 0;
        while (iCtr < items.length) {
            IAnalysisElement element = (IAnalysisElement)items[iCtr].getData();
            DomainNode node = this.getDomainNode(element);
            items[iCtr].setChecked(node.isChecked());
            items[iCtr].setGrayed(node.isGrayed());
            ++iCtr;
        }
    }
}

