/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.ui.internal.model;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tptp.platform.analysis.core.element.IAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.history.AnalysisHistory;
import org.eclipse.tptp.platform.analysis.core.history.AnalysisHistoryFactory;
import org.eclipse.tptp.platform.analysis.core.manager.IAnalysisListener;
import org.eclipse.tptp.platform.analysis.core.result.IAnalysisResult;
import org.eclipse.tptp.platform.analysis.core.rule.IAnalysisRule;

public class ResultsModel
implements IAnalysisListener {
    private static final String RESULT_PROPERTY = "Results";
    private ListenerList propertyChangeListeners = new ListenerList();
    private static ResultsModel instance;
    private boolean isFiltered = false;

    public void toggleFilter() {
        this.isFiltered = !this.isFiltered;
    }

    public AnalysisHistory createHistory(String configName) {
        AnalysisHistory history = AnalysisHistoryFactory.instance().createAnalysisHistory(configName);
        return history;
    }

    public void complete(AnalysisHistory history) {
        history.complete();
        this.firePropertyChange(RESULT_PROPERTY, null, history);
    }

    public void update() {
        this.firePropertyChange(RESULT_PROPERTY, null, null);
    }

    public static ResultsModel instance() {
        if (instance == null) {
            instance = new ResultsModel();
        }
        return instance;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.add((Object)listener);
    }

    private void firePropertyChange(String changeId, Object oldValue, Object newValue) {
        final PropertyChangeEvent event = new PropertyChangeEvent((Object)this, changeId, oldValue, newValue);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Object[] listeners = ResultsModel.this.propertyChangeListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    ((IPropertyChangeListener)listeners[i]).propertyChange(event);
                    ++i;
                }
            }
        });
    }

    public void deleteHistory(AnalysisHistory history) {
        AnalysisHistoryFactory.instance().removeHistory(history);
        this.firePropertyChange(RESULT_PROPERTY, null, history);
    }

    public void removeElement(IAnalysisResult result) {
        IAnalysisRule rule = (IAnalysisRule)result.getOwner();
        rule.getHistoryResults(result.getHistoryId()).remove(result);
        this.firePropertyChange(RESULT_PROPERTY, null, result);
    }

    public void analysisComplete(IAnalysisElement element) {
        this.firePropertyChange(RESULT_PROPERTY, null, null);
    }

    public void analysisComplete(AnalysisHistory history) {
        history.complete();
        this.firePropertyChange(RESULT_PROPERTY, null, history);
    }

    public boolean isFiltered() {
        return this.isFiltered;
    }
}

