/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.ui.internal.preferences;

import java.io.File;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tptp.platform.analysis.core.AnalysisConstants;
import org.eclipse.tptp.platform.analysis.core.AnalysisCorePlugin;
import org.eclipse.tptp.platform.analysis.core.category.IAnalysisCategory;
import org.eclipse.tptp.platform.analysis.core.element.IAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.manager.AbstractAnalysisProviderManager;
import org.eclipse.tptp.platform.analysis.core.rule.IAnalysisRule;
import org.eclipse.tptp.platform.analysis.core.ui.AnalysisUIPlugin;
import org.eclipse.tptp.platform.analysis.core.ui.UIMessages;
import org.eclipse.tptp.platform.analysis.core.ui.internal.preferences.composite.CustomCategoryComposite;
import org.eclipse.tptp.platform.analysis.core.ui.internal.preferences.composite.CustomDomainComposite;
import org.eclipse.tptp.platform.analysis.core.ui.internal.preferences.customrules.AddCategoryWizard;
import org.eclipse.tptp.platform.analysis.core.ui.internal.preferences.customrules.AddRuleWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class AnalysisCustomRulePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener {
    private Button addRuleButton;
    private Button deleteRuleButton;
    private Button addCategoryButton;
    private Button deleteCategoryButton;
    private CustomDomainComposite dc;
    private CustomCategoryComposite cc;

    public AnalysisCustomRulePreferencePage() {
        this.setPreferenceStore(AnalysisUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(UIMessages.preference_custom_category_rule_description);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayout((Layout)new GridLayout(1, false));
        this.createCategoryComposite(comp);
        this.createRuleComposite(comp);
        return comp;
    }

    private void createCategoryComposite(Composite comp) {
        Composite categoryComp = new Composite(comp, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginTop = 0;
        categoryComp.setLayout((Layout)layout);
        categoryComp.setLayoutData((Object)new GridData(1808));
        Composite controlComp = new Composite(categoryComp, 0);
        controlComp.setLayout((Layout)new GridLayout(1, false));
        controlComp.setLayoutData((Object)new GridData(1808));
        new Label(controlComp, 0).setText(UIMessages.preference_current_custom_category);
        this.cc = new CustomCategoryComposite(controlComp, (IAnalysisElement)AbstractAnalysisProviderManager.getProviderManagers().get(0));
        this.cc.getDomainTree().addSelectionListener((SelectionListener)this);
        Composite buttonComp = new Composite(categoryComp, 0);
        buttonComp.setLayout((Layout)new GridLayout(1, false));
        buttonComp.setLayoutData((Object)new GridData(2));
        new Label(buttonComp, 0);
        this.addCategoryButton = new Button(buttonComp, 8);
        this.addCategoryButton.setText(UIMessages.preference_custom_button_new_category);
        this.addCategoryButton.addSelectionListener((SelectionListener)this);
        this.deleteCategoryButton = new Button(buttonComp, 8);
        this.deleteCategoryButton.setText(UIMessages.preference_custom_button_delete_category);
        this.deleteCategoryButton.addSelectionListener((SelectionListener)this);
        this.deleteCategoryButton.setEnabled(false);
    }

    private void createRuleComposite(Composite comp) {
        Composite ruleComp = new Composite(comp, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginTop = 0;
        ruleComp.setLayout((Layout)layout);
        ruleComp.setLayoutData((Object)new GridData(1808));
        Composite controlComp = new Composite(ruleComp, 0);
        GridLayout layout2 = new GridLayout(1, false);
        layout2.marginTop = 0;
        controlComp.setLayout((Layout)layout2);
        controlComp.setLayoutData((Object)new GridData(1808));
        new Label(controlComp, 0).setText(UIMessages.preference_current_custom_rule);
        this.dc = new CustomDomainComposite(controlComp, (IAnalysisElement)AbstractAnalysisProviderManager.getProviderManagers().get(0));
        this.dc.getDomainTree().addSelectionListener((SelectionListener)this);
        Composite buttonComp = new Composite(ruleComp, 0);
        buttonComp.setLayout((Layout)new GridLayout(1, false));
        buttonComp.setLayoutData((Object)new GridData(2));
        new Label(buttonComp, 0);
        this.addRuleButton = new Button(buttonComp, 8);
        this.addRuleButton.setText(UIMessages.preference_custom_button_new_rule);
        this.addRuleButton.addSelectionListener((SelectionListener)this);
        this.deleteRuleButton = new Button(buttonComp, 8);
        this.deleteRuleButton.setText(UIMessages.preference_custom_button_delete_rule);
        this.deleteRuleButton.addSelectionListener((SelectionListener)this);
        this.deleteRuleButton.setEnabled(false);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.addCategoryButton)) {
            this.handleAddCategory();
        } else if (e.getSource().equals(this.deleteCategoryButton)) {
            this.handleDeleteCategory();
        } else if (e.getSource().equals(this.addRuleButton)) {
            this.handleAddRule();
        } else if (e.getSource().equals(this.deleteRuleButton)) {
            this.handleDeleteRule();
        } else if (e.getSource().equals(this.cc.getDomainTree())) {
            IAnalysisCategory category;
            IAnalysisElement element = (IAnalysisElement)e.item.getData();
            this.deleteCategoryButton.setEnabled(false);
            if ((element.getOwnedElements() == null || element.getOwnedElements().size() == 0) && element.getElementType() == 2 && (category = (IAnalysisCategory)element).isCustom()) {
                this.deleteCategoryButton.setEnabled(true);
            }
        } else if (e.getSource().equals(this.dc.getDomainTree())) {
            IAnalysisElement element = (IAnalysisElement)e.item.getData();
            if (element.getElementType() == 3) {
                this.deleteRuleButton.setEnabled(true);
            } else {
                this.deleteRuleButton.setEnabled(false);
            }
        }
    }

    private void handleAddCategory() {
        AddCategoryWizard wizard = new AddCategoryWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)this.cc.getDomainTreeViewer().getSelection());
        WizardDialog dlg = new WizardDialog(this.getShell(), (IWizard)wizard);
        dlg.setPageSize(500, 500);
        dlg.open();
        this.cc.getDomainTreeViewer().refresh(true);
        this.cc.getDomainTree().update();
        this.cc.getDomainTreeViewer().expandAll();
        StructuredSelection selection = new StructuredSelection((Object)wizard.getCreatedElement());
        this.cc.getDomainTreeViewer().setSelection((ISelection)selection, true);
    }

    private void handleDeleteCategory() {
        IStructuredSelection selection = (IStructuredSelection)this.cc.getDomainTreeViewer().getSelection();
        IAnalysisCategory category = (IAnalysisCategory)selection.getFirstElement();
        category.getOwner().getOwnedElements().remove(category);
        if (category.getOwnedElements() != null) {
            category.getOwnedElements().clear();
        }
        this.cc.getDomainTreeViewer().remove((Object)category);
        String file = String.valueOf(AnalysisCorePlugin.getDefault().getStateLocation().toOSString()) + AnalysisConstants.CATEGORY_FOLDER + File.separator + category.getId();
        new File(file).delete();
        category = null;
        this.dc.getDomainTreeViewer().refresh();
    }

    private void handleAddRule() {
        AddRuleWizard wizard = new AddRuleWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)this.dc.getDomainTreeViewer().getSelection());
        WizardDialog dlg = new WizardDialog(this.getShell(), (IWizard)wizard);
        dlg.setPageSize(500, 500);
        dlg.addPageChangedListener((IPageChangedListener)wizard);
        dlg.open();
        this.dc.getDomainTreeViewer().refresh(true);
        this.dc.getDomainTree().update();
        this.dc.getDomainTreeViewer().expandAll();
        StructuredSelection selection = new StructuredSelection((Object)wizard.getCreatedElement());
        this.dc.getDomainTreeViewer().setSelection((ISelection)selection, true);
    }

    private void handleDeleteRule() {
        IStructuredSelection selection = (IStructuredSelection)this.dc.getDomainTreeViewer().getSelection();
        IAnalysisRule rule = (IAnalysisRule)selection.getFirstElement();
        rule.getOwner().getOwnedElements().remove(rule);
        this.dc.getDomainTreeViewer().remove((Object)rule);
        String file = String.valueOf(AnalysisCorePlugin.getDefault().getStateLocation().toOSString()) + AnalysisConstants.RULE_FOLDER + File.separator + rule.getId();
        new File(file).delete();
        rule = null;
        this.dc.getDomainTreeViewer().refresh();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

