/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.ui.internal.preferences.customrules;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.tptp.platform.analysis.core.AnalysisConstants;
import org.eclipse.tptp.platform.analysis.core.AnalysisCorePlugin;
import org.eclipse.tptp.platform.analysis.core.category.DefaultAnalysisCategory;
import org.eclipse.tptp.platform.analysis.core.element.IAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.logging.Log;
import org.eclipse.tptp.platform.analysis.core.ui.UIMessages;
import org.eclipse.tptp.platform.analysis.core.ui.internal.preferences.customrules.PopulateCategoryPage;
import org.eclipse.tptp.platform.analysis.core.ui.internal.preferences.customrules.SelectCategoryPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class AddCategoryWizard
extends Wizard
implements INewWizard {
    private static final String BREAK = "\r\n";
    private SelectCategoryPage page1;
    private PopulateCategoryPage page2;
    private boolean canFinish = false;
    private IStructuredSelection selection;
    private IAnalysisElement createdElement;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setWindowTitle(UIMessages.preference_add_custom_category);
        this.setNeedsProgressMonitor(true);
    }

    public boolean canFinish() {
        return this.canFinish;
    }

    public void setCanFinish(boolean canFinish) {
        this.canFinish = canFinish;
    }

    public boolean performFinish() {
        IAnalysisElement element = this.getSelectCategoryPage().getSelectedElement();
        DefaultAnalysisCategory category = new DefaultAnalysisCategory();
        category.setLabel(this.page2.getCategoryName());
        category.setId(String.valueOf(element.getId()) + "." + AnalysisCorePlugin.replace((String)this.page2.getCategoryName(), (String)" ", (String)""));
        category.setOwner(element);
        category.setElementType(2);
        category.setIconName("icons/analysiscategory_obj.gif");
        category.setPluginId(AnalysisCorePlugin.getPluginId());
        category.setCustom(true);
        if (category == null || AnalysisCorePlugin.getAnalysisElement((String)category.getId()) != null) {
            return false;
        }
        element.addOwnedElement((IAnalysisElement)category);
        StringBuffer sb = new StringBuffer();
        sb.append(category.getId()).append(BREAK);
        sb.append(category.getLabel()).append(BREAK);
        sb.append(element.getId()).append(BREAK);
        String folder = String.valueOf(AnalysisCorePlugin.getDefault().getStateLocation().toOSString()) + AnalysisConstants.CATEGORY_FOLDER;
        File f = new File(folder);
        f.mkdir();
        String file = String.valueOf(folder) + File.separator + category.getId();
        try {
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-16");
            fw.write(sb.toString());
            fw.close();
            this.createdElement = category;
            return true;
        }
        catch (IOException e) {
            Log.severe((String)"", (Throwable)e);
            return false;
        }
    }

    public void addPages() {
        this.page1 = new SelectCategoryPage(UIMessages.preference_choose_parent_category, this);
        this.page1.setSelection(this.selection);
        this.page1.setTitle(UIMessages.preference_choose_parent_category_location);
        this.page1.setDescription(UIMessages.preference_choose_parent_category_title);
        this.addPage((IWizardPage)this.page1);
        this.page2 = new PopulateCategoryPage(UIMessages.preference_enter_category_name, this);
        this.page2.setTitle(UIMessages.preference_enter_category_name);
        this.page2.setDescription(UIMessages.preference_enter_category_name_select);
        this.addPage((IWizardPage)this.page2);
    }

    public SelectCategoryPage getSelectCategoryPage() {
        return this.page1;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public IAnalysisElement getCreatedElement() {
        return this.createdElement;
    }
}

