/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.ui.internal.preferences.customrules;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.tptp.platform.analysis.core.AnalysisConstants;
import org.eclipse.tptp.platform.analysis.core.AnalysisCorePlugin;
import org.eclipse.tptp.platform.analysis.core.element.IAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.logging.Log;
import org.eclipse.tptp.platform.analysis.core.rule.IAnalysisRule;
import org.eclipse.tptp.platform.analysis.core.rule.RuleParameter;
import org.eclipse.tptp.platform.analysis.core.template.RuleTemplate;
import org.eclipse.tptp.platform.analysis.core.ui.UIMessages;
import org.eclipse.tptp.platform.analysis.core.ui.internal.preferences.customrules.PopulateTemplatePage;
import org.eclipse.tptp.platform.analysis.core.ui.internal.preferences.customrules.SelectCategoryPage;
import org.eclipse.tptp.platform.analysis.core.ui.internal.preferences.customrules.SelectTemplatePage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class AddRuleWizard
extends Wizard
implements INewWizard,
IPageChangedListener {
    private static final String BREAK = "\r\n";
    private SelectCategoryPage page1;
    private SelectTemplatePage page2;
    private PopulateTemplatePage page3;
    private boolean canFinish = false;
    private IStructuredSelection selection;
    private IAnalysisElement createdElement;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setWindowTitle(UIMessages.preference_add_custom_rule);
        this.setNeedsProgressMonitor(true);
    }

    public boolean canFinish() {
        return this.canFinish;
    }

    public void setCanFinish(boolean canFinish) {
        this.canFinish = canFinish;
    }

    public boolean performFinish() {
        IAnalysisElement element = this.getSelectCategoryPage().getSelectedElement();
        RuleTemplate template = this.getSelectTemplatePage().getRuleTemplateSelection();
        this.getPopulateTemplatePage().getParameters();
        IAnalysisRule rule = template.createRule();
        if (rule == null || AnalysisCorePlugin.getAnalysisElement((String)rule.getId()) != null) {
            return false;
        }
        element.addOwnedElement((IAnalysisElement)rule);
        StringBuffer sb = new StringBuffer();
        sb.append(rule.getId()).append(BREAK);
        sb.append(rule.getLabel()).append(BREAK);
        sb.append(element.getId()).append(BREAK);
        sb.append(template.getPluginId()).append(BREAK);
        sb.append(rule.getClass().getName()).append(BREAK);
        int iCtr = 0;
        Iterator it = rule.getParameterList().iterator();
        while (it.hasNext()) {
            RuleParameter p = (RuleParameter)it.next();
            sb.append(iCtr++).append(BREAK);
            sb.append(p.getDescription()).append(BREAK);
            sb.append(p.getLabel()).append(BREAK);
            sb.append(p.getName()).append(BREAK);
            sb.append(p.getStyle()).append(BREAK);
            sb.append(p.getType()).append(BREAK);
            sb.append(p.getValue()).append(BREAK);
        }
        String folder = String.valueOf(AnalysisCorePlugin.getDefault().getStateLocation().toOSString()) + AnalysisConstants.RULE_FOLDER;
        File f = new File(folder);
        f.mkdir();
        String file = String.valueOf(folder) + File.separator + rule.getId();
        try {
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-16");
            fw.write(sb.toString());
            fw.close();
            this.createdElement = rule;
            return true;
        }
        catch (IOException e) {
            Log.severe((String)"", (Throwable)e);
            return false;
        }
    }

    public void addPages() {
        this.page1 = new SelectCategoryPage(UIMessages.preference_choose_parent_category, this);
        this.page1.setSelection(this.selection);
        this.page1.setTitle(UIMessages.preference_choose_parent_category);
        this.page1.setDescription(UIMessages.preference_choose_parent_rule_title);
        this.addPage((IWizardPage)this.page1);
        this.page2 = new SelectTemplatePage(UIMessages.preference_select_template, this);
        this.page2.setTitle(UIMessages.preference_select_template);
        this.page2.setDescription(UIMessages.preference_select_template_label);
        this.addPage((IWizardPage)this.page2);
        this.page3 = new PopulateTemplatePage(UIMessages.preference_assign_template_values, this);
        this.page3.setTitle(UIMessages.preference_assign_template_values);
        this.page3.setDescription(UIMessages.preference_assign_template_values_label);
        this.addPage((IWizardPage)this.page3);
    }

    public void pageChanged(PageChangedEvent event) {
        WizardPage page = (WizardPage)event.getSelectedPage();
        if (page.equals((Object)this.page2)) {
            this.page2.activate();
        } else if (page.equals((Object)this.page3)) {
            this.page3.activate();
        }
    }

    public SelectCategoryPage getSelectCategoryPage() {
        return this.page1;
    }

    public SelectTemplatePage getSelectTemplatePage() {
        return this.page2;
    }

    public PopulateTemplatePage getPopulateTemplatePage() {
        return this.page3;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public IAnalysisElement getCreatedElement() {
        return this.createdElement;
    }
}

