/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.ui.internal.preferences.customrules;

import com.ibm.icu.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.analysis.core.rule.RuleParameter;
import org.eclipse.tptp.platform.analysis.core.template.RuleTemplate;
import org.eclipse.tptp.platform.analysis.core.ui.UIMessages;
import org.eclipse.tptp.platform.analysis.core.ui.internal.preferences.customrules.AddRuleWizard;

public class PopulateTemplatePage
extends WizardPage
implements ModifyListener,
FocusListener {
    private AddRuleWizard wizard;
    private Composite comp;
    private RuleTemplate currentTemplate = null;
    private List controls;
    private Text descriptionText;

    protected PopulateTemplatePage(String pageName, AddRuleWizard wizard) {
        super(pageName);
        this.wizard = wizard;
    }

    public void createControl(Composite parent) {
        this.comp = new Composite(parent, 0);
        this.comp.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)this.comp);
        this.setPageComplete(false);
        this.wizard.setCanFinish(false);
    }

    public void activate() {
        this.controls = new ArrayList();
        this.currentTemplate = this.wizard.getSelectTemplatePage().getRuleTemplateSelection();
        Control[] children = this.comp.getChildren();
        int iCtr = 0;
        while (iCtr < children.length) {
            children[iCtr].dispose();
            ++iCtr;
        }
        List parameters = this.currentTemplate.getParameters();
        Iterator it = parameters.iterator();
        while (it.hasNext()) {
            this.addParameterControl((RuleParameter)it.next());
        }
        new Label(this.comp, 0);
        new Label(this.comp, 0).setText(UIMessages.preference_field_category_description);
        this.descriptionText = new Text(this.comp, 2634);
        GridData gd = new GridData(768);
        gd.heightHint = 80;
        this.descriptionText.setLayoutData((Object)gd);
        this.comp.layout();
        this.setPageComplete(false);
        this.wizard.setCanFinish(false);
        this.wizard.getContainer().updateButtons();
    }

    private void addParameterControl(RuleParameter parameter) {
        if (parameter.getStyle().equals("text")) {
            new Label(this.comp, 0).setText(parameter.getLabel());
            Text text = new Text(this.comp, 2048);
            text.setLayoutData((Object)new GridData(768));
            text.addModifyListener((ModifyListener)this);
            text.addFocusListener((FocusListener)this);
            this.controls.add(text);
        } else if (parameter.getStyle().equals("combo")) {
            new Label(this.comp, 0).setText(parameter.getLabel());
            Combo combo = new Combo(this.comp, 2056);
            Iterator it = parameter.getComboValues().iterator();
            while (it.hasNext()) {
                combo.add((String)it.next());
            }
            try {
                combo.select(NumberFormat.getIntegerInstance().parse(parameter.getValue()).intValue());
            }
            catch (NumberFormatException numberFormatException) {
                combo.select(0);
            }
            catch (ParseException parseException) {
                combo.select(0);
            }
            this.controls.add(combo);
            combo.addFocusListener((FocusListener)this);
            combo.setLayoutData((Object)new GridData(768));
        } else if (parameter.getStyle().equals("check")) {
            Button check = new Button(this.comp, 32);
            check.setText(parameter.getLabel());
            check.addFocusListener((FocusListener)this);
            check.setLayoutData((Object)new GridData(768));
            this.controls.add(check);
        }
    }

    public void validate() {
        int validCount = 0;
        int iCtr = 0;
        Iterator it = this.controls.iterator();
        while (it.hasNext()) {
            Control control = (Control)it.next();
            RuleParameter parameter = (RuleParameter)this.currentTemplate.getParameters().get(iCtr++);
            if (parameter.isTextStyle()) {
                String text = ((Text)control).getText();
                if (text.length() <= 0 || !parameter.isStringType() && (!parameter.isIntegerType() || !this.isValid(parameter, text))) continue;
                ++validCount;
                continue;
            }
            ++validCount;
        }
        if (validCount == this.controls.size()) {
            this.setPageComplete(true);
            this.wizard.setCanFinish(true);
            this.wizard.getContainer().updateButtons();
        } else {
            this.setPageComplete(false);
            this.wizard.setCanFinish(false);
            this.wizard.getContainer().updateButtons();
        }
    }

    public void modifyText(ModifyEvent e) {
        this.validate();
    }

    public void focusGained(FocusEvent e) {
        Control source = (Control)e.getSource();
        int iCtr = 0;
        Iterator it = this.controls.iterator();
        while (it.hasNext()) {
            Control control = (Control)it.next();
            RuleParameter parameter = (RuleParameter)this.currentTemplate.getParameters().get(iCtr++);
            if (!source.equals(control)) continue;
            this.descriptionText.setText(parameter.getDescription());
        }
    }

    public void focusLost(FocusEvent e) {
    }

    public boolean isValid(RuleParameter parameter, String value) {
        if (parameter.isIntegerType()) {
            try {
                NumberFormat.getIntegerInstance().parse(value).intValue();
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }
        return true;
    }

    public List getParameters() {
        int iCtr = 0;
        Iterator it = this.controls.iterator();
        while (it.hasNext()) {
            Control control = (Control)it.next();
            RuleParameter parameter = (RuleParameter)this.currentTemplate.getParameters().get(iCtr++);
            if (parameter.isTextStyle()) {
                parameter.setValue(((Text)control).getText());
                continue;
            }
            if (parameter.isComboStyle()) {
                parameter.setValue("" + ((Combo)control).getSelectionIndex());
                continue;
            }
            if (!parameter.isCheckStyle()) continue;
            parameter.setValue("" + ((Button)control).isEnabled());
        }
        return this.currentTemplate.getParameters();
    }
}

