/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.ui.internal.preferences.provider;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.tptp.platform.analysis.core.element.IAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.manager.IAnalysisProviderManager;
import org.eclipse.tptp.platform.analysis.core.provider.IAnalysisProvider;
import org.eclipse.tptp.platform.analysis.core.rule.IAnalysisRule;
import org.eclipse.tptp.platform.analysis.core.ui.internal.model.ProviderModel;

public class CustomDomainContentProvider
implements ITreeContentProvider,
IPropertyChangeListener {
    private TreeViewer viewer;

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)v;
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        if (parent instanceof ProviderModel) {
            return this.getChildren(parent);
        }
        return new Object[0];
    }

    public Object[] getChildren(Object parentElement) {
        List l;
        if (parentElement instanceof ProviderModel) {
            IAnalysisProviderManager root = (IAnalysisProviderManager)((ProviderModel)parentElement).getRoot();
            List l2 = root.getOwnedElements();
            if (l2 != null) {
                ArrayList<IAnalysisProvider> addList = new ArrayList<IAnalysisProvider>();
                Iterator it = l2.iterator();
                while (it.hasNext()) {
                    IAnalysisProvider provider = (IAnalysisProvider)it.next();
                    if (provider.getRuleTemplates() == null || provider.getRuleTemplates().size() <= 0 || !this.hasCustomRules((IAnalysisElement)provider)) continue;
                    addList.add(provider);
                }
                Object[] elements = new IAnalysisElement[addList.size()];
                int iCtr = 0;
                while (iCtr < addList.size()) {
                    elements[iCtr] = (IAnalysisElement)addList.get(iCtr);
                    ++iCtr;
                }
                return elements;
            }
        } else if (parentElement instanceof IAnalysisElement && (l = ((IAnalysisElement)parentElement).getOwnedElements()) != null) {
            ArrayList<Object> addList = new ArrayList<Object>();
            Iterator it = l.iterator();
            while (it.hasNext()) {
                IAnalysisRule rule;
                IAnalysisElement child = (IAnalysisElement)it.next();
                if (child.getElementType() == 2 && this.hasCustomRules(child)) {
                    addList.add(child);
                    continue;
                }
                if (child.getElementType() != 3 || !(rule = (IAnalysisRule)child).isCustom()) continue;
                addList.add(rule);
            }
            Object[] elements = new IAnalysisElement[addList.size()];
            int iCtr = 0;
            while (iCtr < addList.size()) {
                elements[iCtr] = (IAnalysisElement)addList.get(iCtr);
                ++iCtr;
            }
            return elements;
        }
        return new Object[0];
    }

    private boolean hasCustomRules(IAnalysisElement element) {
        List l = element.getOwnedElements();
        if (l != null) {
            Iterator it = l.iterator();
            while (it.hasNext()) {
                IAnalysisRule rule;
                boolean result;
                IAnalysisElement child = (IAnalysisElement)it.next();
                if (!(child.getElementType() != 3 ? (result = this.hasCustomRules(child)) : (rule = (IAnalysisRule)child).isCustom())) continue;
                return true;
            }
        }
        return false;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        List l;
        if (element instanceof ProviderModel) {
            return true;
        }
        return element instanceof IAnalysisElement && (l = ((IAnalysisElement)element).getOwnedElements()) != null && l.size() > 0;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.refresh();
        }
    }
}

