/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.ui.internal.providers;

import com.ibm.icu.text.NumberFormat;
import java.util.Iterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tptp.platform.analysis.core.element.IAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.history.AnalysisHistory;
import org.eclipse.tptp.platform.analysis.core.history.AnalysisHistoryElement;
import org.eclipse.tptp.platform.analysis.core.result.IAnalysisResult;
import org.eclipse.tptp.platform.analysis.core.rule.IAnalysisRule;
import org.eclipse.tptp.platform.analysis.core.ui.AnalysisUIPlugin;
import org.eclipse.tptp.platform.analysis.core.ui.UIMessages;

public class ResultTreeLabelProvider
extends LabelProvider
implements ILabelProvider {
    private static final String SPACE = " ";

    public String getText(Object obj) {
        if (obj instanceof AnalysisHistory) {
            ChildResult result = this.countHistoryResults((AnalysisHistory)obj);
            StringBuffer sb = new StringBuffer(((AnalysisHistory)obj).getLabel());
            sb.append(SPACE).append(this.formatResult(result));
            return sb.toString();
        }
        if (obj instanceof AnalysisHistoryElement) {
            IAnalysisElement element = ((AnalysisHistoryElement)obj).getMappedAnalysisElement();
            String label = null;
            label = element instanceof IAnalysisRule && ((IAnalysisRule)element).getParameterCount() > 0 ? ((IAnalysisRule)element).getLabelWithVariables() : element.getLabel();
            ChildResult result = this.countChildResults((AnalysisHistoryElement)obj);
            StringBuffer sb = new StringBuffer(label);
            sb.append(SPACE).append(this.formatResult(result));
            return sb.toString();
        }
        if (obj instanceof IAnalysisResult) {
            return ((IAnalysisResult)obj).getLabel();
        }
        return super.getText(obj);
    }

    private String formatResult(ChildResult result) {
        String resultStr = null;
        resultStr = result.count == 1 ? UIMessages.bind((String)UIMessages.result_label_single, (Object[])new Object[]{NumberFormat.getNumberInstance().format((long)result.count), NumberFormat.getNumberInstance().format(result.time)}) : UIMessages.bind((String)UIMessages.result_label, (Object[])new Object[]{NumberFormat.getNumberInstance().format((long)result.count), NumberFormat.getNumberInstance().format(result.time)});
        return resultStr;
    }

    public Image getImage(Object obj) {
        if (obj instanceof AnalysisHistory) {
            return AnalysisUIPlugin.getImage(null, "icons/analysishistory_obj.gif");
        }
        if (obj instanceof AnalysisHistoryElement) {
            return AnalysisUIPlugin.getImage(((AnalysisHistoryElement)obj).getMappedAnalysisElement().getPluginId(), ((AnalysisHistoryElement)obj).getMappedAnalysisElement().getIconName());
        }
        if (obj instanceof IAnalysisResult) {
            return AnalysisUIPlugin.getImage(((IAnalysisResult)obj).getPluginId(), ((IAnalysisResult)obj).getIconName());
        }
        return super.getImage(obj);
    }

    private ChildResult countHistoryResults(AnalysisHistory element) {
        ChildResult result = new ChildResult();
        Iterator it = element.getSelectedElements().iterator();
        while (it.hasNext()) {
            AnalysisHistoryElement ahe = (AnalysisHistoryElement)it.next();
            ChildResult temp = this.countChildResults(ahe);
            result.count += temp.count;
            result.time += temp.time;
        }
        return result;
    }

    private ChildResult countChildResults(AnalysisHistoryElement ahe) {
        ChildResult result = new ChildResult();
        result.count = ahe.getMappedAnalysisElement().getHistoryResults(ahe.getHistory().getHistoryId()).size();
        result.time = ahe.getElapsedTime();
        if (ahe.getOwnedMembers() != null) {
            Iterator it = ahe.getOwnedMembers().iterator();
            while (it.hasNext()) {
                AnalysisHistoryElement child = (AnalysisHistoryElement)it.next();
                ChildResult temp = this.countChildResults(child);
                result.count += temp.count;
                result.time += temp.time;
            }
        }
        return result;
    }

    private class ChildResult {
        int count;
        long time;

        ChildResult() {
        }
    }
}

