/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.ui.internal.providers;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.tptp.platform.analysis.core.history.AnalysisHistory;
import org.eclipse.tptp.platform.analysis.core.history.AnalysisHistoryElement;
import org.eclipse.tptp.platform.analysis.core.history.AnalysisHistoryFactory;
import org.eclipse.tptp.platform.analysis.core.result.IAnalysisResult;
import org.eclipse.tptp.platform.analysis.core.rule.IAnalysisRule;
import org.eclipse.tptp.platform.analysis.core.ui.internal.model.ResultsModel;

public class ResultTreeViewContentProvider
implements ITreeContentProvider,
IPropertyChangeListener {
    private TreeViewer viewer;
    private static ResultTreeViewContentProvider instance;

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)v;
    }

    public void dispose() {
    }

    public static ResultTreeViewContentProvider instance() {
        if (instance == null) {
            instance = new ResultTreeViewContentProvider();
        }
        return instance;
    }

    public Object[] getElements(Object parent) {
        if (parent instanceof ResultsModel) {
            return this.getChildren(parent);
        }
        return new Object[0];
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ResultsModel) {
            List l = AnalysisHistoryFactory.instance().getHistoryList();
            Object[] elements = new AnalysisHistory[l.size()];
            int iCtr = 0;
            Iterator it = l.iterator();
            while (it.hasNext()) {
                AnalysisHistory history = (AnalysisHistory)it.next();
                if (history == null || history.getHistoryId().equals("REALTIME")) continue;
                elements[iCtr++] = history;
            }
            return elements;
        }
        if (parentElement instanceof AnalysisHistory) {
            List l = ((AnalysisHistory)parentElement).getSelectedElements();
            Object[] elements = new AnalysisHistoryElement[l.size()];
            int iCtr = 0;
            Iterator it = l.iterator();
            while (it.hasNext()) {
                elements[iCtr++] = (AnalysisHistoryElement)it.next();
            }
            return elements;
        }
        if (parentElement instanceof AnalysisHistoryElement) {
            AnalysisHistoryElement ahe = (AnalysisHistoryElement)parentElement;
            if (ahe.getMappedAnalysisElement() instanceof IAnalysisRule) {
                IAnalysisRule rule = (IAnalysisRule)ahe.getMappedAnalysisElement();
                List l = rule.getHistoryResults(ahe.getHistory().getHistoryId());
                Object[] elements = new IAnalysisResult[l.size()];
                int iCtr = 0;
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    elements[iCtr++] = (IAnalysisResult)it.next();
                }
                return elements;
            }
            List l = ((AnalysisHistoryElement)parentElement).getOwnedMembers();
            Object[] elements = new AnalysisHistoryElement[l.size()];
            int iCtr = 0;
            Iterator it = l.iterator();
            while (it.hasNext()) {
                elements[iCtr++] = (AnalysisHistoryElement)it.next();
            }
            return elements;
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        List l;
        IAnalysisRule rule;
        List l2;
        AnalysisHistoryElement ahe;
        if (element instanceof ResultsModel) {
            return true;
        }
        return element instanceof AnalysisHistory ? ((AnalysisHistory)element).getSelectedElements().size() > 0 : element instanceof AnalysisHistoryElement && ((ahe = (AnalysisHistoryElement)element).getMappedAnalysisElement() instanceof IAnalysisRule ? (l2 = (rule = (IAnalysisRule)ahe.getMappedAnalysisElement()).getHistoryResults(ahe.getHistory().getHistoryId())) != null && l2.size() > 0 : (l = ((AnalysisHistoryElement)element).getOwnedMembers()) != null && l.size() > 0);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.refresh();
        }
    }
}

