/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.ui.internal.views;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tptp.platform.analysis.core.element.IAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.history.AnalysisHistory;
import org.eclipse.tptp.platform.analysis.core.logging.Log;
import org.eclipse.tptp.platform.analysis.core.quickfix.IAnalysisQuickFix;
import org.eclipse.tptp.platform.analysis.core.result.IAnalysisResult;
import org.eclipse.tptp.platform.analysis.core.rule.IAnalysisRule;
import org.eclipse.tptp.platform.analysis.core.ui.AnalysisUIPlugin;
import org.eclipse.tptp.platform.analysis.core.ui.UIMessages;
import org.eclipse.tptp.platform.analysis.core.ui.internal.help.TreeHelpListener;
import org.eclipse.tptp.platform.analysis.core.ui.internal.help.TreeSelectionChanged;
import org.eclipse.tptp.platform.analysis.core.ui.internal.model.ResultsModel;
import org.eclipse.tptp.platform.analysis.core.ui.internal.providers.ResultTreeFilter;
import org.eclipse.tptp.platform.analysis.core.ui.internal.providers.ResultTreeLabelProvider;
import org.eclipse.tptp.platform.analysis.core.ui.internal.providers.ResultTreeViewContentProvider;
import org.eclipse.tptp.platform.analysis.core.ui.internal.views.ResultsViewSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ResultsView
extends ViewPart {
    public static final String CONTEXT_HELP_ID = "org.eclipse.tptp.platform.analysis.core.ui.ResultsView";
    private final String FILE_FILTER = "*.xml";
    private static final String EMTPY = "";
    private static final String UTF16 = "UTF-16";
    private TreeViewer viewer;
    private Action actionDeleteHistory;
    private Action actionResultFilter;
    private Action actionViewResult;
    private Action actionExport;
    private List quickFixActions;
    private ResultTreeFilter filter;

    public void createPartControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, CONTEXT_HELP_ID);
        this.viewer = new TreeViewer(parent, 772);
        this.viewer.addHelpListener((HelpListener)new TreeHelpListener());
        this.viewer.setContentProvider((IContentProvider)ResultTreeViewContentProvider.instance());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ResultTreeLabelProvider());
        this.filter = new ResultTreeFilter();
        this.viewer.setInput((Object)ResultsModel.instance());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResultsView.this.actionDeleteHistory.setEnabled(false);
                ResultsView.this.actionExport.setEnabled(false);
                IStructuredSelection selection = (IStructuredSelection)ResultsView.this.viewer.getSelection();
                Object obj = selection.getFirstElement();
                if (obj instanceof AnalysisHistory) {
                    AnalysisHistory history = (AnalysisHistory)obj;
                    if (history.isComplete()) {
                        ResultsView.this.actionDeleteHistory.setEnabled(true);
                        ResultsView.this.actionExport.setEnabled(true);
                    }
                } else if (obj instanceof IAnalysisResult) {
                    ResultsView.this.actionViewResult.setEnabled(true);
                }
            }
        });
        ResultsModel.instance().addPropertyChangeListener(ResultTreeViewContentProvider.instance());
        this.viewer.addDoubleClickListener((IDoubleClickListener)new ResultsViewSelection(this.viewer));
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new TreeSelectionChanged(0));
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager(null);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IAnalysisResult element;
                IAnalysisRule rule;
                IStructuredSelection selection = (IStructuredSelection)ResultsView.this.viewer.getSelection();
                Object obj = selection.getFirstElement();
                if (obj instanceof IAnalysisResult && (rule = (IAnalysisRule)(element = (IAnalysisResult)obj).getOwner()).getQuickFixIterator() != null) {
                    ResultsView.this.quickFixActions = new ArrayList();
                    Iterator it = rule.getQuickFixIterator();
                    while (it.hasNext()) {
                        String id = (String)it.next();
                        IAnalysisQuickFix quickfix = rule.getQuickFix(id);
                        QuickFixAction quickFixAction = new QuickFixAction(this, ResultsView.this, element, quickfix){
                            final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                if (this.getQuickfix().quickfix(this.getElement())) {
                                    ResultsModel.instance().removeElement(this.getElement());
                                }
                            }
                        };
                        quickFixAction.setText(quickfix.getLabel());
                        quickFixAction.setToolTipText(UIMessages.action_quickfix_tooltip);
                        quickFixAction.setImageDescriptor(AnalysisUIPlugin.getImageDescriptor(UIMessages.action_quickfix_icon));
                        ResultsView.this.quickFixActions.add(quickFixAction);
                    }
                }
                manager.add((IAction)ResultsView.this.actionViewResult);
                if (ResultsView.this.quickFixActions != null) {
                    manager.add((IContributionItem)new Separator("additions"));
                    Iterator it = ResultsView.this.quickFixActions.iterator();
                    while (it.hasNext()) {
                        manager.add((IAction)((QuickFixAction)((Object)it.next())));
                    }
                }
                manager.add((IContributionItem)new Separator("additions"));
                manager.add((IAction)ResultsView.this.actionResultFilter);
                manager.add((IContributionItem)new Separator("additions"));
                manager.add((IAction)ResultsView.this.actionDeleteHistory);
                manager.add((IAction)ResultsView.this.actionExport);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getMenuManager().add((IAction)this.actionViewResult);
        if (this.quickFixActions != null) {
            bars.getMenuManager().add((IContributionItem)new Separator());
            Iterator it = this.quickFixActions.iterator();
            while (it.hasNext()) {
                bars.getMenuManager().add((IAction)((QuickFixAction)((Object)it.next())));
            }
        }
        bars.getMenuManager().add((IContributionItem)new Separator());
        bars.getMenuManager().add((IAction)this.actionDeleteHistory);
        bars.getMenuManager().add((IContributionItem)new Separator());
        bars.getMenuManager().add((IAction)this.actionResultFilter);
        bars.getToolBarManager().add((IAction)this.actionDeleteHistory);
        bars.getToolBarManager().add((IAction)this.actionResultFilter);
        bars.getToolBarManager().add((IAction)this.actionExport);
    }

    private void makeActions() {
        this.actionViewResult = new Action(){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)ResultsView.this.viewer.getSelection();
                Object obj = selection.getFirstElement();
                if (obj instanceof IAnalysisResult) {
                    IAnalysisResult result = (IAnalysisResult)obj;
                    result.getViewer().showView(result);
                }
            }
        };
        this.actionViewResult.setText(UIMessages.action_view);
        this.actionViewResult.setToolTipText(UIMessages.action_view_tooltip);
        this.actionViewResult.setEnabled(false);
        this.actionDeleteHistory = new Action(){

            public void run() {
                AnalysisHistory history;
                IStructuredSelection selection = (IStructuredSelection)ResultsView.this.viewer.getSelection();
                Object obj = selection.getFirstElement();
                if (obj instanceof AnalysisHistory && (history = (AnalysisHistory)obj).isComplete()) {
                    ResultsModel.instance().deleteHistory(history);
                }
            }
        };
        this.actionDeleteHistory.setText(UIMessages.action_delete);
        this.actionDeleteHistory.setToolTipText(UIMessages.action_delete_tooltip);
        this.actionDeleteHistory.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.actionDeleteHistory.setEnabled(false);
        this.actionResultFilter = new Action(){

            public void run() {
                if (ResultsView.this.actionResultFilter.getText().equals(UIMessages.action_resultFilter_results)) {
                    ResultsView.this.actionResultFilter.setText(UIMessages.action_resultFilter_all);
                    ResultsView.this.actionResultFilter.setToolTipText(UIMessages.action_resultFilter_all_tooltip);
                    ResultsView.this.actionResultFilter.setImageDescriptor(AnalysisUIPlugin.getImageDescriptor(UIMessages.action_resultFilter_all_icon));
                    ResultsView.this.viewer.addFilter((ViewerFilter)ResultsView.this.filter);
                } else {
                    ResultsView.this.actionResultFilter.setText(UIMessages.action_resultFilter_results);
                    ResultsView.this.actionResultFilter.setToolTipText(UIMessages.action_resultFilter_results_tooltip);
                    ResultsView.this.actionResultFilter.setImageDescriptor(AnalysisUIPlugin.getImageDescriptor(UIMessages.action_resultFilter_results_icon));
                    ResultsView.this.viewer.removeFilter((ViewerFilter)ResultsView.this.filter);
                }
                ResultsView.this.viewer.refresh();
            }
        };
        this.actionResultFilter.setText(UIMessages.action_resultFilter_all);
        this.actionResultFilter.setToolTipText(UIMessages.action_resultFilter_all_tooltip);
        this.actionResultFilter.setImageDescriptor(AnalysisUIPlugin.getImageDescriptor(UIMessages.action_resultFilter_all_icon));
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.actionExport = new Action(){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)ResultsView.this.viewer.getSelection();
                Object obj = selection.getFirstElement();
                AnalysisHistory history = (AnalysisHistory)obj;
                IAnalysisElement element = (IAnalysisElement)history.getSelectAnalysisElements().get(0);
                FileDialog dialog = new FileDialog(AnalysisUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
                dialog.setFilterExtensions(new String[]{"*.xml"});
                String path = dialog.open();
                if (path != null) {
                    try {
                        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(path), ResultsView.UTF16);
                        fw.write(element.exportXML(history));
                        fw.close();
                    }
                    catch (IOException e) {
                        Log.severe((String)ResultsView.EMTPY, (Throwable)e);
                    }
                }
            }
        };
        this.actionExport.setText(UIMessages.action_export);
        this.actionExport.setToolTipText(UIMessages.action_export_tooltip);
        this.actionExport.setImageDescriptor(AnalysisUIPlugin.getImageDescriptor(UIMessages.action_export_icon));
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public class QuickFixAction
    extends Action {
        IAnalysisQuickFix quickfix;
        IAnalysisResult element;

        public QuickFixAction(IAnalysisResult element, IAnalysisQuickFix quickfix) {
            this.element = element;
            this.quickfix = quickfix;
        }

        public IAnalysisQuickFix getQuickfix() {
            return this.quickfix;
        }

        public IAnalysisResult getElement() {
            return this.element;
        }
    }
}

