/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.category;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tptp.platform.analysis.core.CoreMessages;
import org.eclipse.tptp.platform.analysis.core.category.DefaultAnalysisCategory;
import org.eclipse.tptp.platform.analysis.core.category.IAnalysisCategory;
import org.eclipse.tptp.platform.analysis.core.element.AbstractAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.element.IAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.history.AnalysisHistory;
import org.eclipse.tptp.platform.analysis.core.history.AnalysisHistoryElement;
import org.eclipse.tptp.platform.analysis.core.logging.Log;
import org.eclipse.tptp.platform.analysis.core.rule.IAnalysisRule;
import org.eclipse.tptp.platform.analysis.core.rule.RuleDetailProvider;
import org.eclipse.tptp.platform.analysis.core.rule.RuleParameter;
import org.eclipse.tptp.platform.analysis.core.viewer.IAnalysisViewer;

public abstract class AbstractAnalysisCategory
extends AbstractAnalysisElement
implements IAnalysisCategory {
    private static final String RULE_PARAMETER = "ruleParameter";
    private static final String QUICKFIX = "quickfix";
    public static final String COMBO_VALUE = "comboValue";
    private boolean isCustomCategory;

    public AbstractAnalysisCategory() {
        super(2);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        super.setInitializationData(config);
        if (this.getIconName() == null) {
            super.setIconName("icons/analysiscategory_obj.gif");
        }
    }

    public IAnalysisViewer getViewer() {
        if (super.getViewer() != null) {
            return super.getViewer();
        }
        return this.getOwner().getViewer();
    }

    public void analyze(AnalysisHistory history) {
        List categories = this.getOwnedElements();
        if (categories != null) {
            Iterator it = categories.iterator();
            while (it.hasNext()) {
                IAnalysisElement element = (IAnalysisElement)it.next();
                if (!history.containsAnalysisElement(element)) continue;
                element.addHistoryResultSet(history.getHistoryId());
                if (element.getElementType() == 2) {
                    ((IAnalysisCategory)element).analyze(history);
                    continue;
                }
                if (element.getElementType() != 3) continue;
                IAnalysisRule rule = (IAnalysisRule)element;
                try {
                    AnalysisHistoryElement historyElement = history.getHistoryElement(rule);
                    historyElement.startElapsedTimer();
                    rule.analyze(history);
                    historyElement.stopElapsedTime();
                }
                catch (Exception e) {
                    Log.severe(CoreMessages.bind((String)CoreMessages.execute_analysisCategory_rule_failure, (Object)rule.getLabel()), e);
                }
            }
        }
    }

    public List getOwnedElements() {
        if (super.getOwnedElements() == null) {
            String className;
            int jCtr;
            IConfigurationElement[] elements;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.tptp.platform.analysis.core.analysisCategory");
            IExtension[] extensions = extensionPoint.getExtensions();
            int iCtr = 0;
            while (iCtr < extensions.length) {
                elements = extensions[iCtr].getConfigurationElements();
                jCtr = 0;
                while (jCtr < elements.length) {
                    String owningCategory = elements[jCtr].getAttribute("category");
                    if (owningCategory != null && owningCategory.equals(this.getId())) {
                        try {
                            IAnalysisCategory category = null;
                            className = elements[jCtr].getAttribute("class");
                            if (className != null) {
                                category = (IAnalysisCategory)elements[jCtr].createExecutableExtension("class");
                            } else {
                                category = new DefaultAnalysisCategory();
                                category.setInitializationData(elements[jCtr], "", null);
                            }
                            this.addOwnedElement(category);
                        }
                        catch (Exception e) {
                            Log.severe(CoreMessages.BUILDING_RULES_ERROR_, e);
                        }
                    }
                    ++jCtr;
                }
                ++iCtr;
            }
            extensionPoint = registry.getExtensionPoint("org.eclipse.tptp.platform.analysis.core.analysisRule");
            extensions = extensionPoint.getExtensions();
            iCtr = 0;
            while (iCtr < extensions.length) {
                elements = extensions[iCtr].getConfigurationElements();
                jCtr = 0;
                while (jCtr < elements.length) {
                    String category = elements[jCtr].getAttribute("category");
                    if (category.equals(this.getId())) {
                        try {
                            IAnalysisRule rule = null;
                            className = elements[jCtr].getAttribute("class");
                            if (className != null) {
                                rule = (IAnalysisRule)elements[jCtr].createExecutableExtension("class");
                                String severity = elements[jCtr].getAttribute("severity");
                                if (severity != null) {
                                    RuleParameter variable = new RuleParameter();
                                    variable.setName("SEVERITY");
                                    variable.setValue(severity);
                                    variable.setStyle("combo");
                                    variable.setType("string");
                                    variable.setLabel(CoreMessages.label_parameter_severity);
                                    variable.addComboValue(CoreMessages.label_parameter_severity_recommendation);
                                    variable.addComboValue(CoreMessages.label_parameter_severity_warning);
                                    variable.addComboValue(CoreMessages.label_parameter_severity_severe);
                                    rule.addParameter(variable);
                                }
                                IConfigurationElement[] children = elements[jCtr].getChildren(QUICKFIX);
                                int kCtr = 0;
                                while (kCtr < children.length) {
                                    rule.setQuickFixId(children[kCtr].getAttribute("id"));
                                    ++kCtr;
                                }
                                children = elements[jCtr].getChildren(RULE_PARAMETER);
                                kCtr = 0;
                                while (kCtr < children.length) {
                                    RuleParameter variable = new RuleParameter();
                                    variable.setName(children[kCtr].getAttribute("name"));
                                    variable.setValue(children[kCtr].getAttribute("value"));
                                    variable.setStyle(children[kCtr].getAttribute("style"));
                                    variable.setType(children[kCtr].getAttribute("type"));
                                    variable.setLabel(children[kCtr].getAttribute("label"));
                                    IConfigurationElement[] comboValues = children[kCtr].getChildren(COMBO_VALUE);
                                    int lCtr = 0;
                                    while (lCtr < comboValues.length) {
                                        variable.addComboValue(comboValues[lCtr].getAttribute("label"));
                                        ++lCtr;
                                    }
                                    rule.addParameter(variable);
                                    ++kCtr;
                                }
                                children = elements[jCtr].getChildren("detailProvider");
                                kCtr = 0;
                                while (kCtr < children.length) {
                                    RuleDetailProvider detail = new RuleDetailProvider();
                                    detail.setProviderId(children[kCtr].getAttribute("providerId"));
                                    detail.setDetailContentFile(children[kCtr].getAttribute("filename"));
                                    detail.setProviderNamespace(extensions[iCtr].getNamespace());
                                    rule.addDetailProvider(detail);
                                    ++kCtr;
                                }
                                this.addOwnedElement(rule);
                            }
                        }
                        catch (Exception e) {
                            Log.severe(CoreMessages.BUILDING_RULES_ERROR_, e);
                        }
                    }
                    ++jCtr;
                }
                ++iCtr;
            }
        }
        return super.getOwnedElements();
    }

    public final boolean isCustom() {
        return this.isCustomCategory;
    }

    public final void setCustom(boolean isCustomCategory) {
        this.isCustomCategory = isCustomCategory;
    }
}

