/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.element;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tptp.platform.analysis.core.AnalysisCorePlugin;
import org.eclipse.tptp.platform.analysis.core.configuration.IAnalysisConfiguration;
import org.eclipse.tptp.platform.analysis.core.element.IAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.history.AnalysisHistory;
import org.eclipse.tptp.platform.analysis.core.manager.IAnalysisProviderManager;
import org.eclipse.tptp.platform.analysis.core.provider.IAnalysisProvider;
import org.eclipse.tptp.platform.analysis.core.result.IAnalysisResult;
import org.eclipse.tptp.platform.analysis.core.rule.RuleDetailProvider;
import org.eclipse.tptp.platform.analysis.core.viewer.IAnalysisViewer;

public class AbstractAnalysisElement
implements IAnalysisElement {
    public static final String DETAIL_PROVIDER = "detailProvider";
    private IAnalysisElement owner;
    private List ownedElements;
    private Hashtable executionHistory;
    private List detailProviders;
    private int elementType;
    private String id;
    private String pluginId;
    private String label;
    private String iconName;
    private String viewerID;
    private String configurationID;
    private String helpID;

    public AbstractAnalysisElement(int newElementType) {
        this.elementType = newElementType;
        this.label = "";
    }

    public void setInitializationData(IConfigurationElement config) {
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        if (config.getAttribute("icon") != null) {
            this.iconName = config.getAttribute("icon");
        }
        String string = this.pluginId = this.iconName != null ? config.getNamespace() : AnalysisCorePlugin.getPluginId();
        if (config.getAttribute("help") != null) {
            this.helpID = config.getAttribute("help");
        }
        if (config.getAttribute("viewer") != null) {
            this.viewerID = config.getAttribute("viewer");
        }
        if (config.getAttribute("configuration") != null) {
            this.configurationID = config.getAttribute("configuration");
        }
    }

    public void addDetailProvider(RuleDetailProvider details) {
        if (this.detailProviders == null) {
            this.detailProviders = new ArrayList();
        }
        this.detailProviders.add(details);
    }

    public List getDetailProviders() {
        return this.detailProviders;
    }

    public IAnalysisElement getOwner() {
        return this.owner;
    }

    public void setOwner(IAnalysisElement owner) {
        if (this.owner == null) {
            this.owner = owner;
        }
    }

    public List getOwnedElements() {
        return this.ownedElements;
    }

    public void addOwnedElement(IAnalysisElement element) {
        if (this.ownedElements == null) {
            this.ownedElements = new ArrayList();
        }
        this.ownedElements.add(element);
        element.setOwner(this);
    }

    public void addOwnedElements(Collection c) {
        if (this.ownedElements == null) {
            this.ownedElements = new ArrayList();
        }
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.addOwnedElement((IAnalysisElement)it.next());
        }
    }

    public void addHistoryResultSet(String historyId) {
        ArrayList resultList;
        if (this.executionHistory == null) {
            this.executionHistory = new Hashtable();
        }
        if ((resultList = this.getHistoryResults(historyId)) == null) {
            resultList = new ArrayList();
            this.executionHistory.put(historyId, resultList);
        }
    }

    public void addHistoryResultSet(String historyId, IAnalysisResult result) {
        ArrayList<IAnalysisResult> resultList;
        if (this.executionHistory == null) {
            this.executionHistory = new Hashtable();
        }
        if ((resultList = this.getHistoryResults(historyId)) == null) {
            resultList = new ArrayList<IAnalysisResult>();
            this.executionHistory.put(historyId, resultList);
        }
        result.setHistoryId(historyId);
        resultList.add(result);
    }

    public void removeHistoryResultSet(String historyId) {
        if (this.ownedElements != null) {
            Iterator it = this.ownedElements.iterator();
            while (it.hasNext()) {
                IAnalysisElement element = (IAnalysisElement)it.next();
                element.removeHistoryResultSet(historyId);
            }
        }
    }

    public List getHistoryResults(String historyId) {
        ArrayList resultList;
        if (this.executionHistory == null) {
            this.executionHistory = new Hashtable();
        }
        if ((resultList = (ArrayList)this.executionHistory.get(historyId)) == null) {
            resultList = new ArrayList();
            this.executionHistory.put(historyId, resultList);
        }
        return resultList;
    }

    public void deleteHistoryResults(String historyId) {
        if (this.executionHistory != null) {
            this.executionHistory.remove(historyId);
        }
    }

    public IAnalysisProvider getProvider() {
        if (this.getElementType() == 1) {
            return (IAnalysisProvider)((Object)this);
        }
        return this.getOwner().getProvider();
    }

    public IAnalysisProviderManager getProviderManager() {
        if (this.getElementType() == 0) {
            return (IAnalysisProviderManager)((Object)this);
        }
        return this.getOwner().getProviderManager();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String newLabel) {
        this.label = newLabel;
    }

    public void setIconName(String newIconName) {
        this.iconName = newIconName;
    }

    public String getIconName() {
        return this.iconName;
    }

    public IAnalysisViewer getViewer() {
        if (this.viewerID != null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.tptp.platform.analysis.core.analysisViewer");
            IExtension[] extensions = extensionPoint.getExtensions();
            int iCtr = 0;
            while (iCtr < extensions.length) {
                try {
                    IConfigurationElement[] elements = extensions[iCtr].getConfigurationElements();
                    int jCtr = 0;
                    while (jCtr < elements.length) {
                        if (elements[jCtr].getAttribute("id").equals(this.viewerID)) {
                            return (IAnalysisViewer)elements[jCtr].createExecutableExtension("class");
                        }
                        ++jCtr;
                    }
                }
                catch (Exception exception) {}
                ++iCtr;
            }
        }
        return null;
    }

    protected void setConfigurationID(String configurationID) {
        this.configurationID = configurationID;
    }

    public IAnalysisConfiguration getConfiguration() {
        if (this.configurationID != null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.tptp.platform.analysis.core.analysisConfiguration");
            IExtension[] extensions = extensionPoint.getExtensions();
            int iCtr = 0;
            while (iCtr < extensions.length) {
                try {
                    IConfigurationElement[] elements = extensions[iCtr].getConfigurationElements();
                    int jCtr = 0;
                    while (jCtr < elements.length) {
                        if (elements[jCtr].getAttribute("id").equals(this.configurationID)) {
                            return (IAnalysisConfiguration)elements[jCtr].createExecutableExtension("class");
                        }
                        ++jCtr;
                    }
                }
                catch (Exception exception) {}
                ++iCtr;
            }
        }
        return null;
    }

    public final String getPluginId() {
        return this.pluginId;
    }

    public final void setPluginId(String pluginId) {
        if (this.pluginId == null || this.getElementType() == 4) {
            this.pluginId = pluginId;
        }
    }

    public void preAnalyze() {
        if (this.getOwnedElements() != null) {
            Iterator it = this.getOwnedElements().iterator();
            while (it.hasNext()) {
                IAnalysisElement element = (IAnalysisElement)it.next();
                element.preAnalyze();
            }
        }
    }

    public int getElementType() {
        return this.elementType;
    }

    public void setElementType(int elementType) {
        this.elementType = elementType;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (this.id == null) {
            this.id = id;
        }
    }

    public String exportXML(AnalysisHistory history) {
        String indent = "";
        IAnalysisElement element = this;
        while (element != null) {
            indent = String.valueOf(indent) + "\t";
            element = element.getOwner();
        }
        StringBuffer result = new StringBuffer();
        result.append(indent).append("<").append(IAnalysisElement.XML_ELEMENT_TAGS[this.getElementType()]).append(" name=\"").append(AnalysisCorePlugin.encodeForXML(this.getLabel())).append("\" id=\"").append(this.getId()).append("\">\r\n");
        if (this.getOwnedElements() != null) {
            Iterator it = this.getOwnedElements().iterator();
            while (it.hasNext()) {
                String report;
                IAnalysisElement child = (IAnalysisElement)it.next();
                if (!history.getSelectAnalysisElements().contains(child) || (report = child.exportXML(history)) == null) continue;
                result.append(report);
            }
        }
        result.append(indent).append("</").append(IAnalysisElement.XML_ELEMENT_TAGS[this.getElementType()]).append(">\r\n");
        return result.toString();
    }

    public String getHelpID() {
        return this.helpID;
    }

    public void setHelpID(String helpID) {
        if (this.helpID == null) {
            this.helpID = helpID;
        }
    }
}

