/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.history;

import com.ibm.icu.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.tptp.platform.analysis.core.CoreMessages;
import org.eclipse.tptp.platform.analysis.core.element.IAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.history.AnalysisHistoryElement;
import org.eclipse.tptp.platform.analysis.core.manager.AbstractAnalysisProviderManager;
import org.eclipse.tptp.platform.analysis.core.manager.IAnalysisProviderManager;

public class AnalysisHistory {
    private static final String TOKEN_SEPARATOR = ", ";
    private static final String TOKEN_OPEN_RESULT = " [";
    private static final String TOKEN_CLOSE_RESULT = "] ";
    private static final String TOKEN_OPEN_TIME = " (";
    private static final String TOKEN_CLOSE_TIME = ")";
    private long historyTimestamp = System.currentTimeMillis();
    private String historyId;
    private List selectedElements;
    private List selectAnalysisElements;
    private String configName;
    private String label = null;
    private HashMap providerPropertyHash;
    private boolean isComplete;
    private static final DateFormat df = DateFormat.getDateTimeInstance((int)1, (int)1);

    public AnalysisHistory(String configName) {
        this.historyId = "" + this.historyTimestamp;
        this.selectedElements = new ArrayList();
        this.selectAnalysisElements = new ArrayList();
        this.configName = configName;
        this.isComplete = false;
    }

    public AnalysisHistory(String configName, String historyId) {
        this.historyId = historyId;
        this.selectedElements = new ArrayList();
        this.selectAnalysisElements = new ArrayList();
        this.configName = configName;
        this.isComplete = false;
    }

    public String getHistoryId() {
        return this.historyId;
    }

    public List getSelectedElements() {
        return this.selectedElements;
    }

    public List getSelectAnalysisElements() {
        return this.selectAnalysisElements;
    }

    public boolean containsAnalysisElement(IAnalysisElement element) {
        return this.selectAnalysisElements.indexOf(element) >= 0;
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = this.buildLabel(this.configName);
        }
        if (this.isComplete) {
            return this.label;
        }
        return CoreMessages.bind((String)CoreMessages.history_resultsPending, (Object)this.label);
    }

    private String buildLabel(String configurationName) {
        StringBuffer sb = new StringBuffer();
        Iterator it = AbstractAnalysisProviderManager.getProviderManagers().iterator();
        while (it.hasNext()) {
            IAnalysisProviderManager manager = (IAnalysisProviderManager)it.next();
            Iterator it2 = manager.getOwnedElements().iterator();
            while (it2.hasNext()) {
                IAnalysisElement element = (IAnalysisElement)it2.next();
                if (!this.containsAnalysisElement(element)) continue;
                if (sb.length() > 0) {
                    sb.append(TOKEN_SEPARATOR);
                }
                sb.append(element.getLabel());
            }
        }
        StringBuffer result = new StringBuffer(configurationName);
        result.append(TOKEN_OPEN_RESULT).append(sb).append(TOKEN_CLOSE_RESULT).append(TOKEN_OPEN_TIME).append(df.format(new Date(this.historyTimestamp))).append(TOKEN_CLOSE_TIME);
        return result.toString();
    }

    public void complete() {
        this.isComplete = true;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public AnalysisHistoryElement getHistoryElement(IAnalysisElement element) {
        Iterator it = this.getSelectedElements().iterator();
        while (it.hasNext()) {
            AnalysisHistoryElement aheChild;
            AnalysisHistoryElement ahe = (AnalysisHistoryElement)it.next();
            if (ahe.getMappedAnalysisElement().equals(element)) {
                return ahe;
            }
            if (ahe.getOwnedMembers() == null || (aheChild = this.getHistoryElement(ahe.getOwnedMembers(), element)) == null) continue;
            return aheChild;
        }
        return null;
    }

    private final AnalysisHistoryElement getHistoryElement(List analysisElements, IAnalysisElement element) {
        Iterator it = analysisElements.iterator();
        while (it.hasNext()) {
            AnalysisHistoryElement aheChild;
            AnalysisHistoryElement ahe = (AnalysisHistoryElement)it.next();
            if (ahe.getMappedAnalysisElement().equals(element)) {
                return ahe;
            }
            if (ahe.getOwnedMembers() == null || (aheChild = this.getHistoryElement(ahe.getOwnedMembers(), element)) == null) continue;
            return aheChild;
        }
        return null;
    }

    public HashMap getProviderPropertyHash() {
        if (this.providerPropertyHash == null) {
            this.providerPropertyHash = new HashMap();
        }
        return this.providerPropertyHash;
    }
}

