/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.history;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.tptp.platform.analysis.core.element.IAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.history.AnalysisHistory;
import org.eclipse.tptp.platform.analysis.core.rule.RuleParameter;

public class AnalysisHistoryElement {
    private AnalysisHistory history;
    private AnalysisHistoryElement parent;
    private IAnalysisElement mappedAnalysisElement;
    private List ownedMembers;
    private List ruleVariables;
    private long elapsedTime;
    private long time;

    public AnalysisHistoryElement(AnalysisHistory history, AnalysisHistoryElement parent, IAnalysisElement mappedAnalysisElement) {
        this.history = history;
        this.mappedAnalysisElement = mappedAnalysisElement;
        this.parent = parent;
        this.elapsedTime = 0L;
        if (parent == null) {
            history.getSelectedElements().add(this);
        } else {
            parent.addOwnedMember(this);
        }
        history.getSelectAnalysisElements().add(mappedAnalysisElement);
    }

    public void addOwnedMember(AnalysisHistoryElement element) {
        if (this.ownedMembers == null) {
            this.ownedMembers = new ArrayList();
        }
        this.ownedMembers.add(element);
    }

    public List getOwnedMembers() {
        return this.ownedMembers;
    }

    public AnalysisHistory getHistory() {
        return this.history;
    }

    public AnalysisHistoryElement getParent() {
        return this.parent;
    }

    public IAnalysisElement getMappedAnalysisElement() {
        return this.mappedAnalysisElement;
    }

    public List getRuleVariables() {
        return this.ruleVariables;
    }

    public RuleParameter getRuleVariable(String name) {
        if (this.ruleVariables != null) {
            Iterator it = this.ruleVariables.iterator();
            while (it.hasNext()) {
                RuleParameter rv = (RuleParameter)it.next();
                if (!rv.getName().equals(name)) continue;
                return rv;
            }
        }
        return null;
    }

    public void setRuleVariables(List ruleVariableList) {
        if (this.mappedAnalysisElement.getElementType() == 3) {
            this.ruleVariables = new ArrayList();
            Iterator it = ruleVariableList.iterator();
            while (it.hasNext()) {
                RuleParameter variable = (RuleParameter)it.next();
                this.ruleVariables.add(variable.copy());
            }
        }
    }

    public void startElapsedTimer() {
        this.time = System.currentTimeMillis();
    }

    public void stopElapsedTime() {
        this.elapsedTime += System.currentTimeMillis() - this.time;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }
}

