/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.history;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.tptp.platform.analysis.core.element.IAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.history.AnalysisHistory;
import org.eclipse.tptp.platform.analysis.core.manager.AbstractAnalysisProviderManager;

public class AnalysisHistoryFactory {
    private static AnalysisHistoryFactory instance;
    private List historyList = new ArrayList();

    public static AnalysisHistoryFactory instance() {
        if (instance == null) {
            instance = new AnalysisHistoryFactory();
        }
        return instance;
    }

    public AnalysisHistory createAnalysisHistory(String configName) {
        AnalysisHistory history = new AnalysisHistory(configName);
        this.historyList.add(0, history);
        return history;
    }

    public AnalysisHistory createAnalysisHistory(String configName, String historyId) {
        AnalysisHistory history = new AnalysisHistory(configName, historyId);
        this.historyList.add(0, history);
        return history;
    }

    public List getHistoryList() {
        return this.historyList;
    }

    public AnalysisHistory getHistory(String historyId) {
        Iterator it = this.historyList.iterator();
        while (it.hasNext()) {
            AnalysisHistory history = (AnalysisHistory)it.next();
            if (!history.getHistoryId().equals(historyId)) continue;
            return history;
        }
        return null;
    }

    public void removeHistory(AnalysisHistory history) {
        Iterator it = AbstractAnalysisProviderManager.getProviderManagers().iterator();
        while (it.hasNext()) {
            IAnalysisElement element = (IAnalysisElement)it.next();
            element.removeHistoryResultSet(history.getHistoryId());
        }
        history.getProviderPropertyHash().clear();
        this.historyList.remove(history);
    }
}

