/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.manager;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.tptp.platform.analysis.core.AnalysisConstants;
import org.eclipse.tptp.platform.analysis.core.AnalysisCorePlugin;
import org.eclipse.tptp.platform.analysis.core.CoreMessages;
import org.eclipse.tptp.platform.analysis.core.category.DefaultAnalysisCategory;
import org.eclipse.tptp.platform.analysis.core.category.IAnalysisCategory;
import org.eclipse.tptp.platform.analysis.core.element.AbstractAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.element.IAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.history.AnalysisHistory;
import org.eclipse.tptp.platform.analysis.core.logging.Log;
import org.eclipse.tptp.platform.analysis.core.manager.DefaultAnalysisViewer;
import org.eclipse.tptp.platform.analysis.core.manager.IAnalysisListener;
import org.eclipse.tptp.platform.analysis.core.manager.IAnalysisProviderManager;
import org.eclipse.tptp.platform.analysis.core.provider.IAnalysisProvider;
import org.eclipse.tptp.platform.analysis.core.rule.IAnalysisRule;
import org.eclipse.tptp.platform.analysis.core.rule.RuleDetailProvider;
import org.eclipse.tptp.platform.analysis.core.rule.RuleParameter;
import org.eclipse.tptp.platform.analysis.core.template.RuleTemplate;
import org.eclipse.tptp.platform.analysis.core.viewer.IAnalysisViewer;
import org.osgi.framework.Bundle;

public abstract class AbstractAnalysisProviderManager
extends AbstractAnalysisElement
implements IAnalysisProviderManager {
    private static final String RULE_PARAMETER = "ruleParameter";
    private static final String COMBO_VALUE = "comboValue";
    private static final String PROVIDER_JOBS = "providers";
    private static ArrayList results;
    private static boolean isBusy;
    private List resources;
    private List listeners;

    static {
        isBusy = false;
    }

    public AbstractAnalysisProviderManager() {
        super(0);
        super.setIconName("icons/analysisprovider_obj.gif");
        this.listeners = new ArrayList();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        super.setInitializationData(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnalysisListener(IAnalysisListener listener) {
        List list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    public void notifyAnalysisListeners(IAnalysisElement element) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((IAnalysisListener)it.next()).analysisComplete(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnalysisListener(IAnalysisListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public void analyze(final AnalysisHistory history, List resourceList) {
        if (!isBusy && super.getOwnedElements().size() > 0) {
            isBusy = true;
            this.resources = resourceList;
            IJobManager manager = Platform.getJobManager();
            IProgressMonitor groupMonitor = manager.createProgressGroup();
            groupMonitor.beginTask(this.getLabel(), super.getOwnedElements().size());
            this.preAnalyze();
            Iterator it2 = super.getOwnedElements().iterator();
            while (it2.hasNext()) {
                final IAnalysisProvider provider = (IAnalysisProvider)it2.next();
                if (groupMonitor.isCanceled() || !history.containsAnalysisElement(provider)) continue;
                Job job = new Job(provider.getLabel()){

                    protected IStatus run(IProgressMonitor monitor) {
                        monitor.beginTask("", AbstractAnalysisProviderManager.this.getOwnedElements().size());
                        provider.addHistoryResultSet(history.getHistoryId());
                        provider.analyze(monitor, history);
                        monitor.worked(1);
                        return Status.OK_STATUS;
                    }

                    public boolean belongsTo(Object family) {
                        return AbstractAnalysisProviderManager.PROVIDER_JOBS.equals(family);
                    }
                };
                job.setProgressGroup(groupMonitor, this.getOwnedElements().size());
                job.schedule();
            }
            try {
                if (!manager.isIdle()) {
                    manager.join((Object)PROVIDER_JOBS, null);
                }
            }
            catch (InterruptedException interruptedException) {}
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ((IAnalysisListener)it.next()).analysisComplete(history);
            }
            isBusy = false;
        }
    }

    public IAnalysisViewer getViewer() {
        if (super.getViewer() != null) {
            return super.getViewer();
        }
        return new DefaultAnalysisViewer();
    }

    public static List getProviderManagers() {
        if (results == null) {
            results = new ArrayList();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.tptp.platform.analysis.core.analysisProviderManager");
            IExtension[] extensions = extensionPoint.getExtensions();
            int iCtr = 0;
            while (iCtr < extensions.length) {
                IConfigurationElement[] elements = extensions[iCtr].getConfigurationElements();
                int jCtr = 0;
                while (jCtr < elements.length) {
                    try {
                        IAnalysisProviderManager manager = (IAnalysisProviderManager)elements[jCtr].createExecutableExtension("class");
                        results.add(manager);
                    }
                    catch (Exception e) {
                        Log.severe(CoreMessages.NO_PROVIDER_MANAGERS_ERROR_, e);
                    }
                    ++jCtr;
                }
                ++iCtr;
            }
        }
        return results;
    }

    public List getOwnedElements() {
        if (super.getOwnedElements() == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.tptp.platform.analysis.core.analysisProvider");
            IExtension[] extensions = extensionPoint.getExtensions();
            int iCtr = 0;
            while (iCtr < extensions.length) {
                IConfigurationElement[] elements = extensions[iCtr].getConfigurationElements();
                int jCtr = 0;
                while (jCtr < elements.length) {
                    try {
                        IAnalysisProvider provider = (IAnalysisProvider)elements[jCtr].createExecutableExtension("class");
                        String manager = elements[jCtr].getAttribute("manager");
                        if (manager == null || manager.length() == 0) {
                            manager = "org.eclipse.tptp.platform.analysis.core.manager.AnalysisProviders";
                        }
                        if (manager.equals(this.getId())) {
                            IConfigurationElement[] children = elements[jCtr].getChildren("detailProvider");
                            int kCtr = 0;
                            while (kCtr < children.length) {
                                RuleDetailProvider detail = new RuleDetailProvider();
                                detail.setProviderId(children[kCtr].getAttribute("providerId"));
                                detail.setDetailContentFile(children[kCtr].getAttribute("filename"));
                                detail.setProviderNamespace(provider.getPluginId());
                                provider.addDetailProvider(detail);
                                ++kCtr;
                            }
                            this.parseTemplates(provider);
                            this.addOwnedElement(provider);
                        }
                    }
                    catch (Exception e) {
                        Log.severe(CoreMessages.PROVIDER_BUILD_ERROR_, e);
                    }
                    ++jCtr;
                }
                ++iCtr;
            }
            this.loadCustomCategories();
            this.loadCustomRules();
        }
        return super.getOwnedElements();
    }

    private void loadCustomCategories() {
        String folder = String.valueOf(AnalysisCorePlugin.getDefault().getStateLocation().toOSString()) + AnalysisConstants.CATEGORY_FOLDER;
        File f = new File(folder);
        File[] files = f.listFiles();
        if (files != null) {
            int iCtr = 0;
            while (iCtr < files.length) {
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(files[iCtr]), "UTF-16"));
                    String id = br.readLine();
                    String label = br.readLine();
                    String ownerId = br.readLine();
                    br.close();
                    IAnalysisElement element = AnalysisCorePlugin.getAnalysisElement(ownerId);
                    if (element != null) {
                        element.getOwnedElements();
                        DefaultAnalysisCategory category = new DefaultAnalysisCategory();
                        element.addOwnedElement(category);
                        category.setLabel(label);
                        category.setId(id);
                        category.setElementType(2);
                        category.setPluginId(AnalysisCorePlugin.getPluginId());
                        category.setIconName("icons/analysiscategory_obj.gif");
                        category.setCustom(true);
                    }
                }
                catch (FileNotFoundException e) {
                    Log.severe("", e);
                }
                catch (IOException e) {
                    Log.severe("", e);
                }
                ++iCtr;
            }
        }
    }

    private void loadCustomRules() {
        String folder = String.valueOf(AnalysisCorePlugin.getDefault().getStateLocation().toOSString()) + AnalysisConstants.RULE_FOLDER;
        File f = new File(folder);
        File[] files = f.listFiles();
        if (files != null) {
            int iCtr = 0;
            while (iCtr < files.length) {
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(files[iCtr]), "UTF-16"));
                    String id = br.readLine();
                    String label = br.readLine();
                    String categoryId = br.readLine();
                    String classNamespace = br.readLine();
                    String className = br.readLine();
                    IAnalysisCategory category = (IAnalysisCategory)AnalysisCorePlugin.getAnalysisElement(categoryId);
                    if (category != null) {
                        Bundle bundle = Platform.getBundle((String)classNamespace);
                        IAnalysisRule rule = (IAnalysisRule)bundle.loadClass(className).newInstance();
                        rule.setId(id);
                        rule.setLabel(label);
                        rule.setIconName("icons/analysisrule_obj.gif");
                        rule.setPluginId(AnalysisCorePlugin.getPluginId());
                        rule.setCustom(true);
                        String parameter = br.readLine();
                        while (parameter != null) {
                            RuleParameter p = new RuleParameter();
                            p.setDescription(br.readLine());
                            p.setLabel(br.readLine());
                            p.setName(br.readLine());
                            p.setStyle(br.readLine());
                            p.setType(br.readLine());
                            p.setValue(br.readLine());
                            rule.addParameter(p);
                            parameter = br.readLine();
                        }
                        br.close();
                        category.addOwnedElement(rule);
                    }
                }
                catch (InstantiationException e) {
                    Log.severe("", e);
                }
                catch (IllegalAccessException e) {
                    Log.severe("", e);
                }
                catch (ClassNotFoundException e) {
                    Log.severe("", e);
                }
                catch (FileNotFoundException e) {
                    Log.severe("", e);
                }
                catch (IOException e) {
                    Log.severe("", e);
                }
                ++iCtr;
            }
        }
    }

    private void parseTemplates(IAnalysisProvider provider) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.tptp.platform.analysis.core.analysisRuleTemplate");
        IExtension[] extensions = extensionPoint.getExtensions();
        int iCtr = 0;
        while (iCtr < extensions.length) {
            IConfigurationElement[] children = extensions[iCtr].getConfigurationElements();
            int kCtr = 0;
            while (kCtr < children.length) {
                if (children[kCtr].getAttribute("provider").equals(provider.getId())) {
                    RuleTemplate template = new RuleTemplate();
                    template.setId(children[kCtr].getAttribute("id"));
                    template.setClassName(children[kCtr].getAttribute("class"));
                    template.setLabel(children[kCtr].getAttribute("label"));
                    template.setPluginId(extensions[iCtr].getNamespace());
                    IConfigurationElement[] parameters = children[kCtr].getChildren(RULE_PARAMETER);
                    int jCtr = 0;
                    while (jCtr < parameters.length) {
                        RuleParameter parameter = new RuleParameter();
                        parameter.setLabel(parameters[jCtr].getAttribute("label"));
                        parameter.setName(parameters[jCtr].getAttribute("name"));
                        parameter.setStyle(parameters[jCtr].getAttribute("style"));
                        parameter.setType(parameters[jCtr].getAttribute("type"));
                        parameter.setDescription(parameters[jCtr].getAttribute("description"));
                        IConfigurationElement[] comboValues = parameters[jCtr].getChildren(COMBO_VALUE);
                        int lCtr = 0;
                        while (lCtr < comboValues.length) {
                            parameter.addComboValue(comboValues[lCtr].getAttribute("label"));
                            ++lCtr;
                        }
                        template.addParameter(parameter);
                        ++jCtr;
                    }
                    provider.addTemplate(template);
                }
                ++kCtr;
            }
            ++iCtr;
        }
    }

    public List getResources() {
        return this.resources;
    }
}

