/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.provider;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tptp.platform.analysis.core.CoreMessages;
import org.eclipse.tptp.platform.analysis.core.category.DefaultAnalysisCategory;
import org.eclipse.tptp.platform.analysis.core.category.IAnalysisCategory;
import org.eclipse.tptp.platform.analysis.core.element.AbstractAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.history.AnalysisHistory;
import org.eclipse.tptp.platform.analysis.core.history.AnalysisHistoryFactory;
import org.eclipse.tptp.platform.analysis.core.logging.Log;
import org.eclipse.tptp.platform.analysis.core.provider.IAnalysisProvider;
import org.eclipse.tptp.platform.analysis.core.rule.RuleDetailProvider;
import org.eclipse.tptp.platform.analysis.core.template.RuleTemplate;
import org.eclipse.tptp.platform.analysis.core.viewer.IAnalysisViewer;

public abstract class AbstractAnalysisProvider
extends AbstractAnalysisElement
implements IAnalysisProvider {
    private List ruleTemplates;

    public AbstractAnalysisProvider() {
        super(1);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        super.setInitializationData(config);
        if (this.getIconName() == null) {
            super.setIconName("icons/analysisprovider_obj.gif");
        }
    }

    public IAnalysisViewer getViewer() {
        if (super.getViewer() != null) {
            return super.getViewer();
        }
        return this.getOwner().getViewer();
    }

    public List getResources() {
        return this.getProviderManager().getResources();
    }

    public void analyze(IProgressMonitor parentMonitor, AnalysisHistory history) {
        List categories = this.getOwnedElements();
        parentMonitor.beginTask(CoreMessages.analysis_processing, categories.size());
        Iterator it = categories.iterator();
        while (it.hasNext()) {
            if (parentMonitor.isCanceled()) {
                return;
            }
            IAnalysisCategory category = (IAnalysisCategory)it.next();
            if (history.containsAnalysisElement(category)) {
                category.analyze(history);
            }
            parentMonitor.worked(1);
        }
        parentMonitor.done();
        this.getProviderManager().notifyAnalysisListeners(this);
    }

    public List getOwnedElements() {
        if (super.getOwnedElements() == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.tptp.platform.analysis.core.analysisCategory");
            IExtension[] extensions = extensionPoint.getExtensions();
            int iCtr = 0;
            while (iCtr < extensions.length) {
                IConfigurationElement[] elements = extensions[iCtr].getConfigurationElements();
                int jCtr = 0;
                while (jCtr < elements.length) {
                    try {
                        String provider = elements[jCtr].getAttribute("provider");
                        if (provider != null && provider.equals(this.getId())) {
                            IAnalysisCategory category = null;
                            String className = elements[jCtr].getAttribute("class");
                            if (className != null) {
                                category = (IAnalysisCategory)elements[jCtr].createExecutableExtension("class");
                            } else {
                                category = new DefaultAnalysisCategory();
                                category.setInitializationData(elements[jCtr], "", null);
                            }
                            IConfigurationElement[] children = elements[jCtr].getChildren("detailProvider");
                            int kCtr = 0;
                            while (kCtr < children.length) {
                                RuleDetailProvider detail = new RuleDetailProvider();
                                detail.setProviderId(children[kCtr].getAttribute("providerId"));
                                detail.setDetailContentFile(children[kCtr].getAttribute("filename"));
                                detail.setProviderNamespace(extensions[iCtr].getNamespace());
                                category.addDetailProvider(detail);
                                ++kCtr;
                            }
                            this.addOwnedElement(category);
                        }
                    }
                    catch (Exception e) {
                        Log.severe(CoreMessages.CATEGORY_BUILD_ERROR_, e);
                    }
                    ++jCtr;
                }
                ++iCtr;
            }
        }
        return super.getOwnedElements();
    }

    public void setProperty(String historyId, String name, Object data) {
        AnalysisHistory history = AnalysisHistoryFactory.instance().getHistory(historyId);
        history.getProviderPropertyHash().put(name, data);
    }

    public Object getProperty(String historyId, String name) {
        AnalysisHistory history = AnalysisHistoryFactory.instance().getHistory(historyId);
        return history.getProviderPropertyHash().get(name);
    }

    public void removeProperty(String historyId, String name) {
        AnalysisHistory history = AnalysisHistoryFactory.instance().getHistory(historyId);
        history.getProviderPropertyHash().remove(name);
    }

    public void addTemplate(RuleTemplate template) {
        if (this.ruleTemplates == null) {
            this.ruleTemplates = new ArrayList();
        }
        this.ruleTemplates.add(template);
    }

    public List getRuleTemplates() {
        return this.ruleTemplates;
    }
}

