/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.core.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tptp.platform.analysis.core.AnalysisCorePlugin;
import org.eclipse.tptp.platform.analysis.core.element.AbstractAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.element.IAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.history.AnalysisHistory;
import org.eclipse.tptp.platform.analysis.core.quickfix.IAnalysisQuickFix;
import org.eclipse.tptp.platform.analysis.core.result.IAnalysisResult;
import org.eclipse.tptp.platform.analysis.core.rule.IAnalysisRule;
import org.eclipse.tptp.platform.analysis.core.rule.RuleParameter;
import org.eclipse.tptp.platform.analysis.core.viewer.IAnalysisViewer;

public abstract class AbstractAnalysisRule
extends AbstractAnalysisElement
implements IAnalysisRule {
    private static final String IMAGE_EXTENSION = "_obj.gif";
    private static final String IMAGE_QUICK_FIX = "quickfix";
    private static final String IMAGE_PROBLEM = "icons/rulesevere";
    private static final String IMAGE_WARNING = "icons/rulewarn";
    private static final String IMAGE_RECOMMENDATION = "icons/rulercmdation";
    private boolean isCustomRule;
    private HashMap quickFixIds;
    private IAnalysisQuickFix quickfix;
    private List variableList;

    public AbstractAnalysisRule() {
        super(3);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        super.setInitializationData(config);
        if (this.getIconName() == null) {
            super.setIconName("icons/analysisrule_obj.gif");
        }
    }

    public String getLabelWithVariables() {
        String label = super.getLabel();
        int index = label.indexOf("<");
        boolean moreVariables = index > -1;
        while (moreVariables) {
            int endIndex = label.indexOf(">", index + 1);
            if (endIndex == -1) {
                moreVariables = false;
                continue;
            }
            String variable = label.substring(index + 1, endIndex);
            RuleParameter rv = this.getParameter(variable);
            if (rv != null && rv.getValue() != null) {
                label = AnalysisCorePlugin.replace(label, "<" + variable + ">", rv.getValue());
            }
            boolean bl = moreVariables = (index = label.indexOf("<", index)) > -1;
        }
        return label;
    }

    public String getIconName() {
        RuleParameter rv;
        String quickFixImage = "";
        if (this.hasQuickFixes()) {
            quickFixImage = IMAGE_QUICK_FIX;
        }
        if ((rv = this.getParameter("SEVERITY")) != null && rv.getValue() != null) {
            if (rv.getValue().equals("2")) {
                return IMAGE_PROBLEM + quickFixImage + IMAGE_EXTENSION;
            }
            if (rv.getValue().equals("1")) {
                return IMAGE_WARNING + quickFixImage + IMAGE_EXTENSION;
            }
            if (rv.getValue().equals("0")) {
                return IMAGE_RECOMMENDATION + quickFixImage + IMAGE_EXTENSION;
            }
        }
        return super.getIconName();
    }

    public boolean hasQuickFixes() {
        return this.quickFixIds != null && this.quickFixIds.size() > 0;
    }

    public void setQuickFixId(String newId) {
        if (newId != null) {
            if (this.quickFixIds == null) {
                this.quickFixIds = new HashMap();
            }
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.tptp.platform.analysis.core.analysisRuleQuickFix");
            IExtension[] extensions = extensionPoint.getExtensions();
            int iCtr = 0;
            while (iCtr < extensions.length) {
                try {
                    IConfigurationElement[] elements = extensions[iCtr].getConfigurationElements();
                    int jCtr = 0;
                    while (jCtr < elements.length) {
                        if (elements[jCtr].getAttribute("id").equals(newId)) {
                            this.quickfix = (IAnalysisQuickFix)elements[jCtr].createExecutableExtension("class");
                            this.quickFixIds.put(newId, this.quickfix);
                        }
                        ++jCtr;
                    }
                }
                catch (Exception exception) {}
                ++iCtr;
            }
        }
    }

    public Iterator getQuickFixIterator() {
        if (this.hasQuickFixes()) {
            return this.quickFixIds.keySet().iterator();
        }
        return null;
    }

    public IAnalysisQuickFix getQuickFix(String newId) {
        if (this.hasQuickFixes()) {
            return (IAnalysisQuickFix)this.quickFixIds.get(newId);
        }
        return null;
    }

    public IAnalysisViewer getViewer() {
        if (super.getViewer() != null) {
            return super.getViewer();
        }
        return this.getOwner().getViewer();
    }

    public abstract void analyze(AnalysisHistory var1);

    public final List getOwnedElements() {
        return null;
    }

    public void addParameter(RuleParameter parameter) {
        RuleParameter rv;
        if (this.variableList == null) {
            this.variableList = new ArrayList();
        }
        if ((rv = this.getParameter(parameter.getName())) != null) {
            rv.setValue(parameter.getValue());
        } else {
            this.variableList.add(parameter);
        }
    }

    public void addParameters(List parameters) {
        Iterator it = parameters.iterator();
        while (it.hasNext()) {
            RuleParameter rv = (RuleParameter)it.next();
            this.addParameter(rv);
        }
    }

    public RuleParameter getParameter(String name) {
        if (this.variableList != null) {
            Iterator it = this.variableList.iterator();
            while (it.hasNext()) {
                RuleParameter rv = (RuleParameter)it.next();
                if (!rv.getName().equals(name)) continue;
                return rv;
            }
        }
        return null;
    }

    public List getParameterList() {
        if (this.variableList != null) {
            return this.variableList;
        }
        return null;
    }

    public int getParameterCount() {
        if (this.variableList != null) {
            return this.variableList.size();
        }
        return 0;
    }

    public int getVisibleVariableCount() {
        if (this.variableList != null) {
            int iCtr = 0;
            Iterator it = this.variableList.iterator();
            while (it.hasNext()) {
                RuleParameter rv = (RuleParameter)it.next();
                if (rv.getLabel() == null || rv.getLabel().length() <= 0) continue;
                ++iCtr;
            }
            return iCtr;
        }
        return 0;
    }

    public String exportXML(AnalysisHistory history) {
        StringBuffer result = new StringBuffer();
        if (this.getHistoryResults(history.getHistoryId()) != null) {
            String indent = "";
            IAnalysisElement element = this;
            while (element != null) {
                indent = String.valueOf(indent) + "\t";
                element = element.getOwner();
            }
            result.append(indent).append("<").append(IAnalysisElement.XML_ELEMENT_TAGS[this.getElementType()]).append(" name=\"").append(AnalysisCorePlugin.encodeForXML(this.getLabel())).append("\" id=\"").append(this.getId()).append("\">\r\n");
            Iterator it = this.getHistoryResults(history.getHistoryId()).iterator();
            while (it.hasNext()) {
                IAnalysisResult child = (IAnalysisResult)it.next();
                String report = child.exportXML(history);
                if (report == null) continue;
                result.append(report);
            }
            result.append(indent).append("</").append(IAnalysisElement.XML_ELEMENT_TAGS[this.getElementType()]).append(">\r\n");
        }
        return result.toString();
    }

    public final boolean isCustom() {
        return this.isCustomRule;
    }

    public final void setCustom(boolean isCustomRule) {
        this.isCustomRule = isCustomRule;
    }
}

