/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.logc;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.hyades.uml2sd.ui.drawings.IImage;
import org.eclipse.hyades.uml2sd.ui.drawings.impl.ImageImpl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tptp.platform.log.views.internal.LogViewsPlugin;

public class SDLogcPluginImages {
    private static URL fgIconBaseURL = null;
    public static final String T_OBJ = "obj16";
    public static final String T_OVR = "ovr16";
    public static final String IMG_THREAD = "thread_obj.gif";
    public static final String IMG_LOG = "log_obj.gif";
    public static final String IMG_PLUS = "plus_obj.gif";
    public static final String IMG_MINUS = "minus_obj.gif";
    public static final ImageDescriptor DESC_IMG_THREAD;
    public static final ImageDescriptor DESC_IMG_LOG;
    public static final ImageDescriptor DESC_IMG_PLUS;
    public static final ImageDescriptor DESC_IMG_MINUS;
    protected static Map _images;
    protected static Map _imageDescriptors;

    static {
        try {
            fgIconBaseURL = new URL(LogViewsPlugin.getDefault().getBundle().getEntry("/"), "icons/full/");
        }
        catch (MalformedURLException e) {
            LogViewsPlugin.log(e);
        }
        DESC_IMG_THREAD = SDLogcPluginImages.createManaged(T_OBJ, IMG_THREAD);
        DESC_IMG_LOG = SDLogcPluginImages.createManaged(T_OBJ, IMG_LOG);
        DESC_IMG_PLUS = SDLogcPluginImages.createManaged(T_OVR, IMG_PLUS);
        DESC_IMG_MINUS = SDLogcPluginImages.createManaged(T_OVR, IMG_MINUS);
    }

    public static IImage getImage(String name) {
        return (IImage)_images.get(name);
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        return (ImageDescriptor)_imageDescriptors.get(name);
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)SDLogcPluginImages.makeIconFileURL(prefix, name));
            if (_images == null || _imageDescriptors == null) {
                _images = new Hashtable();
                _imageDescriptors = new Hashtable();
            }
            _imageDescriptors.put(name, result);
            _images.put(name, new ImageImpl(result.createImage()));
            return result;
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        StringBuffer buffer;
        if (fgIconBaseURL == null) {
            throw new MalformedURLException();
        }
        if (prefix != null) {
            buffer = new StringBuffer(prefix);
            buffer.append('/');
            buffer.append(name);
        } else {
            buffer = new StringBuffer(name);
        }
        return new URL(fgIconBaseURL, buffer.toString());
    }

    public static void shutdown() {
        if (_images == null) {
            return;
        }
        Iterator e = _images.values().iterator();
        while (e.hasNext()) {
            Object next = e.next();
            if (!(next instanceof IImage) || ((Image)((IImage)next).getImage()).isDisposed()) continue;
            ((IImage)next).dispose();
        }
        _images.clear();
        _images = null;
        _imageDescriptors.clear();
        _imageDescriptors = null;
    }

    public static void dispose(String name) {
        IImage image = (IImage)_images.get(name);
        if (image != null) {
            _images.remove(image);
            image.dispose();
        }
    }
}

