/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.logc.internal.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.logc.internal.util.CorrelationHelper;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.cbe.impl.CBEPackageImpl;
import org.eclipse.hyades.models.cbe.util.LogQueryBuilder;
import org.eclipse.hyades.models.hierarchy.CorrelationContainer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.Operand;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByElement;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.TimeBasedCorrelationQuery;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.IFilterElement;
import org.eclipse.hyades.models.hierarchy.util.ILogFilterCriteria;
import org.eclipse.hyades.models.hierarchy.util.ISortElement;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.models.hierarchy.util.internal.HierarchyXMIQueryEngine;
import org.eclipse.hyades.models.hierarchy.util.internal.QueryUtils;
import org.eclipse.hyades.sd.logc.SDLogcPluginImages;
import org.eclipse.hyades.sd.logc.internal.preferences.ILogInteractionsPreferenceListener;
import org.eclipse.hyades.sd.logc.internal.uml2sd.LogAsyncMessage;
import org.eclipse.hyades.sd.logc.internal.uml2sd.LogAsyncReturnMessage;
import org.eclipse.hyades.sd.logc.internal.uml2sd.LogGraphNode;
import org.eclipse.hyades.sd.logc.internal.uml2sd.LogHotSpot;
import org.eclipse.hyades.sd.logc.internal.uml2sd.SourceOutOfPageMessage;
import org.eclipse.hyades.sd.logc.internal.uml2sd.TargetOutOfPageMessage;
import org.eclipse.hyades.sd.logc.internal.util.ContextIds;
import org.eclipse.hyades.sd.logc.internal.util.LogCorrelationSelectionDialog;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.ui.filters.FilterActions;
import org.eclipse.hyades.ui.filters.IFilterQueryProvider;
import org.eclipse.hyades.ui.filters.IFilterViewer;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.uml2sd.ui.actions.provider.IExtendedFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.IExtendedFindProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDPagingProvider;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.BasicExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;
import org.eclipse.hyades.uml2sd.ui.drawings.IImage;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tptp.platform.log.views.internal.LogViewsMessages;
import org.eclipse.tptp.platform.log.views.internal.LogViewsPlugin;
import org.eclipse.tptp.platform.log.views.internal.actions.provider.ILogFilterProvider;
import org.eclipse.tptp.platform.log.views.internal.actions.provider.ILogFindProvider;
import org.eclipse.tptp.platform.log.views.internal.util.FilterTableElement;
import org.eclipse.tptp.platform.log.views.internal.util.FiltersDialog;
import org.eclipse.tptp.platform.log.views.internal.util.IRecordPaneViewerListener;
import org.eclipse.tptp.platform.log.views.internal.util.LogFilterCriteria;
import org.eclipse.tptp.platform.log.views.internal.util.LogFindCriteria;
import org.eclipse.tptp.platform.log.views.internal.util.LogRecordSearch;
import org.eclipse.tptp.platform.log.views.internal.util.LogUtil;
import org.eclipse.tptp.platform.log.views.internal.util.LogViewsMessageDialog;
import org.eclipse.tptp.platform.log.views.internal.util.RecordChangeEvent;
import org.eclipse.tptp.platform.log.views.internal.util.RecordFilterSearchUtil;
import org.eclipse.tptp.platform.log.views.internal.util.SearchRecordDialog;
import org.eclipse.tptp.platform.log.views.internal.util.SortElement;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;

public class LogInteractions
implements IUml2SDLoader,
ISelectionListener,
ISelectionChangedListener,
IViewSelectionChangedListener,
ISDAdvancedPagingProvider,
ILogInteractionsPreferenceListener,
IExtendedFilterProvider,
IExtendedFindProvider,
ILogFilterProvider,
ILogFindProvider,
IProfileEventListener,
IJobChangeListener,
IRecordPaneViewerListener,
IFilterViewer {
    protected CorrelationContainerProxy correlationContainerProxy;
    protected EObject inputObject;
    protected Map graphNodes = new HashMap();
    protected Map lifelinesMap = new HashMap();
    protected List eventsList = new ArrayList();
    protected Set eventsSet = new HashSet();
    protected Map currentPageEvents = new HashMap();
    protected List agentProxiesList = new ArrayList();
    protected SDView view;
    private Map sourceOutOfPageMessages;
    private Map targetOutOfPageMessages;
    private Map dummyMessages;
    private IConfigurationElement correlationType;
    private LogRecordComparator comparator;
    private CBECommonBaseEvent currentSelection;
    private CBECommonBaseEvent thisSelection;
    private SearchRecordDialog searchDialog;
    private LogFilterCriteria criteria = null;
    private boolean isInputXMI = true;
    private SimpleSearchQuery query = null;
    private QueryResult outBoundCorrelations = null;
    private QueryResult inboundCorrelations = null;
    private final int TIME_CONVERSION_FACTOR = 1000000;
    private PerfUtil p;
    private int viewOption = -1;
    private IFilterQueryProvider _filterQueryProvider;
    private boolean selectionChangedByLoader = false;
    protected boolean fPartVisible = true;
    protected boolean fForceRefresh = true;
    protected IPartListener2 fPartListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference ref) {
            LogInteractions.this.searchDialog = LogUtil.getSearchDialog();
            if (ref.getPart(false) == LogInteractions.this.view && LogInteractions.this.searchDialog != null) {
                LogInteractions.this.searchDialog.setFindProvider(LogInteractions.this);
                LogInteractions.this.searchDialog.enableButton(true);
                LogInteractions.this.logRecordSearch = null;
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
            LogInteractions.this.searchDialog = LogUtil.getSearchDialog();
            if (ref.getPart(false) == LogInteractions.this.view && LogInteractions.this.searchDialog != null) {
                LogInteractions.this.searchDialog.enableButton(false);
            }
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (ref != null && ref.getPart(false) == LogInteractions.this.view) {
                LogInteractions.this.fPartVisible = true;
                if (LogInteractions.this.fForceRefresh) {
                    LogInteractions.this.fForceRefresh = false;
                    LogInteractions.this.refresh();
                }
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            if (ref != null && ref.getPart(false) == LogInteractions.this.view) {
                LogInteractions.this.fPartVisible = false;
            }
        }
    };
    private int currentPageIndex = 0;
    private int nrOfPages = 0;
    private int PAGE_SIZE = 0;
    private int MAX_NR_OF_RECORDS = 99999;
    private int totalSize = 0;
    private boolean filterChanged = false;
    private final int NODE_SIZE = 24;
    private IFilterElement[] filterTableElements = null;
    private RecordFilterSearchUtil recordFilterSearch = null;
    private Object[] pageCache;
    private LogRecordSearch logRecordSearch = null;
    protected List expandedList = new ArrayList();
    private boolean _findRecordSelection;
    protected LogInteractionsFrame frame;
    protected static LifelineCategories[] traceCategories = new LifelineCategories[1];
    protected static IImage image;
    public static final int CATEGORY_LOGS = 0;
    private boolean debug = false;

    static {
        LogInteractions.traceCategories[0] = new LifelineCategories();
        traceCategories[0].setName("");
        image = SDLogcPluginImages.getImage("log_obj.gif");
        traceCategories[0].setImage(image);
    }

    public LogInteractions() {
        UIPlugin.getDefault().addSelectionListener((ISelectionListener)this);
        UIPlugin.getDefault().addViewSelectionChangedListener((IViewSelectionChangedListener)this);
        UIPlugin.getDefault().addProfileEventListener((IProfileEventListener)this);
        CorrelationHelper.getInstance().addJobChangeListener((IJobChangeListener)this);
        LogViewsPlugin.getDefault().addRecordPaneViewerListener(this);
        this.recordFilterSearch = new RecordFilterSearchUtil();
        this._findRecordSelection = false;
    }

    public void setViewer(SDView view) {
        this.view = view;
        view.setSDPagingProvider((ISDPagingProvider)this);
        view.setExtendedFilterProvider((IExtendedFilterProvider)this);
        view.setExtendedFindProvider((IExtendedFindProvider)this);
        view.getSDWidget().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        view.getSite().setSelectionProvider(view.getSDWidget().getSelectionProvider());
        view.getViewSite().getPage().addPartListener(this.fPartListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.view.getSDWidget(), ContextIds.INTERACTION_VIEW);
    }

    public void aboutToBeReplaced() {
        UIPlugin.getDefault().removeSelectionListener((ISelectionListener)this);
        UIPlugin.getDefault().removeViewSelectionChangedListener((IViewSelectionChangedListener)this);
        UIPlugin.getDefault().removeProfileEventListener((IProfileEventListener)this);
        CorrelationHelper.getInstance().removeJobChangeListener((IJobChangeListener)this);
        if (this.view != null && !this.view.getSDWidget().isDisposed()) {
            this.view.getSDWidget().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        LogViewsPlugin.getDefault().removeRecordPaneViewerListener(this);
        this.clearDiagramCaches();
        this.view.getViewSite().getPage().removePartListener(this.fPartListener);
        this.recordFilterSearch = null;
    }

    public void generateLogInteractions(EObject eObject, boolean displayDialog) {
        this.p = this.getPerformanceMonitor();
        this.p.setMessageAndStart("generateLogInteractions 1");
        this.view.setFrame((Frame)this.parseModel(eObject, displayDialog, false));
        this.disableMessageActions();
        this.p.stopAndPrintStatus();
    }

    public void generateLogInteractions(EObject eObject, IConfigurationElement config) {
        this.p = this.getPerformanceMonitor();
        this.p.setMessageAndStart("generateLogInteractions 2");
        this.setCorrelationType(config);
        this.view.setFrame((Frame)this.parseModel((EObject)CorrelationHelper.getInstance().createCorrelationContainer(this.correlationType, (Object)eObject, this.correlationType.getAttribute("name")), false, false));
        this.disableMessageActions();
        this.p.stopAndPrintStatus();
    }

    public LogInteractionsFrame parseModel(EObject eObject, final boolean displayDialog, final boolean refresh) {
        this.inputObject = eObject;
        this.correlationContainerProxy = null;
        this.clearDiagramCaches();
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            public void run() {
                LogInteractions.this.loadCorrelations(displayDialog);
                LogInteractions.this.createPartition();
                LogInteractions.this.frame = LogInteractions.this.createPage(refresh);
            }
        });
        return this.frame;
    }

    public LogInteractionsFrame parseModel(EObject eObject) {
        return this.parseModel(eObject, false, false);
    }

    protected void refresh() {
        if (this.inputObject != null) {
            if (this.view != null && !this.view.getSDWidget().isDisposed()) {
                Object sel = UIPlugin.getDefault().getSelectionModel(HyadesUtil.getMofObject()).getFirstElement();
                LogInteractionsFrame frame = this.parseModel(this.inputObject, false, true);
                if (sel != null && sel instanceof CBECommonBaseEvent) {
                    this.setSelection((CBECommonBaseEvent)sel);
                } else {
                    this.view.setFrame((Frame)frame);
                }
            }
        } else if (this.view != null && !this.view.getSDWidget().isDisposed()) {
            this.view.setFrame(new Frame());
        }
    }

    protected List getFilteredEventsXMI(List input) {
        if (input == null) {
            return new ArrayList(0);
        }
        ArrayList filteredList = new ArrayList();
        int i = 0;
        while (i < input.size()) {
            Object entry = input.get(i);
            if (this.isFilterApplied((EObject)entry)) {
                filteredList.add(entry);
            }
            ++i;
        }
        Collections.sort(filteredList, this.getComparator());
        return filteredList;
    }

    private boolean isFilterApplied(EObject event) {
        if (this.filterTableElements == null || this.filterTableElements.length == 0) {
            return true;
        }
        return this.recordFilterSearch.isAdvFilterApply(event, this.filterTableElements);
    }

    protected void clearTemporaryCaches() {
        this.graphNodes.clear();
        this.lifelinesMap.clear();
        this.currentPageEvents.clear();
        if (this.sourceOutOfPageMessages != null) {
            this.sourceOutOfPageMessages.clear();
        }
        if (this.targetOutOfPageMessages != null) {
            this.targetOutOfPageMessages.clear();
        }
        if (this.dummyMessages != null) {
            this.dummyMessages.clear();
        }
    }

    protected void clearDiagramCaches() {
        this.clearTemporaryCaches();
        this.agentProxiesList.clear();
        this.eventsSet.clear();
        if (this.eventsList != null) {
            this.eventsList.clear();
            this.eventsList = null;
            this.eventsList = new ArrayList(0);
        }
        if (this.pageCache != null) {
            int i = 0;
            while (i < this.pageCache.length) {
                this.pageCache[i] = null;
                ++i;
            }
            this.pageCache = null;
        }
        this.expandedList.clear();
    }

    protected void loadCorrelations(boolean displayDialog) {
        this.p = this.getPerformanceMonitor();
        this.p.setMessageAndStart("loadEvents");
        if (this.inputObject instanceof CorrelationContainerProxy) {
            this.correlationContainerProxy = (CorrelationContainerProxy)this.inputObject;
        } else if (displayDialog) {
            this.loadAgentsFromObject();
            this.showCorrelationDialog();
        }
        if (this.agentProxiesList.isEmpty()) {
            this.loadAgents();
        }
        this.setInputType();
        List filters = FilterTableElement.createFilterTableElementFromString(LogViewsPlugin.getDefault().getPreferenceStore().getString("pd_adv_filter_options"));
        this.filterTableElements = filters != null ? filters.toArray(new IFilterElement[filters.size()]) : new IFilterElement[0];
        if (this.isInputXMI()) {
            this.loadEventsXMI();
        } else {
            this.loadEventsSQL();
        }
        this.p.stopAndPrintStatus();
    }

    private void loadAgents() {
        if (this.correlationContainerProxy != null) {
            this.agentProxiesList.addAll(this.correlationContainerProxy.getCorrelatedAgents());
        } else {
            this.loadAgentsFromObject();
        }
    }

    private void loadAgentsFromObject() {
        Collection xmiAgentProxies = HyadesUtil.getLogAgents((EObject)this.inputObject, (int)0);
        Collection sqlAgentProxies = HyadesUtil.getLogAgents((EObject)this.inputObject, (int)1);
        if (this.viewOption == 0) {
            this.agentProxiesList.addAll(xmiAgentProxies);
        } else if (this.viewOption == 1) {
            this.agentProxiesList.addAll(sqlAgentProxies);
        } else if (xmiAgentProxies.isEmpty()) {
            this.agentProxiesList.addAll(sqlAgentProxies);
        } else if (sqlAgentProxies.isEmpty()) {
            this.agentProxiesList.addAll(xmiAgentProxies);
        } else {
            if (xmiAgentProxies.isEmpty() && sqlAgentProxies.isEmpty()) {
                return;
            }
            this.viewOption = LogViewsMessageDialog.openLogViewsInformation(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), LogViewsMessages._67, LogViewsMessages._68);
            if (this.viewOption == 0) {
                this.agentProxiesList.addAll(xmiAgentProxies);
            } else if (this.viewOption == 1) {
                this.agentProxiesList.addAll(sqlAgentProxies);
            }
        }
    }

    private List getFilteredEventsSQL() {
        this.query = this.getQueryForSQL(this.agentProxiesList, false);
        this.query.getOrderByExpresions().clear();
        this.query.getOrderByExpresions().addAll(this.createCustomOrderByClause());
        QueryResult queryResult = LogQueryBuilder.executeQuery((Query)this.query, (ResourceSet)HierarchyResourceSetImpl.getInstance());
        if (queryResult == null) {
            return new ArrayList(0);
        }
        ResultEntry resultEntry = (ResultEntry)queryResult.getResultEntries().get(0);
        return (List)resultEntry.getValue();
    }

    protected void loadEventsSQL() {
        Iterator iter = this.agentProxiesList.iterator();
        while (iter.hasNext()) {
            TRCAgentProxy element = (TRCAgentProxy)iter.next();
            element.getAgent();
        }
        if (!this.isDisplayingOnlyCorrelations()) {
            this.eventsList = this.getFilteredEventsSQL();
        } else {
            this.loadEventsFromCorrelationsSQL();
        }
    }

    protected void loadEventsFromCorrelationsSQL() {
        if (this.correlationContainerProxy == null) {
            this.eventsList = new ArrayList(0);
            return;
        }
        try {
            CorrelationContainer correlationContainer = (CorrelationContainer)this.correlationContainerProxy.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getCorrelationContainerProxy_CorrelationContainer(), false);
            if (correlationContainer == null) {
                return;
            }
            URI correlationContainerURI = EcoreUtil.getURI((EObject)correlationContainer);
            this.query = this.getQueryForSQL(this.agentProxiesList, true);
            this.query.getOrderByExpresions().clear();
            this.query.getOrderByExpresions().addAll(this.createCustomOrderByClause());
            ((TimeBasedCorrelationQuery)this.query).setCorrelationContainerURI(correlationContainerURI.toString());
            QueryResult queryResult = LogQueryBuilder.executeQuery((Query)this.query, (ResourceSet)HierarchyResourceSetImpl.getInstance());
            if (queryResult != null) {
                ResultEntry resultEntry = (ResultEntry)queryResult.getResultEntries().get(0);
                this.eventsList = (List)resultEntry.getValue();
            }
        }
        catch (Exception e) {
            if (this.debug) {
                e.printStackTrace();
            }
            LogViewsPlugin.log(e);
            this.eventsList = new ArrayList(0);
        }
    }

    private Collection createCustomOrderByClause() {
        ArrayList<OrderByElement> c = new ArrayList<OrderByElement>();
        SimpleOperand operand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        operand.setFeature((EStructuralFeature)CBEPackage.eINSTANCE.getCBECommonBaseEvent_CreationTime());
        OrderByElement orderByElement = ExtensionsFactory.eINSTANCE.createOrderByElement();
        orderByElement.setOperand((Operand)operand);
        orderByElement.setOperator(OrderByOperators.ASC_LITERAL);
        c.add(orderByElement);
        operand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        operand.setFeature((EStructuralFeature)CBEPackage.eINSTANCE.getCBECommonBaseEvent_SequenceNumber());
        orderByElement = ExtensionsFactory.eINSTANCE.createOrderByElement();
        orderByElement.setOperand((Operand)operand);
        orderByElement.setOperator(OrderByOperators.ASC_LITERAL);
        c.add(orderByElement);
        return c;
    }

    private void setInputType() {
        int s = this.agentProxiesList.size();
        TRCAgentProxy proxy = null;
        TRCAgent agent = null;
        int i = 0;
        while (i < s) {
            proxy = (TRCAgentProxy)this.agentProxiesList.get(i);
            agent = (TRCAgent)proxy.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false);
            if (agent != null && EcoreUtil.getURI((EObject)agent).path().endsWith("xmi")) {
                this.isInputXMI = true;
                return;
            }
            ++i;
        }
        if (this.correlationContainerProxy != null && LoadersUtils.getPostfix((URI)EcoreUtil.getURI((EObject)((EObject)this.correlationContainerProxy.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getCorrelationContainerProxy_CorrelationContainer(), false)))).endsWith("corrdb")) {
            this.isInputXMI = false;
            return;
        }
        this.isInputXMI = true;
    }

    public boolean isInputXMI() {
        return this.isInputXMI;
    }

    protected void loadEventsXMI() {
        ArrayList<TRCAgent> agents = new ArrayList<TRCAgent>();
        Iterator iter = this.agentProxiesList.iterator();
        while (iter.hasNext()) {
            TRCAgentProxy element = (TRCAgentProxy)iter.next();
            agents.add(element.getAgent());
        }
        if (!this.isDisplayingOnlyCorrelations()) {
            iter = this.agentProxiesList.iterator();
            while (iter.hasNext()) {
                TRCAgentProxy trcAgentProxy = (TRCAgentProxy)iter.next();
                if (trcAgentProxy == null || trcAgentProxy.eIsProxy()) continue;
                this.addEvents(trcAgentProxy);
            }
            this.eventsList = this.getFilteredLogRecords(agents);
        } else {
            this.loadEventsFromCorrelationsXMI(agents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadEventsFromCorrelationsXMI(List agents) {
        if (this.correlationContainerProxy == null || this.correlationContainerProxy.getCorrelationContainer() == null) {
            return;
        }
        EMap correlations = this.correlationContainerProxy.getCorrelationContainer().getCorrelations();
        boolean sourceInFilter = false;
        boolean targetInFilter = false;
        EObject key = null;
        List filteredEventsList = this.getFilteredLogRecords(agents);
        HashSet filteredEventsSet = new HashSet(filteredEventsList.size());
        filteredEventsSet.addAll(filteredEventsList);
        EMap eMap = correlations;
        synchronized (eMap) {
            int s = 0;
            Object object = null;
            Iterator iter = correlations.keySet().iterator();
            while (iter.hasNext()) {
                key = (EObject)iter.next();
                if (key == null || !(key instanceof CBECommonBaseEvent) || !filteredEventsSet.contains(key)) continue;
                sourceInFilter = true;
                List targetList = (List)correlations.get((Object)key);
                targetInFilter = false;
                if (sourceInFilter && targetList != null && targetList.size() > 0) {
                    s = targetList.size();
                    int i = 0;
                    while (i < s) {
                        object = targetList.get(i);
                        if (object != null && filteredEventsSet.contains(object)) {
                            this.eventsSet.add(object);
                            targetInFilter = true;
                        }
                        ++i;
                    }
                }
                if (!targetInFilter) continue;
                this.eventsSet.add(key);
            }
        }
        if (!this.eventsSet.isEmpty()) {
            this.eventsList.addAll(this.eventsSet);
        }
        Collections.sort(this.eventsList, this.getComparator());
        this.eventsSet.clear();
    }

    protected Comparator getComparator() {
        if (this.comparator == null) {
            this.comparator = new LogRecordComparator();
        }
        return this.comparator;
    }

    protected void generateDiagram(final boolean refresh) {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                LogInteractions.this.generateGraphNodes();
                LogInteractions.this.p = LogInteractions.this.getPerformanceMonitor();
                LogInteractions.this.p.setMessageAndStart("generateGraphConnections");
                if (LogInteractions.this.isInputXMI()) {
                    LogInteractions.this.generateGraphConnectionsXMI();
                } else {
                    LogInteractions.this.generateGraphConnectionsSQL(refresh);
                }
                LogInteractions.this.p.stopAndPrintStatus();
            }
        });
    }

    private void generateGraphConnectionsSQL(boolean refresh) {
        block37: {
            int index;
            int s;
            List currentPageList;
            CBECommonBaseEvent target;
            CBECommonBaseEvent source;
            List valuesList;
            List keysList;
            ResultEntry resultEntry;
            URI correlationContainerURI;
            block36: {
                if (this.correlationContainerProxy == null) {
                    return;
                }
                CorrelationContainer correlationContainer = (CorrelationContainer)this.correlationContainerProxy.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getCorrelationContainerProxy_CorrelationContainer(), false);
                if (correlationContainer == null) {
                    return;
                }
                if (correlationContainer.eResource() != null) {
                    ((InternalEObject)correlationContainer).eSetProxyURI(null);
                }
                correlationContainerURI = EcoreUtil.getURI((EObject)correlationContainer);
                try {
                    if (this.outBoundCorrelations == null || refresh || this.filterChanged) {
                        TimeBasedCorrelationQuery outBoundCorrelationsQuery = (TimeBasedCorrelationQuery)this.getQueryForSQL(this.agentProxiesList, true);
                        outBoundCorrelationsQuery.getOrderByExpresions().clear();
                        outBoundCorrelationsQuery.getOutputElements().clear();
                        SimpleOperand Operand1 = ExtensionsFactory.eINSTANCE.createSimpleOperand();
                        Operand1.setFeature((EStructuralFeature)HierarchyPackage.eINSTANCE.getCorrelationEntry_Key());
                        outBoundCorrelationsQuery.getOutputElements().add((Object)Operand1);
                        SimpleOperand Operand2 = ExtensionsFactory.eINSTANCE.createSimpleOperand();
                        Operand2.setFeature((EStructuralFeature)HierarchyPackage.eINSTANCE.getCorrelationEntry_Value());
                        outBoundCorrelationsQuery.getOutputElements().add((Object)Operand2);
                        if (outBoundCorrelationsQuery instanceof TimeBasedCorrelationQuery) {
                            outBoundCorrelationsQuery.setCorrelationContainerURI(correlationContainerURI.toString());
                        }
                        this.outBoundCorrelations = LogQueryBuilder.executeQuery((Query)outBoundCorrelationsQuery, (ResourceSet)HierarchyResourceSetImpl.getInstance());
                    }
                }
                catch (Exception e) {
                    if (this.debug) {
                        e.printStackTrace();
                    }
                    LogViewsPlugin.log(e);
                }
                resultEntry = null;
                keysList = null;
                valuesList = null;
                source = null;
                target = null;
                currentPageList = this.getCurrentPageEventsList();
                s = currentPageList.size();
                index = -1;
                if (this.outBoundCorrelations != null) {
                    resultEntry = (ResultEntry)this.outBoundCorrelations.getResultEntries().get(0);
                    keysList = (List)resultEntry.getValue();
                    resultEntry = (ResultEntry)this.outBoundCorrelations.getResultEntries().get(1);
                    valuesList = (List)resultEntry.getValue();
                    int i = 0;
                    while (i < s) {
                        source = (CBECommonBaseEvent)currentPageList.get(i);
                        index = keysList.indexOf(source);
                        if (index >= 0) break;
                        ++i;
                    }
                    if (this.debug) {
                        System.out.println("Index outbound = " + index);
                        System.out.println("keysList size = " + keysList.size());
                        System.out.println("keysList size = " + valuesList.size());
                    }
                    i = 0;
                    try {
                        if (index <= -1) break block36;
                        s = keysList.size();
                        i = index;
                        while (i < s) {
                            source = (CBECommonBaseEvent)keysList.get(i);
                            target = (CBECommonBaseEvent)valuesList.get(i);
                            if (this.currentPageEvents.get(source) != null) {
                                if (this.currentPageEvents.get(target) != null) {
                                    if (this.inExpandedList(source) && source != this.thisSelection && target != this.thisSelection) {
                                        this.createDummyMessage(source);
                                    } else {
                                        this.createAsyncMessage(source, target);
                                    }
                                } else if (!this.inExpandedList(source) || source == this.thisSelection) {
                                    this.createTargetOutOfPageMessage(source, target);
                                } else {
                                    this.createDummyMessage(source);
                                }
                                ++i;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        if (this.debug) {
                            e.printStackTrace();
                            System.out.println("outbound i = " + i);
                        }
                        LogViewsPlugin.log(e);
                    }
                }
            }
            try {
                if (this.inboundCorrelations == null || refresh || this.filterChanged) {
                    SimpleSearchQuery inBoundCorrelationsQuery = this.getQueryForSQL(this.agentProxiesList, true);
                    ((TimeBasedCorrelationQuery)inBoundCorrelationsQuery).getOrderByExpresions().clear();
                    inBoundCorrelationsQuery.getOutputElements().clear();
                    SimpleOperand Operand1 = ExtensionsFactory.eINSTANCE.createSimpleOperand();
                    Operand1.setFeature((EStructuralFeature)HierarchyPackage.eINSTANCE.getCorrelationEntry_Value());
                    inBoundCorrelationsQuery.getOutputElements().add((Object)Operand1);
                    SimpleOperand Operand2 = ExtensionsFactory.eINSTANCE.createSimpleOperand();
                    Operand2.setFeature((EStructuralFeature)HierarchyPackage.eINSTANCE.getCorrelationEntry_Key());
                    inBoundCorrelationsQuery.getOutputElements().add((Object)Operand2);
                    if (inBoundCorrelationsQuery instanceof TimeBasedCorrelationQuery) {
                        ((TimeBasedCorrelationQuery)inBoundCorrelationsQuery).setCorrelationContainerURI(correlationContainerURI.toString());
                    }
                    this.inboundCorrelations = LogQueryBuilder.executeQuery((Query)inBoundCorrelationsQuery, (ResourceSet)HierarchyResourceSetImpl.getInstance());
                }
            }
            catch (Exception e) {
                if (this.debug) {
                    e.printStackTrace();
                }
                LogViewsPlugin.log(e);
            }
            if (this.inboundCorrelations == null) {
                return;
            }
            resultEntry = (ResultEntry)this.inboundCorrelations.getResultEntries().get(0);
            valuesList = (List)resultEntry.getValue();
            resultEntry = (ResultEntry)this.inboundCorrelations.getResultEntries().get(1);
            keysList = (List)resultEntry.getValue();
            source = null;
            target = null;
            index = -1;
            s = currentPageList.size();
            int i = 0;
            while (i < s) {
                target = (CBECommonBaseEvent)currentPageList.get(i);
                index = valuesList.indexOf(target);
                if (index >= 0) break;
                ++i;
            }
            if (this.debug) {
                System.out.println("Index inbound = " + index);
                System.out.println("keysList size = " + keysList.size());
                System.out.println("valuesList size = " + valuesList.size());
            }
            i = 0;
            try {
                if (index <= -1) break block37;
                s = valuesList.size();
                i = index;
                while (i < s) {
                    source = (CBECommonBaseEvent)keysList.get(i);
                    target = (CBECommonBaseEvent)valuesList.get(i);
                    if (this.currentPageEvents.get(target) != null) {
                        if (this.currentPageEvents.get(source) == null) {
                            this.createSourceOutOfPageMessage(source, target);
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                if (this.debug) {
                    e.printStackTrace();
                    System.out.println("inbound i = " + i);
                }
                LogViewsPlugin.log(e);
            }
        }
        this.filterChanged = false;
    }

    protected void generateGraphNodes() {
        EObject key = null;
        CBECommonBaseEvent element = null;
        TraceLifeline lifeline = null;
        LogGraphNode node = null;
        LogGraphNode previousNode = null;
        this.p = this.getPerformanceMonitor();
        this.p.setMessageAndStart("generateGraphNodes");
        int k = this.getMaxCurrentPageRangeIndex();
        int startPageIndex = this.currentPageIndex * this.PAGE_SIZE;
        int endPageIndex = this.currentPageIndex * this.PAGE_SIZE + k;
        int i = startPageIndex;
        while (i < endPageIndex) {
            key = (EObject)this.eventsList.get(i);
            element = (CBECommonBaseEvent)key;
            lifeline = (TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(element)));
            if (this.graphNodes.get(element) == null) {
                node = this.createLogGraphNode(lifeline, element, previousNode);
                this.cacheLogGraphNode(node, element);
                previousNode = node;
            }
            ++i;
        }
        this.p.stopAndPrintStatus();
    }

    protected Object getLifelinesMapKey(CBECommonBaseEvent element) {
        return element.getAgent().getAgentProxy();
    }

    protected void cacheLogGraphNode(LogGraphNode node, CBECommonBaseEvent element) {
        this.graphNodes.put(element, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateGraphConnectionsXMI() {
        if (this.correlationContainerProxy == null) {
            return;
        }
        CBECommonBaseEvent source = null;
        List targetList = null;
        EObject key = null;
        if (this.correlationContainerProxy == null || this.correlationContainerProxy.getCorrelationContainer() == null) {
            return;
        }
        EMap correlations = this.correlationContainerProxy.getCorrelationContainer().getCorrelations();
        ArrayList<TRCAgent> agents = new ArrayList<TRCAgent>();
        int sa = this.agentProxiesList.size();
        int j = 0;
        while (j < sa) {
            TRCAgentProxy element = (TRCAgentProxy)this.agentProxiesList.get(j);
            agents.add(element.getAgent());
            ++j;
        }
        List filteredEventsList = this.getFilteredLogRecords(agents);
        HashSet filteredEventsSet = new HashSet(filteredEventsList.size());
        filteredEventsSet.addAll(filteredEventsList);
        EMap eMap = correlations;
        synchronized (eMap) {
            Object object = null;
            Iterator iter = correlations.keySet().iterator();
            while (iter.hasNext()) {
                key = (EObject)iter.next();
                if (key == null || !(key instanceof CBECommonBaseEvent) || !filteredEventsSet.contains(key)) continue;
                source = (CBECommonBaseEvent)key;
                targetList = (List)correlations.get((Object)key);
                if (targetList == null) continue;
                int s = targetList.size();
                int i = 0;
                while (i < s) {
                    object = targetList.get(i);
                    if (object != null && object instanceof CBECommonBaseEvent && filteredEventsSet.contains(object)) {
                        CBECommonBaseEvent target = object;
                        if (this.currentPageEvents.get(source) == null) {
                            if (this.currentPageEvents.get(target) != null) {
                                this.createSourceOutOfPageMessage(source, target);
                            }
                        } else if (this.currentPageEvents.get(target) != null) {
                            if (this.inExpandedList(source) && source != this.thisSelection && target != this.thisSelection) {
                                this.createDummyMessage(source);
                            } else {
                                this.createAsyncMessage(source, target);
                            }
                        } else if (!this.inExpandedList(source) || source == this.thisSelection) {
                            this.createTargetOutOfPageMessage(source, target);
                        } else {
                            this.createDummyMessage(source);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private LogAsyncReturnMessage createDummyMessage(CBECommonBaseEvent source) {
        LogAsyncReturnMessage message = this.getDummyMessage(source);
        if (message != null) {
            return message;
        }
        message = this.isInputXMI ? new LogAsyncReturnMessage(0) : new LogAsyncReturnMessage(1);
        message.setStartLifeline((TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(source))));
        message.setSource(source);
        message.setStartOccurrence(((LogGraphNode)((Object)this.graphNodes.get(source))).getStartOccurrence());
        this.frame.addMessage((BaseMessage)message);
        this.dummyMessages.put(source, message);
        return message;
    }

    private SourceOutOfPageMessage createSourceOutOfPageMessage(CBECommonBaseEvent source, CBECommonBaseEvent target) {
        SourceOutOfPageMessage message = this.getSourceMessage(target);
        ArrayList<Object> sources = null;
        if (message == null) {
            sources = new ArrayList<Object>();
            sources.add(source);
            message = new SourceOutOfPageMessage();
            message.setEndLifeline((TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(target))));
            LogGraphNode targetNode = (LogGraphNode)((Object)this.graphNodes.get(target));
            message.setEndOccurrence(targetNode.getEndOccurrence());
            message.setSource(sources);
            this.sourceOutOfPageMessages.put(target, message);
        } else {
            sources = message.getSource();
            sources.add(source);
            int s = sources.size();
            int i = 0;
            while (i < s - 1) {
                int j = i;
                while (j < s) {
                    CBECommonBaseEvent tempCBE = null;
                    if (this.eventsList.indexOf(sources.get(i)) > this.eventsList.indexOf(sources.get(j))) {
                        tempCBE = (CBECommonBaseEvent)sources.get(i);
                        sources.set(i, sources.get(j));
                        sources.set(j, tempCBE);
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.frame.addMessage((BaseMessage)message);
        return message;
    }

    protected LogInteractionsFrame createPage(boolean refresh) {
        if (this.pageCache == null) {
            this.pageCache = this.pageCache = new Object[1];
        }
        if (this.currentPageIndex > this.pageCache.length - 1 || refresh) {
            this.frame = new LogInteractionsFrame();
        } else {
            LogInteractionsFrame currentFrame = (LogInteractionsFrame)((Object)this.pageCache[this.currentPageIndex]);
            if (currentFrame != null) {
                this.frame = currentFrame;
                this.cacheGraphNodes();
                this.cacheCurrentPageEvents();
                return this.frame;
            }
            this.frame = new LogInteractionsFrame();
        }
        this.frame.setLifelineCategories(traceCategories);
        this.frame.forceEventOccurrenceSpacing(24);
        this.clearTemporaryCaches();
        this.generateLifelines();
        this.cacheCurrentPageEvents();
        this.frame.setName(this.getFrameTitle());
        this.generateDiagram(false);
        this.pageCache[this.currentPageIndex] = this.frame;
        return this.frame;
    }

    private void cacheCurrentPageEvents() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                LogInteractions.this.currentPageEvents.clear();
                int k = LogInteractions.this.getMaxCurrentPageRangeIndex();
                int startPageIndex = LogInteractions.this.currentPageIndex * LogInteractions.this.PAGE_SIZE;
                int endPageIndex = LogInteractions.this.currentPageIndex * LogInteractions.this.PAGE_SIZE + k;
                if (endPageIndex > LogInteractions.this.eventsList.size()) {
                    LogInteractions.this.currentPageIndex = 0;
                    k = LogInteractions.this.getMaxCurrentPageRangeIndex();
                    startPageIndex = 0;
                    endPageIndex = k;
                }
                int i = startPageIndex;
                while (i < endPageIndex) {
                    EObject element = (EObject)LogInteractions.this.eventsList.get(i);
                    if (element instanceof CBECommonBaseEvent) {
                        LogInteractions.this.currentPageEvents.put(element, "");
                    }
                    ++i;
                }
            }
        });
    }

    protected String getFrameTitle() {
        return LogViewsPlugin.getString("12");
    }

    protected void generateLifelines() {
        boolean hideLogType = UIPlugin.getDefault().getPreferenceStore().getBoolean("hyde_logtype");
        Iterator iter = this.getLifelineArtifactsList().iterator();
        while (iter.hasNext()) {
            TraceLifeline lifeLine = new TraceLifeline();
            TRCAgentProxy agent = (TRCAgentProxy)iter.next();
            String aname = agent.getName();
            if (hideLogType) {
                lifeLine.setName(HyadesUtil.resolveLogAgentDisplayName((String)aname));
            } else {
                StringBuffer buffer = new StringBuffer(HyadesUtil.resolveLogAgentType((String)aname));
                buffer.append(" ").append(HyadesUtil.resolveLogAgentDisplayName((String)aname));
                lifeLine.setName(buffer.toString());
            }
            lifeLine.setCategory(0);
            this.lifelinesMap.put(agent, lifeLine);
            this.frame.addLifeLine(lifeLine);
        }
    }

    protected List getLifelineArtifactsList() {
        return this.agentProxiesList;
    }

    private int getMaxCurrentPageRangeIndex() {
        if (this.PAGE_SIZE == 0) {
            this.PAGE_SIZE = (int)LogViewsPlugin.getDefault().getPreferenceStore().getLong("page_size");
            if (this.PAGE_SIZE == 0) {
                this.PAGE_SIZE = 500;
            }
        }
        int r = this.totalSize % this.PAGE_SIZE;
        if (this.totalSize == 0) {
            return 0;
        }
        if (this.currentPageIndex + 1 < this.nrOfPages) {
            return this.PAGE_SIZE;
        }
        if (r == 0) {
            return this.PAGE_SIZE;
        }
        return r;
    }

    protected LogGraphNode createLogGraphNode(TraceLifeline lifeline, CBECommonBaseEvent object, LogGraphNode previousNode) {
        LogGraphNode node = null;
        LogHotSpot hotSpotNode = null;
        if (previousNode != null) {
            if (((LogRecordComparator)this.getComparator()).compareByTime(object, previousNode.getElement()) == 1) {
                node = new LogGraphNode((EObject)object);
                lifeline.setCurrentEventOccurrence(this.frame.getMaxEventOccurrence());
                node.setStartOccurrence(lifeline.getNewEventOccurrence());
                node.setEndOccurrence(lifeline.getNewEventOccurrence());
                node.setName(object.getMsg());
                lifeline.addExecution((BasicExecutionOccurrence)node);
                node.setStartTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
                node.setEndTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
            } else if ((TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey((CBECommonBaseEvent)previousNode.getElement()))) == lifeline) {
                if (!this.inExpandedList(object)) {
                    previousNode.addElement((EObject)object);
                    if (previousNode.getHotSpot() == null) {
                        hotSpotNode = new LogHotSpot();
                        hotSpotNode.setImage(SDLogcPluginImages.getImage("plus_obj.gif"));
                        hotSpotNode.setExecution((BasicExecutionOccurrence)previousNode);
                    }
                    node = previousNode;
                    node.setName(NLS.bind((String)LogViewsMessages._81, (Object)("" + node.getElements().size())));
                    node.setEndTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
                } else {
                    node = new LogGraphNode((EObject)object);
                    node.setStartOccurrence(previousNode.getEndOccurrence());
                    lifeline.setCurrentEventOccurrence(previousNode.getEndOccurrence());
                    node.setEndOccurrence(lifeline.getNewEventOccurrence());
                    node.setExpanded(true);
                    node.setName(object.getMsg());
                    lifeline.addExecution((BasicExecutionOccurrence)node);
                    LogGraphNode parentNode = this.getParentNode(object);
                    parentNode.addElement((EObject)object);
                    parentNode.setExpanded(true);
                    parentNode.setBackgroundColor();
                    if (parentNode.getHotSpot() == null) {
                        hotSpotNode = new LogHotSpot();
                        hotSpotNode.setImage(SDLogcPluginImages.getImage("minus_obj.gif"));
                        hotSpotNode.setExecution((BasicExecutionOccurrence)parentNode);
                    }
                    node.setStartTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
                    node.setEndTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
                }
            } else {
                List executions = lifeline.getExecutions();
                if (executions != null && executions.size() > 0) {
                    LogGraphNode lastGraphNode = (LogGraphNode)((Object)executions.get(executions.size() - 1));
                    if (lastGraphNode != null) {
                        if (((LogRecordComparator)this.getComparator()).compareByTime(object, lastGraphNode.getElement()) == 1) {
                            node = new LogGraphNode((EObject)object);
                            node.setStartOccurrence(previousNode.getStartOccurrence());
                            node.setEndOccurrence(previousNode.getEndOccurrence());
                            node.setName(object.getMsg());
                            lifeline.addExecution((BasicExecutionOccurrence)node);
                            node.setStartTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
                            node.setEndTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
                        } else if (!this.inExpandedList(object)) {
                            lastGraphNode.addElement((EObject)object);
                            if (lastGraphNode.getHotSpot() == null) {
                                hotSpotNode = new LogHotSpot();
                                hotSpotNode.setImage(SDLogcPluginImages.getImage("plus_obj.gif"));
                                hotSpotNode.setExecution((BasicExecutionOccurrence)lastGraphNode);
                            }
                            node = lastGraphNode;
                            node.setName(NLS.bind((String)LogViewsMessages._81, (Object)("" + node.getElements().size())));
                            node.setEndTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
                        } else {
                            node = new LogGraphNode((EObject)object);
                            node.setStartOccurrence(lastGraphNode.getEndOccurrence());
                            lifeline.setCurrentEventOccurrence(lastGraphNode.getEndOccurrence());
                            node.setEndOccurrence(lifeline.getNewEventOccurrence());
                            node.setName(object.getMsg());
                            node.setExpanded(true);
                            lifeline.addExecution((BasicExecutionOccurrence)node);
                            LogGraphNode parentNode = this.getParentNode(object);
                            parentNode.addElement((EObject)object);
                            parentNode.setExpanded(true);
                            parentNode.setBackgroundColor();
                            if (parentNode.getHotSpot() == null) {
                                hotSpotNode = new LogHotSpot();
                                hotSpotNode.setImage(SDLogcPluginImages.getImage("minus_obj.gif"));
                                hotSpotNode.setExecution((BasicExecutionOccurrence)lastGraphNode);
                            }
                            node.setStartTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
                            node.setEndTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
                        }
                    }
                } else {
                    node = new LogGraphNode((EObject)object);
                    node.setStartOccurrence(previousNode.getStartOccurrence());
                    node.setEndOccurrence(previousNode.getEndOccurrence());
                    node.setName(object.getMsg());
                    lifeline.addExecution((BasicExecutionOccurrence)node);
                    node.setStartTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
                    node.setEndTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
                }
            }
        } else {
            node = new LogGraphNode((EObject)object);
            node.setStartOccurrence(lifeline.getNewEventOccurrence());
            node.setEndOccurrence(lifeline.getNewEventOccurrence());
            node.setName(object.getMsg());
            lifeline.addExecution((BasicExecutionOccurrence)node);
            node.setStartTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
            node.setEndTime(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)object) / 1000000.0);
        }
        node.setBackgroundColor();
        return node;
    }

    private AsyncMessage createAsyncMessage(CBECommonBaseEvent source, CBECommonBaseEvent target) {
        TraceLifeline sourceLifeline = (TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(source)));
        TraceLifeline targetLifeline = (TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(target)));
        LogGraphNode sourceNode = (LogGraphNode)((Object)this.graphNodes.get(source));
        LogGraphNode targetNode = (LogGraphNode)((Object)this.graphNodes.get(target));
        LogAsyncMessage message = null;
        message = this.isInputXMI ? new LogAsyncMessage(0) : new LogAsyncMessage(1);
        message.setStartLifeline(sourceLifeline);
        message.setEndLifeline(targetLifeline);
        message.setStartOccurrence(sourceNode.getStartOccurrence());
        message.setEndOccurrence(targetNode.getStartOccurrence());
        message.setSourceNode(sourceNode);
        message.setTargetNode(targetNode);
        this.frame.addMessage((BaseMessage)message);
        return message;
    }

    private TargetOutOfPageMessage createTargetOutOfPageMessage(CBECommonBaseEvent source, CBECommonBaseEvent target) {
        TraceLifeline sourceLifeline = (TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(source)));
        LogGraphNode sourceNode = (LogGraphNode)((Object)this.graphNodes.get(source));
        ArrayList<CBECommonBaseEvent> targets = null;
        TargetOutOfPageMessage message = this.getTargetMessage(source);
        if (message == null) {
            targets = new ArrayList<CBECommonBaseEvent>();
            targets.add(target);
            message = new TargetOutOfPageMessage();
            message.setStartLifeline(sourceLifeline);
            message.setStartOccurrence(sourceNode.getEndOccurrence());
            message.setTarget(targets);
            this.targetOutOfPageMessages.put(source, message);
            this.frame.addMessage((BaseMessage)message);
        } else {
            targets = message.getTarget();
            targets.add(target);
        }
        return message;
    }

    protected void addEvents(TRCAgentProxy trcAgentProxy) {
        EList defaultEvents = trcAgentProxy.getAgent().getDefaultEvents();
        int s = defaultEvents.size();
        Object object = null;
        int i = 0;
        while (i < s) {
            object = defaultEvents.get(i);
            if (object != null && object instanceof CBECommonBaseEvent) {
                this.eventsList.add(object);
            }
            ++i;
        }
    }

    protected void cacheGraphNodes() {
        this.graphNodes.clear();
        TraceLifeline lifeline = null;
        int i = 0;
        while (i < this.frame.getLifelines().size()) {
            lifeline = (TraceLifeline)((Object)this.frame.getLifelines().get(i));
            int k = 0;
            while (k < lifeline.getExecutions().size()) {
                LogGraphNode graphNode = (LogGraphNode)((Object)lifeline.getExecutions().get(k));
                if (graphNode != null) {
                    if (graphNode.hasElements()) {
                        int j = 0;
                        while (j < graphNode.getElements().size()) {
                            this.graphNodes.put(graphNode.getElements().get(j), graphNode);
                            ++j;
                        }
                    } else {
                        this.graphNodes.put(graphNode.getElement(), graphNode);
                    }
                }
                ++k;
            }
            ++i;
        }
    }

    public Object getInput() {
        return this.inputObject;
    }

    public LogGraphNode getGraphNodeFromArtifact(CBECommonBaseEvent artifact) {
        LogGraphNode source = null;
        source = (LogGraphNode)((Object)this.graphNodes.get(artifact));
        return source;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.selectionChangedByLoader) {
            return;
        }
        if (part instanceof INavigator && !((INavigator)part).isLinkingEnabled()) {
            return;
        }
        if (this.view != null && this.view.getSDWidget() != null && !this.view.getSDWidget().isDisposed()) {
            EObject sel = HyadesUtil.getMofObject();
            this.searchDialog = LogUtil.getSearchDialog();
            if (sel != null && this.searchDialog != null) {
                this.searchDialog.setFindProvider(this);
                this.logRecordSearch = null;
            }
            if (sel != null && sel != this.inputObject) {
                this.viewOption = -1;
                this.view.setFrame((Frame)this.parseModel(sel));
                this.disableMessageActions();
                Object viewSel = UIPlugin.getDefault().getSelectionModel(HyadesUtil.getMofObject()).getFirstElement();
                if (viewSel != null && viewSel instanceof CBECommonBaseEvent) {
                    this.setSelection((CBECommonBaseEvent)viewSel);
                }
            } else if (sel == null) {
                this.viewOption = -1;
                this.inputObject = sel;
                this.view.setFrame(new Frame());
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent e) {
        if (e.getSelection() == null || ((IStructuredSelection)e.getSelection()).size() == 0) {
            return;
        }
        Object sel = ((IStructuredSelection)e.getSelection()).getFirstElement();
        if (sel instanceof LogGraphNode) {
            if (this.view.getSDWidget().getViewControl().isVisible()) {
                if (this.view.getSDWidget().getViewControl().isFocusControl()) {
                    CBECommonBaseEvent lastSelection = this.currentSelection;
                    this.thisSelection = (CBECommonBaseEvent)((LogGraphNode)((Object)sel)).getElement();
                    if (this.thisSelection != lastSelection && (this.inExpandedList(this.thisSelection) || this.inExpandedList(lastSelection))) {
                        this.revealGraphConnections(this.thisSelection);
                        return;
                    }
                    this.currentSelection = (CBECommonBaseEvent)((LogGraphNode)((Object)sel)).getElement();
                }
                if (this.view.getSDWidget().getViewControl().isFocusControl() || this._findRecordSelection) {
                    LogUtil.notifyViewSelectionChanged(this, this.inputObject, this.currentSelection);
                }
            }
        } else if (sel instanceof LogHotSpot) {
            LogGraphNode node = (LogGraphNode)((LogHotSpot)((Object)sel)).getExecOcc();
            ArrayList<LogGraphNode> nodes = new ArrayList<LogGraphNode>(1);
            nodes.add(node);
            if (this.inExpandedList((CBECommonBaseEvent)node.getElement())) {
                this.collapseLogGraphNode(nodes);
            } else {
                this.expandLogGraphNode(nodes);
            }
        }
    }

    public boolean isDisplayingOnlyCorrelations() {
        return this._filterQueryProvider.getCurrentFilter() instanceof TimeBasedCorrelationQuery;
    }

    public boolean isLifelineSupported() {
        return true;
    }

    public boolean isSyncMessageSupported() {
        return true;
    }

    public boolean isSyncMessageReturnSupported() {
        return true;
    }

    public boolean isAsyncMessageSupported() {
        return true;
    }

    public boolean isAsyncMessageReturnSupported() {
        return false;
    }

    public boolean isStopSupported() {
        return false;
    }

    public boolean hasNextPage() {
        return this.currentPageIndex + 1 < this.nrOfPages;
    }

    public boolean hasPrevPage() {
        return this.currentPageIndex > 0;
    }

    public void nextPage() {
        if (this.currentPageIndex + 1 < this.nrOfPages) {
            ++this.currentPageIndex;
            this.view.setFrame((Frame)this.createPage(false));
            this.disableMessageActions();
        }
    }

    public void prevPage() {
        if (this.currentPageIndex > 0) {
            --this.currentPageIndex;
            this.view.setFrame((Frame)this.createPage(false));
            this.disableMessageActions();
        }
    }

    protected void createPartition() {
        this.totalSize = this.eventsList.size();
        this.PAGE_SIZE = (int)LogViewsPlugin.getDefault().getPreferenceStore().getLong("page_size");
        this.nrOfPages = this.totalSize % this.PAGE_SIZE > 0 ? this.totalSize / this.PAGE_SIZE + 1 : this.totalSize / this.PAGE_SIZE;
        this.pageCache = this.nrOfPages == 0 ? new Object[1] : new Object[this.nrOfPages];
    }

    public String getTitleString() {
        StringBuffer title = new StringBuffer();
        title.append(LogViewsMessages._90);
        title.append(": ");
        title.append(LogViewsPlugin.getString("12"));
        title.append(" ");
        if (this.correlationContainerProxy != null) {
            title.append("<");
            title.append(this.correlationContainerProxy.getCorrelationEngine().getName());
            title.append(">   ");
        } else {
            title.append("   ");
        }
        title.append("(");
        title.append(this.getFrameName());
        title.append(")");
        return title.toString();
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
        Object sel;
        Object source = event.getSource();
        if (source != this && (sel = UIPlugin.getDefault().getSelectionModel(this.inputObject).getFirstElement()) instanceof CBECommonBaseEvent) {
            this.setSelection((CBECommonBaseEvent)sel);
        }
    }

    private void showCorrelationDialog() {
        LogCorrelationSelectionDialog logCorrelationSelectionDialog = new LogCorrelationSelectionDialog(null, CorrelationHelper.getInstance().getCorrelationExtensions());
        logCorrelationSelectionDialog.open();
        if (logCorrelationSelectionDialog.getReturnCode() == 0) {
            this.setCorrelationType(logCorrelationSelectionDialog.getSelectedCorrelation());
            TRCAgentProxy[] logAgentsArray = this.agentProxiesList.toArray(new TRCAgentProxy[this.agentProxiesList.size()]);
            this.correlationContainerProxy = CorrelationHelper.getInstance().createCorrelationContainer(this.correlationType, (Object)logAgentsArray, this.correlationType.getAttribute("name"));
            this.inputObject = this.correlationContainerProxy;
            this.selectionChangedByLoader = true;
            LogUtil.selectInLogNavigator((EObject)this.correlationContainerProxy, this);
        }
    }

    public void setSelection(CBECommonBaseEvent sel) {
        if (this.view == null || this.view.getSDWidget().isDisposed()) {
            return;
        }
        this.view.getSDWidget().clearSelection();
        if (this.eventsList != null) {
            int i = this.eventsList.indexOf(sel);
            int pageIndex = 0;
            if (i > -1) {
                pageIndex = i / this.PAGE_SIZE;
            }
            this.goToPage(pageIndex);
            LogGraphNode node = this.getGraphNodeFromArtifact(sel);
            CBECommonBaseEvent lastSelection = this.currentSelection;
            this.thisSelection = sel;
            if (this.thisSelection != lastSelection && (this.inExpandedList(this.thisSelection) || this.inExpandedList(lastSelection))) {
                this.revealGraphConnections(this.thisSelection);
            } else {
                this.currentSelection = sel;
                this.view.getSDWidget().ensureVisible((GraphNode)node);
                this.disableMessageActions();
                this.view.getSDWidget().addSelection((GraphNode)node);
            }
        }
    }

    private void goToPage(int page) {
        this.currentPageIndex = page;
        this.view.setFrame((Frame)this.createPage(false));
        this.disableMessageActions();
        this.view.updateCoolBar();
    }

    public IConfigurationElement getCorrelationType() {
        return this.correlationType;
    }

    public void setCorrelationType(IConfigurationElement element) {
        this.correlationType = element;
    }

    public Action getFilterAction() {
        return (Action)FilterActions.getFiltersSelectionAction((IFilterViewer)this);
    }

    public void filter() {
        FiltersDialog dialog = new FiltersDialog(this.view.getViewSite().getShell(), LogViewsMessages._139, null, this, true);
        dialog.open();
    }

    public Action getFindAction() {
        String STR_FIND_RECORD = LogViewsMessages._127;
        Action searchRecord = new Action(STR_FIND_RECORD){

            public void run() {
                LogInteractions.this.find();
            }
        };
        searchRecord.setText(STR_FIND_RECORD);
        searchRecord.setDescription(STR_FIND_RECORD);
        searchRecord.setToolTipText(STR_FIND_RECORD);
        return searchRecord;
    }

    public void find() {
        this.searchDialog = LogUtil.getSearchDialog(this.view.getViewSite().getShell(), LogViewsMessages._128, null, this);
        this.initializeRecordSearchEngine();
        this.searchDialog.open();
        LogUtil.setSearchDialog(null);
    }

    public boolean filterRecord(ILogFilterCriteria criteria) {
        this.filterTableElements = criteria.getFilters();
        this.filterChanged = true;
        this.generateLogInteractions(this.inputObject, false);
        return true;
    }

    public boolean findRecord(LogFindCriteria criteria) {
        Object sel = null;
        LogRecordSearch searchUtil = this.getRecordSearchEngine();
        if (this.isInputXMI) {
            searchUtil.initStartNode(this.currentSelection, 0, criteria.isForwardDirection());
            sel = searchUtil.search(criteria.getFilters(), criteria.isForwardDirection() ? 1 : -1, this.currentSelection);
        } else {
            searchUtil.initStartNode(this.currentSelection, 1, criteria.isForwardDirection());
            sel = searchUtil.search(this.query, criteria);
        }
        this.selectFindRecord(sel);
        return true;
    }

    public ILogFilterCriteria getFilterCriteria() {
        int s = 0;
        if (this.criteria == null) {
            this.criteria = new LogFilterCriteria();
        }
        if (this.filterTableElements != null) {
            int analyzedFilterIndex = -1;
            s = this.filterTableElements.length;
            int i = 0;
            while (i < s) {
                if (this.filterTableElements[i].getAttribute().equals("analyzed")) {
                    analyzedFilterIndex = i;
                    break;
                }
                ++i;
            }
            if (analyzedFilterIndex > -1) {
                if (s > 1) {
                    IFilterElement[] filter = new FilterTableElement[s - 1];
                    int index = 0;
                    int i2 = 0;
                    while (i2 < s) {
                        if (i2 != analyzedFilterIndex) {
                            filter[index++] = this.filterTableElements[i2];
                        }
                        ++i2;
                    }
                    this.criteria.setFilters(filter);
                } else {
                    this.criteria.setFilters(new IFilterElement[0]);
                }
            } else {
                this.criteria.setFilters(this.filterTableElements);
            }
        } else {
            this.criteria.setFilters(new IFilterElement[0]);
        }
        this.criteria.setSortColumns(new ISortElement[]{new SortElement(CBEPackage.eINSTANCE.getCBECommonBaseEvent_CreationTime().getName(), true), new SortElement(CBEPackage.eINSTANCE.getCBECommonBaseEvent_SequenceNumber().getName(), true)});
        return this.criteria;
    }

    public LogRecordSearch getRecordSearchEngine() {
        if (this.logRecordSearch == null) {
            this.logRecordSearch = new LogRecordSearch();
            this.initializeRecordSearchEngine();
        }
        return this.logRecordSearch;
    }

    private void initializeRecordSearchEngine() {
        Object start = this.getStartNode();
        if (this.logRecordSearch == null) {
            this.logRecordSearch = new LogRecordSearch();
        }
        if (this.isInputXMI) {
            this.logRecordSearch.initialize(this.eventsList, start, 0);
        } else {
            this.logRecordSearch.initialize(this.eventsList, start, 1);
        }
    }

    private Object getStartNode() {
        if (this.view != null && !this.view.getSDWidget().isDisposed() && this.view.getSDWidget().getSelection().size() > 0) {
            LogGraphNode node = (LogGraphNode)((Object)this.view.getSDWidget().getSelection().get(0));
            if (node.getElements() != null && node.getElements().size() > 0) {
                return node.getElements().get(0);
            }
            return node.getElement();
        }
        return null;
    }

    private void selectFindRecord(Object sel) {
        if (sel == null && this.searchDialog != null) {
            this.searchDialog.updateMessage(LogViewsMessages._135);
            return;
        }
        this._findRecordSelection = true;
        this.setSelection((CBECommonBaseEvent)sel);
        this._findRecordSelection = false;
    }

    public boolean storeFindOptions(LogFindCriteria criteria) {
        FilterTableElement.saveFilters(criteria.getFilters(), "uml2sd_extend_find_options", LogViewsPlugin.getDefault().getPreferenceStore());
        LogViewsPlugin.getDefault().getPreferenceStore().setValue("uml2sd_extend_find_direction_options", criteria.isForwardDirection() ? "1" : "-1");
        return true;
    }

    public String loadFindPreferenceString() {
        IPreferenceStore store = LogViewsPlugin.getDefault().getPreferenceStore();
        return store.getString("uml2sd_extend_find_options");
    }

    public boolean loadFindDirection() {
        return LogViewsPlugin.getDefault().getPreferenceStore().getString("uml2sd_extend_find_direction_options").equals("1");
    }

    private SourceOutOfPageMessage getSourceMessage(CBECommonBaseEvent event) {
        if (this.sourceOutOfPageMessages == null) {
            this.sourceOutOfPageMessages = new HashMap();
        }
        return (SourceOutOfPageMessage)((Object)this.sourceOutOfPageMessages.get(event));
    }

    private TargetOutOfPageMessage getTargetMessage(CBECommonBaseEvent event) {
        if (this.targetOutOfPageMessages == null) {
            this.targetOutOfPageMessages = new HashMap();
        }
        return (TargetOutOfPageMessage)((Object)this.targetOutOfPageMessages.get(event));
    }

    private LogAsyncReturnMessage getDummyMessage(CBECommonBaseEvent event) {
        if (this.dummyMessages == null) {
            this.dummyMessages = new HashMap();
        }
        return (LogAsyncReturnMessage)((Object)this.dummyMessages.get(event));
    }

    public void handleProfileEvent(ProfileEvent event) {
        if (event.getType() == 64) {
            if (this.isRecorrelationNeeded(event.getSource()) && !CorrelationHelper.getInstance().isCorrelationUpdated((CorrelationContainerProxy)event.getSource())) {
                CorrelationHelper.getInstance().recorrelate(this.correlationContainerProxy);
            }
            this.refresh();
        } else if (event.getType() == 4608) {
            this.refresh();
        } else if (event.getType() == 4096) {
            this.inputObject = null;
            this.refresh();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isRecorrelationNeeded(Object source) {
        if (source == null) {
            return false;
        }
        if (source != this.inputObject || !(this.inputObject instanceof CorrelationContainerProxy)) return false;
        EList list = ((CorrelationContainerProxy)source).getCorrelatedAgents();
        int s = list.size();
        TRCAgentProxy element = null;
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        String prefString = store.getString(((CorrelationContainerProxy)source).eResource().getURI().toString());
        if (prefString == null) return false;
        if (prefString.trim().length() == 0) {
            return false;
        }
        int j = 0;
        int k = 0;
        int isXMI = 0;
        k = prefString.indexOf(59);
        if (k < -1 && s > 1) {
            return true;
        }
        String state = "";
        int i = 0;
        while (i < s) {
            element = (TRCAgentProxy)list.get(i);
            state = k > -1 ? prefString.substring(j, k) : prefString.substring(j);
            isXMI = this.isAgentProxyXMI(element);
            if (isXMI == 0) {
                return true;
            }
            String actualGIID = "";
            if (isXMI > 0) {
                TRCAgent agent = (TRCAgent)element.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false);
                EList cbeList = agent.getDefaultEvents();
                int size = cbeList.size();
                if (size <= 0) return true;
                actualGIID = ((CBECommonBaseEvent)cbeList.get(size - 1)).getGlobalInstanceId();
                if (!actualGIID.equals(state)) {
                    return true;
                }
            } else {
                SimpleSearchQuery count = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
                this.query.setCount(true);
                SimpleOperand Operand2 = ExtensionsFactory.eINSTANCE.createSimpleOperand();
                Operand2.setType(CBEPackage.eINSTANCE.getCBECommonBaseEvent());
                count.getOutputElements().add((Object)Operand2);
                TRCAgent agent = (TRCAgent)element.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false);
                if (agent != null) {
                    List countList;
                    String uri = EcoreUtil.getURI((EObject)agent).toString();
                    this.query.getSources().add((Object)uri);
                    QueryResult queryResult = LogQueryBuilder.executeQuery((Query)this.query, (ResourceSet)HierarchyResourceSetImpl.getInstance());
                    if (queryResult == null) {
                        return true;
                    }
                    ResultEntry resultEntry = null;
                    if (queryResult.getResultEntries().size() > 0 && (countList = (List)(resultEntry = (ResultEntry)queryResult.getResultEntries().get(0)).getValue()).size() > 0) {
                        int size = (Integer)countList.get(0);
                        if (size <= 0) return true;
                        this.query.setCount(false);
                        queryResult = LogQueryBuilder.executeQuery((Query)this.query, (ResourceSet)HierarchyResourceSetImpl.getInstance());
                        if (queryResult == null) {
                            return true;
                        }
                        resultEntry = null;
                        if (queryResult.getResultEntries().size() <= 0) return true;
                        resultEntry = (ResultEntry)queryResult.getResultEntries().get(0);
                        List cbeList = (List)resultEntry.getValue();
                        actualGIID = ((CBECommonBaseEvent)cbeList.get(size - 1)).getGlobalInstanceId();
                        if (!actualGIID.equals(state)) {
                            return true;
                        }
                    }
                }
            }
            j = k + 1;
            k = prefString.indexOf(59, j);
            ++i;
        }
        return false;
    }

    private int isAgentProxyXMI(TRCAgentProxy agentProxy) {
        TRCAgent agent = (TRCAgent)agentProxy.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false);
        if (agent == null) {
            return 0;
        }
        if (EcoreUtil.getURI((EObject)agent).path().endsWith("xmi")) {
            return 1;
        }
        return -1;
    }

    public int currentPage() {
        if (this.nrOfPages == 0) {
            return -1;
        }
        return this.currentPageIndex;
    }

    public String itemsText() {
        return LogViewsMessages._78;
    }

    public int itemsTotalCount() {
        return this.eventsList.size();
    }

    public int maxItemsByPageCount() {
        return this.PAGE_SIZE;
    }

    public String noItemsText() {
        return LogViewsMessages._78;
    }

    public String oneItemText() {
        return LogViewsMessages._79;
    }

    public int pagesCount() {
        return this.nrOfPages;
    }

    public void pageSettingsChanged(int maxItemsByPage_, int pageNumber_) {
        if (pageNumber_ >= 0 && pageNumber_ < this.nrOfPages) {
            this.goToPage(pageNumber_);
        }
        if (maxItemsByPage_ > this.MAX_NR_OF_RECORDS) {
            maxItemsByPage_ = this.MAX_NR_OF_RECORDS;
        }
        if (this.PAGE_SIZE != maxItemsByPage_) {
            LogViewsPlugin.getDefault().getPreferenceStore().setValue("page_size", maxItemsByPage_);
            this.PAGE_SIZE = maxItemsByPage_;
        }
    }

    public void pageNumberChanged(int pageNumber_) {
        this.goToPage(pageNumber_);
    }

    public CorrelationContainerProxy getCorrelationContainerProxy() {
        return this.correlationContainerProxy;
    }

    public String getFrameName() {
        return NLS.bind((String)LogViewsMessages._80, (Object[])new String[]{String.valueOf(this.currentPage() + 1), String.valueOf(this.nrOfPages)});
    }

    public void applyPreferences() {
        this.view.setFrame((Frame)this.parseModel(this.inputObject));
        this.disableMessageActions();
    }

    public void preserveSelection(CBECommonBaseEvent selection) {
        if (selection == null) {
            return;
        }
        this.view.getSDWidget().clearSelection();
        LogGraphNode selNode = (LogGraphNode)((Object)this.graphNodes.get(selection));
        if (selNode != null) {
            this.currentSelection = selection;
            this.disableMessageActions();
            this.view.getSDWidget().ensureVisible((GraphNode)selNode);
            this.view.getSDWidget().addSelection((GraphNode)selNode);
        }
    }

    public void collapseLogGraphNode(List graphNodes) {
        LogGraphNode node = null;
        int i = 0;
        while (i < graphNodes.size()) {
            node = (LogGraphNode)((Object)graphNodes.get(i));
            this.removeFromExpandedList(node);
            ++i;
        }
        node = (LogGraphNode)((Object)graphNodes.get(0));
        CBECommonBaseEvent sel = (CBECommonBaseEvent)node.getElement();
        this.pageCache[this.currentPageIndex] = null;
        int x = this.view.getSDWidget().getContentsX();
        int y = this.view.getSDWidget().getContentsY();
        this.view.setFrameAndEnsureVisible((Frame)this.createPage(false), x, y);
        this.disableMessageActions();
        this.preserveSelection(sel);
    }

    public void expandLogGraphNode(List graphNodes) {
        LogGraphNode node = null;
        int s = graphNodes.size();
        int i = 0;
        while (i < s) {
            node = (LogGraphNode)((Object)graphNodes.get(i));
            this.addToExpandedList(node);
            ++i;
        }
        node = (LogGraphNode)((Object)graphNodes.get(0));
        CBECommonBaseEvent sel = (CBECommonBaseEvent)node.getElement();
        this.pageCache[this.currentPageIndex] = null;
        int x = this.view.getSDWidget().getContentsX();
        int y = this.view.getSDWidget().getContentsY();
        this.view.setFrameAndEnsureVisible((Frame)this.createPage(false), x, y);
        this.disableMessageActions();
        this.preserveSelection(sel);
    }

    public LogGraphNode getParentNode(CBECommonBaseEvent event) {
        TraceLifeline eventLifeLine = (TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(event)));
        int i = 0;
        while (i < this.expandedList.size()) {
            CBECommonBaseEvent parent = (CBECommonBaseEvent)this.expandedList.get(i);
            if (this.currentPageEvents.get(parent) != null && ((LogRecordComparator)this.getComparator()).compareByTime(event, parent) == 0 && eventLifeLine == (TraceLifeline)((Object)this.lifelinesMap.get(this.getLifelinesMapKey(parent)))) {
                return (LogGraphNode)((Object)this.graphNodes.get(parent));
            }
            ++i;
        }
        return null;
    }

    public boolean inExpandedList(CBECommonBaseEvent event) {
        if (event == null) {
            return false;
        }
        return this.getParentNode(event) != null;
    }

    public void addToExpandedList(LogGraphNode node) {
        if (!this.expandedList.contains(node.getElement())) {
            this.expandedList.add(node.getElement());
        }
    }

    public void removeFromExpandedList(LogGraphNode node) {
        if (node.hasElements()) {
            this.expandedList.remove(node.getElement());
        } else {
            CBECommonBaseEvent parent = (CBECommonBaseEvent)this.getParentNode((CBECommonBaseEvent)node.getElement()).getElement();
            if (parent != null) {
                this.expandedList.remove(parent);
            }
        }
    }

    public QueryResult getCorrelations() {
        return this.outBoundCorrelations;
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(IJobChangeEvent event) {
        if (event.getJob() instanceof CorrelationHelper.CorrelationJob && ((CorrelationHelper.CorrelationJob)event.getJob()).getContainer() == this.inputObject) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    LogInteractions.this.refresh();
                    CBECommonBaseEvent sel = (CBECommonBaseEvent)UIPlugin.getDefault().getSelectionModel(LogInteractions.this.inputObject).getFirstElement();
                    if (sel != null) {
                        LogInteractions.this.setSelection(sel);
                    }
                }
            });
        }
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    private void revealGraphConnections(CBECommonBaseEvent selection) {
        this.pageCache[this.currentPageIndex] = null;
        int x = this.view.getSDWidget().getContentsX();
        int y = this.view.getSDWidget().getContentsY();
        this.view.setFrameAndEnsureVisible((Frame)this.createPage(false), x, y);
        this.disableMessageActions();
        this.preserveSelection(selection);
    }

    private void disableMessageActions() {
        this.view.setEnableCommand("org.eclipse.hyades.uml2sd.ui.actions.GoToCalled", false);
        this.view.setEnableCommand("org.eclipse.hyades.uml2sd.ui.actions.GoToCaller", false);
        this.view.setEnableAction("org.eclipse.hyades.uml2sd.ui.actions.ShowStatTable", false);
    }

    private List getCurrentPageEventsList() {
        int k = this.getMaxCurrentPageRangeIndex();
        int startPageIndex = this.currentPageIndex * this.PAGE_SIZE;
        int endPageIndex = this.currentPageIndex * this.PAGE_SIZE + k;
        if (endPageIndex > this.eventsList.size()) {
            k = this.getMaxCurrentPageRangeIndex();
            startPageIndex = 0;
            endPageIndex = k;
        }
        return this.eventsList.subList(startPageIndex, endPageIndex);
    }

    public void handleRecordChangeEvent(RecordChangeEvent event) {
        if (event.getType() == 6 || event.getType() == 5) {
            this.filterChanged = true;
            this.refresh();
        }
    }

    protected PerfUtil getPerformanceMonitor() {
        if (this.p == null) {
            this.p = new PerfUtil("LogInteractions", false);
        }
        return this.p;
    }

    public void filterUpdated() {
        this.filterChanged = true;
        if (this.fPartVisible) {
            this.refresh();
        } else {
            this.fForceRefresh = true;
        }
    }

    public void setFilterQueryProvider(IFilterQueryProvider filterQueryProvider) {
        this._filterQueryProvider = filterQueryProvider;
    }

    public String[] getFilterScope() {
        String[] scope = new String[]{"LoggingAgentScope"};
        return scope;
    }

    private List getFilteredElements(SimpleSearchQuery filter, List source, EClass output) {
        if (source == null) {
            return new ArrayList();
        }
        if (filter == null) {
            return new ArrayList();
        }
        filter.getSources().clear();
        Resource resource = null;
        int i = 0;
        while (i < source.size()) {
            if (source.get(i) instanceof EObject) {
                filter.getSources().add((Object)EcoreUtil.getURI((EObject)((EObject)source.get(i))).toString());
                if (resource == null) {
                    resource = ((EObject)source.get(i)).eResource();
                }
            }
            ++i;
        }
        if (resource == null) {
            return new ArrayList();
        }
        filter.getOutputElements().clear();
        SimpleOperand outputElement = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        outputElement.setType(output);
        filter.getOutputElements().add((Object)outputElement);
        HierarchyXMIQueryEngine engine = new HierarchyXMIQueryEngine();
        QueryResult result = engine.executeQuery((Query)filter, resource.getResourceSet(), (Collection)Collections.EMPTY_LIST);
        if (result == null) {
            return new ArrayList();
        }
        return (List)((ResultEntry)result.getResultEntries().get(0)).getValue();
    }

    protected List getFilteredLogRecords(List source) {
        SimpleSearchQuery filter = this._filterQueryProvider.getCurrentFilter();
        if (filter == null) {
            filter = QueryUtils.getEmptyQuery();
        }
        ArrayList filteredLogRecords = new ArrayList();
        filteredLogRecords.addAll(this.getFilteredElements(filter, source, CBEPackageImpl.init().getCBECommonBaseEvent()));
        Collections.sort(filteredLogRecords, this.getComparator());
        return filteredLogRecords;
    }

    protected IFilterQueryProvider getFilterQueryProvider() {
        return this._filterQueryProvider;
    }

    protected SimpleSearchQuery getQueryForSQL(List agentProxies, boolean timeBasedCorrelation) {
        TimeBasedCorrelationQuery tbcq;
        Object filter = this.getFilterQueryProvider().getCurrentFilter();
        if (filter == null) {
            filter = timeBasedCorrelation ? QueryUtils.getEmptyTimeBasedCorrelationQuery() : QueryUtils.getEmptyQuery();
        }
        if (timeBasedCorrelation) {
            if (!(filter instanceof TimeBasedCorrelationQuery)) {
                tbcq = ExtensionsFactory.eINSTANCE.createTimeBasedCorrelationQuery();
                tbcq.setCount(filter.isCount());
                tbcq.setDistinct(filter.isDistinct());
                tbcq.setMaxElements(filter.getMaxElements());
                tbcq.setName(filter.getName());
                tbcq.setStartWith(filter.getStartWith());
                tbcq.setWhereExpression(filter.getWhereExpression());
                tbcq.getOutputElements().addAll((Collection)filter.getOutputElements());
                tbcq.getOrderByExpresions().addAll((Collection)filter.getOrderByExpresions());
                tbcq.getSources().addAll((Collection)filter.getSources());
                tbcq.getSubQuery().addAll((Collection)filter.getSubQuery());
                filter = tbcq;
            }
        } else if (filter instanceof TimeBasedCorrelationQuery) {
            tbcq = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
            tbcq.setCount(filter.isCount());
            tbcq.setDistinct(filter.isDistinct());
            tbcq.setMaxElements(filter.getMaxElements());
            tbcq.setName(filter.getName());
            tbcq.setStartWith(filter.getStartWith());
            tbcq.setWhereExpression(filter.getWhereExpression());
            tbcq.getOutputElements().addAll((Collection)filter.getOutputElements());
            tbcq.getOrderByExpresions().addAll((Collection)filter.getOrderByExpresions());
            tbcq.getSources().addAll((Collection)filter.getSources());
            tbcq.getSubQuery().addAll((Collection)filter.getSubQuery());
            filter = tbcq;
        }
        SimpleOperand Operand2 = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        Operand2.setType(CBEPackage.eINSTANCE.getCBECommonBaseEvent());
        filter.getOutputElements().add((Object)Operand2);
        int s = agentProxies.size();
        if (this.correlationContainerProxy != null) {
            if (timeBasedCorrelation) {
                this.setCorrelationContainerURI((TimeBasedCorrelationQuery)filter);
            }
            Iterator iter = this.correlationContainerProxy.getCorrelatedAgents().iterator();
            while (iter.hasNext()) {
                TRCAgentProxy agentProxy = (TRCAgentProxy)iter.next();
                this.addAgentToQuery((SimpleSearchQuery)filter, agentProxy, timeBasedCorrelation);
            }
        } else {
            int i = 0;
            while (i < s) {
                TRCAgentProxy agentProxy;
                if (agentProxies.get(i) instanceof TRCAgentProxy) {
                    agentProxy = (TRCAgentProxy)agentProxies.get(i);
                    this.addAgentToQuery((SimpleSearchQuery)filter, agentProxy, timeBasedCorrelation);
                } else if (agentProxies.get(i) instanceof CorrelationContainerProxy) {
                    if (timeBasedCorrelation) {
                        ((TimeBasedCorrelationQuery)filter).setCorrelationContainerURI(EcoreUtil.getURI((EObject)((CorrelationContainerProxy)agentProxies.get(i)).getCorrelationContainer()).toString());
                    }
                    Iterator iter = ((CorrelationContainerProxy)agentProxies.get(i)).getCorrelatedAgents().iterator();
                    while (iter.hasNext()) {
                        agentProxy = (TRCAgentProxy)iter.next();
                        this.addAgentToQuery((SimpleSearchQuery)filter, agentProxy, timeBasedCorrelation);
                    }
                }
                ++i;
            }
        }
        filter.getOrderByExpresions().addAll((Collection)LogQueryBuilder.createOrderByClause((EClass)CBEPackage.eINSTANCE.getCBECommonBaseEvent(), (ISortElement[])this.getFilterCriteria().getSortColumns()));
        return filter;
    }

    private void setCorrelationContainerURI(TimeBasedCorrelationQuery query2) {
        if (this.correlationContainerProxy == null) {
            return;
        }
        CorrelationContainer correlationContainer = (CorrelationContainer)this.correlationContainerProxy.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getCorrelationContainerProxy_CorrelationContainer(), false);
        if (correlationContainer == null) {
            return;
        }
        if (correlationContainer.eResource() != null) {
            ((InternalEObject)correlationContainer).eSetProxyURI(null);
        }
        query2.setCorrelationContainerURI(correlationContainer.toString());
    }

    private void addAgentToQuery(SimpleSearchQuery filter, TRCAgentProxy agentProxy, boolean timeBasedCorrelation) {
        TRCAgent agent = (TRCAgent)agentProxy.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false);
        if (agent != null) {
            String uri = EcoreUtil.getURI((EObject)agent).toString();
            if (!filter.getSources().contains((Object)uri)) {
                filter.getSources().add((Object)uri);
            }
            if (timeBasedCorrelation) {
                double delta = agentProxy.getDeltaTime() != 0.0 ? agentProxy.getDeltaTime() : (agentProxy.getProcessProxy() != null && agentProxy.getProcessProxy().getNode() != null ? agentProxy.getProcessProxy().getNode().getDeltaTime() : 0.0);
                ((TimeBasedCorrelationQuery)filter).getDeltaTime().add((Object)new Double(delta));
            }
        }
    }

    public void setSelectionChangedByLoader(boolean newValue) {
        this.selectionChangedByLoader = newValue;
    }

    public class LogInteractionsFrame
    extends Frame {
        public int getMaxEventOccurrence() {
            return super.getMaxEventOccurrence();
        }

        public List getLifelines() {
            return super.getLifelines();
        }
    }

    public class TraceLifeline
    extends Lifeline {
        public EObject model;
        public int start;
        public int end;
    }

    protected class LogRecordComparator
    implements Comparator {
        protected LogRecordComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)o1)) > CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)o2))) {
                return 1;
            }
            if (CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)o1)) == CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)o2))) {
                if (((CBECommonBaseEvent)o1).getSequenceNumber() > ((CBECommonBaseEvent)o2).getSequenceNumber()) {
                    return 1;
                }
                if (((CBECommonBaseEvent)o1).getSequenceNumber() == ((CBECommonBaseEvent)o2).getSequenceNumber()) {
                    return 0;
                }
                return -1;
            }
            return -1;
        }

        public int compareByTime(Object o1, Object o2) {
            if (CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)o1)) > CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)o2))) {
                return 1;
            }
            if (CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)o1)) == CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)((CBECommonBaseEvent)o2))) {
                return 0;
            }
            return -1;
        }
    }
}

