/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.logc.internal.preferences;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.sd.logc.internal.preferences.ILogInteractionsPreferenceListener;
import org.eclipse.hyades.sd.logc.internal.util.ContextIds;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.log.views.internal.LogViewsMessages;
import org.eclipse.tptp.platform.log.views.internal.LogViewsPlugin;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class LogInteractionsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ModifyListener {
    private Text txtPageSize;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, ContextIds.INTERACTION_VIEW_PREF);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 5;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label note = new Label(composite, 64);
        note.setText(LogViewsMessages._76);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.widthHint = 375;
        note.setLayoutData((Object)data);
        Label dummy = new Label(composite, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        dummy.setLayoutData((Object)data);
        Label label = new Label(composite, 0);
        label.setText(LogViewsMessages._140);
        this.txtPageSize = new Text(composite, 2048);
        this.txtPageSize.setTextLimit(5);
        data = new GridData();
        data.widthHint = this.convertWidthInCharsToPixels(7);
        this.txtPageSize.setLayoutData((Object)data);
        this.txtPageSize.setText(this.getPreferenceStore().getString("page_size"));
        this.txtPageSize.addModifyListener((ModifyListener)this);
        return composite;
    }

    public IPreferenceStore getPreferenceStore() {
        return LogViewsPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
    }

    private void initializeDefaults() {
        this.txtPageSize.setText(this.getPreferenceStore().getDefaultString("page_size"));
    }

    protected void performDefaults() {
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        IUml2SDLoader loader = LoadersManager.getLoadersManager().getCurrentLoader("org.eclipse.hyades.sd.logc.LogInteractionsView");
        if (loader instanceof ILogInteractionsPreferenceListener) {
            ((ILogInteractionsPreferenceListener)loader).applyPreferences();
        }
        return true;
    }

    private void storeValues() {
        this.getPreferenceStore().setValue("page_size", this.txtPageSize.getText());
    }

    public void modifyText(ModifyEvent e) {
        IStatus status = this.validateInput();
        this.setValid(status.getSeverity() == 0);
        if (status.getSeverity() == 4) {
            this.setErrorMessage(status.getMessage());
        } else {
            this.setErrorMessage(null);
        }
    }

    private IStatus validateInput() {
        String nrOfPages = this.txtPageSize.getText();
        PreferenceStatus status = new PreferenceStatus();
        if (nrOfPages.length() == 0) {
            status.setMessage(LogViewsMessages._141);
            status.setSeverity(4);
        } else {
            try {
                int value = Integer.parseInt(nrOfPages);
                if (value <= 0) {
                    status.setMessage(NLS.bind((String)LogViewsMessages._142, (Object[])new String[]{nrOfPages}));
                    status.setSeverity(4);
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setMessage(NLS.bind((String)LogViewsMessages._142, (Object[])new String[]{nrOfPages}));
                status.setSeverity(4);
            }
        }
        return status;
    }

    class PreferenceStatus
    extends Status {
        public PreferenceStatus() {
            super(0, "hyades.sd.logc", 0, "", null);
        }

        protected void setMessage(String message) {
            super.setMessage(message);
        }

        protected void setSeverity(int severity) {
            super.setSeverity(severity);
        }
    }
}

