/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.log.views.internal;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.log.ui.internal.LogUIPluginImages;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.internal.sdb.impl.SDBFactoryImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBPackageImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBResourceSetImpl;
import org.eclipse.hyades.sd.logc.SDLogcPluginImages;
import org.eclipse.hyades.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.ui.filters.internal.util.FilterResourceHandler;
import org.eclipse.hyades.ui.internal.filters.ModelUtils;
import org.eclipse.hyades.ui.internal.util.PreferencesUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.log.views.internal.LogViewsMessages;
import org.eclipse.tptp.platform.log.views.internal.util.IRecordPaneViewerListener;
import org.eclipse.tptp.platform.log.views.internal.util.LogUIConstants;
import org.eclipse.tptp.platform.log.views.internal.util.LogUtil;
import org.eclipse.tptp.platform.log.views.internal.util.RecordChangeEvent;
import org.eclipse.tptp.platform.log.views.internal.views.LogFiltersStandardUI;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class LogViewsPlugin
extends AbstractUIPlugin {
    private static LogViewsPlugin inst;
    private static ResourceBundle fResourceBundle;
    private SDBFactoryImpl factory;
    private ResourceSet resourceSet;
    private ArrayList recordChangeListeners = null;
    public static final String PLUGIN_ID = "org.eclipse.tptp.platform.log.views";

    static {
        fResourceBundle = null;
    }

    public LogViewsPlugin() {
        if (inst == null) {
            inst = this;
        }
    }

    public static LogViewsPlugin getDefault() {
        return inst;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        return LogUIPluginImages.getImageDescriptor((String)name);
    }

    public static ResourceBundle getResourceBundle() {
        if (fResourceBundle == null) {
            try {
                fResourceBundle = Platform.getResourceBundle((Bundle)Platform.getBundle((String)PLUGIN_ID));
            }
            catch (Exception exception) {
                fResourceBundle = null;
            }
        }
        return fResourceBundle;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = LogViewsPlugin.getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getString(String key) {
        return LogViewsPlugin.getResourceString(key);
    }

    public static Shell getActiveWorkbenchShell() {
        return LogViewsPlugin.getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return LogViewsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static void log(Throwable e) {
        String msg = e.getMessage();
        LogViewsPlugin.getDefault().getLog().log((IStatus)new Status(4, LogViewsPlugin.getPluginId(), 4, msg == null ? "" : msg, e));
    }

    public static void log(IStatus status) {
        LogViewsPlugin.getDefault().getLog().log(status);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        LogUIPluginImages.shutdown();
        SDLogcPluginImages.shutdown();
        this.savePluginPreferences();
        fResourceBundle = null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        SDBPackageImpl.init();
        this.addDefaultFilters();
        this.factory = new SDBFactoryImpl();
        this.resourceSet = SDBResourceSetImpl.getInstance();
    }

    public SDBFactoryImpl getSymptomDBFactory() {
        if (this.factory == null) {
            this.factory = new SDBFactoryImpl();
        }
        return this.factory;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public static DateFormat getDateTimeFormat() {
        return DateFormat.getDateTimeInstance(LogViewsPlugin.getDateStyle(), LogViewsPlugin.getTimeStyle(), Locale.getDefault());
    }

    public static int getDateStyle() {
        IPreferenceStore store = inst.getPreferenceStore();
        String dateFormat = store.getString("LogAnalyzer.DateFormat");
        boolean valid = false;
        int i = 0;
        while (i < LogUIConstants.DATE_FORMAT_LIST.length) {
            if (dateFormat.equals(LogUIConstants.DATE_FORMAT_LIST[i])) {
                valid = true;
                break;
            }
            ++i;
        }
        if (!valid) {
            dateFormat = LogUIConstants.LA_FD_DEF;
        }
        if (dateFormat.equals(LogUIConstants.DATE_FORMAT_FULL)) {
            return 0;
        }
        if (dateFormat.equals(LogUIConstants.DATE_FORMAT_LONG)) {
            return 1;
        }
        if (dateFormat.equals(LogUIConstants.DATE_FORMAT_MEDIUM)) {
            return 2;
        }
        if (dateFormat.equals(LogUIConstants.DATE_FORMAT_SHORT)) {
            return 3;
        }
        return 2;
    }

    public static int getTimeStyle() {
        IPreferenceStore store = inst.getPreferenceStore();
        String timeFormat = store.getString("LogAnalyzer.TimeFormat");
        boolean valid = false;
        int i = 0;
        while (i < LogUIConstants.TIME_FORMAT_LIST.length) {
            if (timeFormat.equals(LogUIConstants.TIME_FORMAT_LIST[i])) {
                valid = true;
                break;
            }
            ++i;
        }
        if (!valid) {
            timeFormat = LogUIConstants.LA_FT_DEF;
        }
        if (timeFormat.equals(LogUIConstants.TIME_FORMAT_FULL)) {
            return 0;
        }
        if (timeFormat.equals(LogUIConstants.TIME_FORMAT_LONG)) {
            return 1;
        }
        if (timeFormat.equals(LogUIConstants.TIME_FORMAT_MEDIUM)) {
            return 2;
        }
        if (timeFormat.equals(LogUIConstants.TIME_FORMAT_SHORT)) {
            return 3;
        }
        return 2;
    }

    public static int getTimeZone() {
        IPreferenceStore store = inst.getPreferenceStore();
        String timeZone = PreferencesUtil.TIME_ZONE_LIST_OFFSET[store.getInt("LogAnalyzer.TimeZone")];
        return TimeZone.getTimeZone(timeZone).getRawOffset();
    }

    public static boolean normalizeTimeZone() {
        IPreferenceStore store = inst.getPreferenceStore();
        return store.getBoolean("LogAnalyzer.normalize.TimeZone");
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        LogUtil.initializePreferenceStore(store);
        store.setDefault("uml2sd__extend_filter_options", "");
        store.setDefault("uml2sd_extend_find_options", "");
        store.setDefault("uml2sd_extend_find_direction_options", "1");
        store.setDefault("page_size", 500);
    }

    public void addRecordPaneViewerListener(IRecordPaneViewerListener listener) {
        if (this.recordChangeListeners == null) {
            this.recordChangeListeners = new ArrayList();
        }
        if (!this.recordChangeListeners.contains(listener)) {
            this.recordChangeListeners.add(listener);
        }
    }

    public void removeRecordPaneViewerListener(IRecordPaneViewerListener listener) {
        if (this.recordChangeListeners != null) {
            this.recordChangeListeners.remove(listener);
        }
    }

    public void fireRecordChangeNotification(RecordChangeEvent e) {
        if (this.recordChangeListeners != null) {
            int i = 0;
            while (i < this.recordChangeListeners.size()) {
                ((IRecordPaneViewerListener)this.recordChangeListeners.get(i)).handleRecordChangeEvent(e);
                ++i;
            }
        }
    }

    private void addDefaultFilters() {
        String logViewsPluginDefaultFiltersKey = PLUGIN_ID;
        if (!FilterResourceHandler.isDefaultFiltersAddedForKey((String)logViewsPluginDefaultFiltersKey)) {
            ArrayList<FilterQueries> filtersToAdd = new ArrayList<FilterQueries>();
            FilterQueries fq = FilterResourceHandler.createFilterQueries((String)"org.eclipse.tptp.platform.log.views.LogFilterType", (String)LogViewsPlugin.getResourceString(LogViewsMessages._71), null, null);
            SimpleSearchQuery query = fq.standard();
            this.addSeverityBetweenArguement(query, LogFiltersStandardUI.VALUES_SEVERITY_ERROR);
            filtersToAdd.add(fq);
            fq = FilterResourceHandler.createFilterQueries((String)"org.eclipse.tptp.platform.log.views.LogFilterType", (String)LogViewsPlugin.getResourceString(LogViewsMessages._72), null, null);
            query = fq.standard();
            this.addSeverityBetweenArguement(query, LogFiltersStandardUI.VALUES_SEVERITY_WARNING);
            filtersToAdd.add(fq);
            fq = FilterResourceHandler.createFilterQueries((String)"org.eclipse.tptp.platform.log.views.LogFilterType", (String)LogViewsPlugin.getResourceString(LogViewsMessages._73), null, null);
            query = fq.standard();
            this.addSeverityBetweenArguement(query, LogFiltersStandardUI.VALUES_SEVERITY_INFORMATION);
            filtersToAdd.add(fq);
            fq = FilterResourceHandler.createFilterQueries((String)"org.eclipse.tptp.platform.log.views.LogFilterType", (String)LogViewsPlugin.getResourceString(LogViewsMessages._74), null, null);
            fq.standard((SimpleSearchQuery)ExtensionsFactory.eINSTANCE.createTimeBasedCorrelationQuery());
            filtersToAdd.add(fq);
            FilterResourceHandler.addFiltersOnInstanceLoad(filtersToAdd);
            FilterResourceHandler.defaultFiltersAddedForKey((String)logViewsPluginDefaultFiltersKey, (boolean)true);
        }
    }

    private void addSeverityBetweenArguement(SimpleSearchQuery query, String[] betweenValues) {
        LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
        logicalExpression.setOperator(LogicalOperators.AND_LITERAL);
        LogicalExpression severityLogicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
        severityLogicalExpression.setOperator(LogicalOperators.OR_LITERAL);
        EList arguments = severityLogicalExpression.getArguments();
        arguments.add((Object)ModelUtils.createBinaryExpression((EStructuralFeature)LogFiltersStandardUI.ATTRIBUTE_SEVERITY_CONTROL, (RelationalOperators)LogFiltersStandardUI.OPERATOR_BETWEEN, (String[])betweenValues, (boolean)false));
        logicalExpression.getArguments().add((Object)severityLogicalExpression);
        query.setWhereExpression((WhereExpression)logicalExpression);
    }
}

