/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.log.views.internal.preferences;

import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.tptp.platform.log.views.internal.LogViewsMessages;
import org.eclipse.tptp.platform.log.views.internal.LogViewsPlugin;
import org.eclipse.tptp.platform.log.views.internal.LogViewsPluginImages;
import org.eclipse.tptp.platform.log.views.internal.preferences.LogAnalyzerFilterPrefPage;
import org.eclipse.tptp.platform.log.views.internal.preferences.LogAnalyzerFormatPrefPage;
import org.eclipse.tptp.platform.log.views.internal.preferences.LogAnalyzerSortPrefPage;
import org.eclipse.tptp.platform.log.views.internal.util.RecordChangeEvent;
import org.eclipse.tptp.platform.log.views.internal.util.StatusInfo;
import org.eclipse.tptp.platform.log.views.internal.util.StatusUtil;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class LogAnalyzerBasePrefPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private LogAnalyzerFormatPrefPage _format;
    private LogAnalyzerSortPrefPage _sort;
    private LogAnalyzerFilterPrefPage _filter;

    public LogAnalyzerBasePrefPage() {
        this.setPreferenceStore(LogViewsPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(LogViewsPlugin.getPluginId()) + ".labp0000");
        Composite composite = new Composite(parent, 0);
        GridData data = GridUtil.createFill();
        data.heightHint = 100;
        composite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        TabFolder folder = new TabFolder(composite, 0);
        data = GridUtil.createFill();
        data.heightHint = 350;
        folder.setLayoutData((Object)data);
        TabItem item = new TabItem(folder, 0);
        item.setText(LogViewsMessages._6);
        item.setImage(LogViewsPluginImages.getImage("datetime_obj.gif"));
        this._format = new LogAnalyzerFormatPrefPage(this.getPreferenceStore());
        item.setControl(this._format.createContents((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(LogViewsMessages._4);
        item.setImage(LogViewsPluginImages.getImage("sortrecords_co.gif"));
        this._sort = new LogAnalyzerSortPrefPage(this.getPreferenceStore());
        item.setControl(this._sort.createContents((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(LogViewsMessages._5);
        item.setImage(LogViewsPluginImages.getImage("filter_ps.gif"));
        this._filter = new LogAnalyzerFilterPrefPage(this.getPreferenceStore());
        item.setControl(this._filter.createContents((Composite)folder));
        this.addSelectionListenerToWidgets();
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
        this._format.performDefaults();
        this._sort.performDefaults();
        this._filter.performDefaults();
        this.resetMessageOnStatusLine();
        this.setValid(true);
    }

    public boolean performOk() {
        boolean returnValue;
        boolean isRefreshRequired = false;
        if (this._sort.hasSortChanged()) {
            isRefreshRequired = true;
        }
        boolean bl = returnValue = this._format.performOk() && this._sort.performOk() && this._filter.performOk();
        if (isRefreshRequired) {
            LogViewsPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(6, (Object)this));
        }
        return returnValue;
    }

    protected void performApply() {
        boolean isRefreshRequired = false;
        this._format.performOk();
        if (this._sort.hasSortChanged()) {
            isRefreshRequired = true;
        }
        this._sort.performApply();
        this._filter.performApply();
        if (isRefreshRequired) {
            LogViewsPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(6, (Object)this));
        }
    }

    protected void showMessageOnStatusLine() {
        StatusUtil.applyToStatusLine((DialogPage)this, new StatusInfo(4, LogViewsMessages._92));
    }

    protected void resetMessageOnStatusLine() {
        StatusUtil.applyToStatusLine((DialogPage)this, new StatusInfo(0, LogViewsMessages._4));
    }

    protected boolean ifAllItemsIsUnchecked() {
        int idx = 0;
        while (idx < this._filter._options._pdList.getItemCount()) {
            if (this._filter._options._pdList.getItem(idx).getChecked()) {
                return false;
            }
            ++idx;
        }
        return true;
    }

    protected void addSelectionListenerToWidgets() {
        this._filter._options._unselAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LogAnalyzerBasePrefPage.this.showMessageOnStatusLine();
                LogAnalyzerBasePrefPage.this.setValid(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this._filter._options._selAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LogAnalyzerBasePrefPage.this.resetMessageOnStatusLine();
                LogAnalyzerBasePrefPage.this.setValid(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this._filter._options._pdList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (LogAnalyzerBasePrefPage.this.ifAllItemsIsUnchecked()) {
                    LogAnalyzerBasePrefPage.this.showMessageOnStatusLine();
                    LogAnalyzerBasePrefPage.this.setValid(false);
                } else {
                    LogAnalyzerBasePrefPage.this.resetMessageOnStatusLine();
                    LogAnalyzerBasePrefPage.this.setValid(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }
}

