/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.log.views.internal.preferences;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.util.PreferencesUtil;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tptp.platform.log.views.internal.LogViewsMessages;
import org.eclipse.tptp.platform.log.views.internal.LogViewsPlugin;
import org.eclipse.tptp.platform.log.views.internal.util.LogUIConstants;
import org.eclipse.tptp.platform.log.views.internal.util.LogViewsContextIds;
import org.eclipse.tptp.platform.log.views.internal.util.RecordChangeEvent;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class LogAnalyzerFormatPrefPage
implements SelectionListener {
    private Combo dateFormatCombo;
    private Combo timeFormatCombo;
    private Combo timeZoneCombo;
    private Button normalizeLog;
    private IPreferenceStore _preferenceStore;

    public LogAnalyzerFormatPrefPage(IPreferenceStore preferenceStore) {
        this._preferenceStore = preferenceStore;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label description = new Label(composite, 64);
        description.setText(LogViewsMessages._7);
        GridData data = GridDataUtil.createHorizontalFill();
        data.heightHint = 30;
        description.setLayoutData((Object)data);
        Composite comboComposite = this.createComboGroup(composite);
        this.createFormatComboBoxes(comboComposite);
        return composite;
    }

    private Composite createComboGroup(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 10;
        layout.numColumns = 2;
        Composite comboComposite = new Composite(composite, 16384);
        comboComposite.setLayout((Layout)layout);
        comboComposite.setLayoutData((Object)GridUtil.createHorizontalFill());
        return comboComposite;
    }

    private void createFormatComboBoxes(Composite composite) {
        Label dateFormatLabel = new Label(composite, 0);
        dateFormatLabel.setText(LogViewsMessages._8);
        this.dateFormatCombo = new Combo(composite, 8);
        this.dateFormatCombo.setItems(this.createDateFormatList());
        this.dateFormatCombo.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label timeFormatLabel = new Label(composite, 0);
        timeFormatLabel.setText(LogViewsMessages._9);
        this.timeFormatCombo = new Combo(composite, 8);
        this.timeFormatCombo.setItems(this.createTimeFormatList());
        this.timeFormatCombo.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.normalizeLog = new Button(composite, 32);
        this.normalizeLog.setText(LogViewsMessages._10);
        this.normalizeLog.addSelectionListener((SelectionListener)this);
        GridData data = GridDataUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        this.normalizeLog.setLayoutData((Object)data);
        Label timeZoneLabel = new Label(composite, 0);
        timeZoneLabel.setText(LogViewsMessages._11);
        this.timeZoneCombo = new Combo(composite, 8);
        this.timeZoneCombo.setItems(this.createTimeZoneList());
        this.timeZoneCombo.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.selectFormatComboBoxes(this._preferenceStore.getString("LogAnalyzer.DateFormat"), this._preferenceStore.getString("LogAnalyzer.TimeFormat"), this._preferenceStore.getBoolean("LogAnalyzer.normalize.TimeZone"), this._preferenceStore.getInt("LogAnalyzer.TimeZone"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.dateFormatCombo, LogViewsContextIds.ACTLOG_PREF_FORMAT_DATE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.timeFormatCombo, LogViewsContextIds.ACTLOG_PREF_FORMAT_TIME);
    }

    private String[] createDateFormatList() {
        Date currentDate = new Date(System.currentTimeMillis());
        String[] dateFormatList = new String[]{String.valueOf(LogUIConstants.DATE_FORMAT_FULL) + " (" + DateFormat.getDateInstance((int)0).format(currentDate) + ")", String.valueOf(LogUIConstants.DATE_FORMAT_LONG) + " (" + DateFormat.getDateInstance((int)1).format(currentDate) + ")", String.valueOf(LogUIConstants.DATE_FORMAT_MEDIUM) + " (" + DateFormat.getDateInstance((int)2).format(currentDate) + ")", String.valueOf(LogUIConstants.DATE_FORMAT_SHORT) + " (" + DateFormat.getDateInstance((int)3).format(currentDate) + ")"};
        return dateFormatList;
    }

    private String[] createTimeFormatList() {
        Date currentDate = new Date(System.currentTimeMillis());
        String[] timeFormatList = new String[]{String.valueOf(LogUIConstants.TIME_FORMAT_FULL) + " (" + DateFormat.getTimeInstance((int)0).format(currentDate) + ")", String.valueOf(LogUIConstants.TIME_FORMAT_LONG) + " (" + DateFormat.getTimeInstance((int)1).format(currentDate) + ")", String.valueOf(LogUIConstants.TIME_FORMAT_MEDIUM) + " (" + DateFormat.getTimeInstance((int)2).format(currentDate) + ")", String.valueOf(LogUIConstants.TIME_FORMAT_SHORT) + " (" + DateFormat.getTimeInstance((int)3).format(currentDate) + ")"};
        return timeFormatList;
    }

    private String[] createTimeZoneList() {
        String[] timeZoneComboList = new String[PreferencesUtil.TIME_ZONE_LIST.length];
        int i = 0;
        while (i < PreferencesUtil.TIME_ZONE_LIST.length) {
            timeZoneComboList[i] = PreferencesUtil.TIME_ZONE_LIST[i];
            ++i;
        }
        return timeZoneComboList;
    }

    private void selectFormatComboBoxes(String dateFormat, String timeFormat, boolean normalizedTimeZone, int timeZoneIndex) {
        int index = -1;
        int i = 0;
        while (i < LogUIConstants.DATE_FORMAT_LIST.length) {
            if (dateFormat.equals(LogUIConstants.DATE_FORMAT_LIST[i])) {
                index = i;
                break;
            }
            ++i;
        }
        if (index > -1) {
            this.dateFormatCombo.select(index);
        } else {
            this.dateFormatCombo.select(0);
        }
        index = -1;
        i = 0;
        while (i < LogUIConstants.TIME_FORMAT_LIST.length) {
            if (timeFormat.equals(LogUIConstants.TIME_FORMAT_LIST[i])) {
                index = i;
                break;
            }
            ++i;
        }
        if (index > -1) {
            this.timeFormatCombo.select(index);
        } else {
            this.timeFormatCombo.select(0);
        }
        index = timeZoneIndex;
        if (index > -1) {
            this.timeZoneCombo.select(index);
        } else {
            this.timeZoneCombo.select(0);
        }
        this.normalizeLog.setSelection(normalizedTimeZone);
        this.timeZoneCombo.setEnabled(this.normalizeLog.getSelection());
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.selectFormatComboBoxes(this._preferenceStore.getDefaultString("LogAnalyzer.DateFormat"), this._preferenceStore.getDefaultString("LogAnalyzer.TimeFormat"), this._preferenceStore.getDefaultBoolean("LogAnalyzer.normalize.TimeZone"), this._preferenceStore.getDefaultInt("LogAnalyzer.TimeZone"));
    }

    public boolean performOk() {
        String selectedDateFormat = LogUIConstants.DATE_FORMAT_LIST[this.dateFormatCombo.getSelectionIndex()];
        boolean dateFmtChanged = false;
        if (!this._preferenceStore.getString("LogAnalyzer.DateFormat").equals(selectedDateFormat)) {
            dateFmtChanged = true;
        }
        this._preferenceStore.setValue("LogAnalyzer.DateFormat", selectedDateFormat);
        String selectedTimeFormat = LogUIConstants.TIME_FORMAT_LIST[this.timeFormatCombo.getSelectionIndex()];
        boolean timeFmtChanged = false;
        if (!this._preferenceStore.getString("LogAnalyzer.TimeFormat").equals(selectedTimeFormat)) {
            timeFmtChanged = true;
        }
        this._preferenceStore.setValue("LogAnalyzer.TimeFormat", selectedTimeFormat);
        int selectedTimeZoneIndex = this.timeZoneCombo.getSelectionIndex();
        boolean timeZoneChanged = false;
        if (this._preferenceStore.getInt("LogAnalyzer.TimeZone") != selectedTimeZoneIndex) {
            timeZoneChanged = true;
        }
        this._preferenceStore.setValue("LogAnalyzer.TimeZone", selectedTimeZoneIndex);
        boolean selectedNormalizeLog = this.normalizeLog.getSelection();
        boolean normalizeLogChanged = false;
        if (this._preferenceStore.getBoolean("LogAnalyzer.normalize.TimeZone") != selectedNormalizeLog) {
            normalizeLogChanged = true;
        }
        this._preferenceStore.setValue("LogAnalyzer.normalize.TimeZone", selectedNormalizeLog);
        LogViewsPlugin.getDefault().savePluginPreferences();
        if (dateFmtChanged || timeFmtChanged || timeZoneChanged || normalizeLogChanged) {
            LogViewsPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(3, this));
        }
        return true;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.normalizeLog) {
            this.timeZoneCombo.setEnabled(this.normalizeLog.getSelection());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

