/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.log.views.internal.preferences;

import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tptp.platform.log.views.internal.LogViewsPlugin;
import org.eclipse.tptp.platform.log.views.internal.util.CBESortUI;
import org.eclipse.tptp.platform.log.views.internal.util.LogViewsContextIds;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class LogAnalyzerSortPrefPage {
    private CBESortUI _options;
    private IPreferenceStore _preferenceStore;

    public LogAnalyzerSortPrefPage(IPreferenceStore preferenceStore) {
        this._preferenceStore = preferenceStore;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        composite.setLayoutData((Object)data);
        this._options = new CBESortUI(LogViewsPlugin.getDefault().getPreferenceStore());
        this._options.createControl(composite);
        this.initializeValues();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, LogViewsContextIds.ACTLOG_PREF_SORT_RECORDS);
        return composite;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return LogViewsPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
    }

    private void initializeDefaults() {
        this._options.initializeValues(true);
    }

    private void initializeValues() {
        this._options.initializeValues(false);
    }

    protected void performDefaults() {
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        return true;
    }

    public void performApply() {
        this._options.applyValues(this._preferenceStore);
        LogViewsPlugin.getDefault().savePluginPreferences();
    }

    public boolean hasSortChanged() {
        boolean changed = false;
        boolean bl = changed = !this._preferenceStore.getString("pd_sort_log_options").equals(this._options.getPreferenceString());
        if (this._preferenceStore.getInt("pd_sort_log_order") > 0 && this._options.getDsceRadio().getSelection() || this._preferenceStore.getInt("pd_sort_log_order") < 0 && this._options.getAsceRadio().getSelection()) {
            changed = true;
        }
        return changed;
    }

    private void storeValues() {
        this._options.storeValues();
    }
}

