/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.log.views.internal.reports;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEComponentIdentification;
import org.eclipse.hyades.models.cbe.CBEDefaultElement;
import org.eclipse.hyades.models.cbe.CBESituation;
import org.eclipse.tptp.platform.log.views.internal.LogViewsPlugin;
import org.eclipse.tptp.platform.log.views.internal.reports.ReportXMLLogWizard;

public class CSVReportLogWizard
extends ReportXMLLogWizard {
    public CSVReportLogWizard() {
        this.setWindowTitle(LogViewsPlugin.getString("23"));
        this.FILE_EXTENSION = "csv";
    }

    protected void saveToFile(String filePath, List events, int[] index, Hashtable associationMap) {
        String newLine = System.getProperties().getProperty("line.separator");
        OutputStreamWriter writer = null;
        try {
            File file = new File(filePath);
            FileOutputStream outputStream = new FileOutputStream(file.toString(), false);
            writer = new OutputStreamWriter((OutputStream)outputStream, "UTF8");
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
            return;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("msg").append(",").append("creationTime").append(",").append("elapsedTime").append(",").append("globalInstanceId").append(",").append("localInstanceId").append(",").append("priority").append(",").append("repeatCount").append(",").append("severity").append(",").append("version").append(",").append("sequenceNumber").append(",").append("sourceComponentId_application").append(",").append("sourceComponentId_component").append(",").append("sourceComponentId_componentIdType").append(",").append("sourceComponentId_executionEnvironment").append(",").append("sourceComponentId_instanceId").append(",").append("sourceComponentId_location").append(",").append("sourceComponentId_locationType").append(",").append("sourceComponentId_processId").append(",").append("sourceComponentId_subComponent").append(",").append("sourceComponentId_threadId").append(",").append("situation_categoryName").append(",").append("situation_reasoningScope").append(",").append("extendedProperties_name").append(newLine);
        if (events != null) {
            int idx = 0;
            while (idx < events.size()) {
                Object event = events.get(idx);
                if (event instanceof CBECommonBaseEvent) {
                    CBECommonBaseEvent cbe = (CBECommonBaseEvent)event;
                    buffer.append(this.getCSVFormat(cbe.getMsg())).append(",").append(cbe.getCreationTime()).append(",").append(cbe.getElapsedTime()).append(",").append(this.getCSVFormat(cbe.getGlobalInstanceId())).append(",").append(cbe.getLocalInstanceId()).append(",").append(cbe.getPriority()).append(",").append(cbe.getRepeatCount()).append(",").append(cbe.getSeverity()).append(",").append(cbe.getVersion()).append(",").append(cbe.getSequenceNumber());
                    CBEComponentIdentification cbei = cbe.getSourceComponentId();
                    if (cbei != null) {
                        buffer.append(",").append(this.getCSVFormat(cbei.getApplication())).append(",").append(this.getCSVFormat(cbei.getComponent())).append(",").append(this.getCSVFormat(cbei.getComponentIdType())).append(",").append(this.getCSVFormat(cbei.getExecutionEnvironment())).append(",").append(cbei.getInstanceId()).append(",").append(this.getCSVFormat(cbei.getLocation())).append(",").append(this.getCSVFormat(cbei.getLocationType())).append(",").append(this.getCSVFormat(cbei.getProcessId())).append(",").append(this.getCSVFormat(cbei.getSubComponent())).append(",").append(cbei.getThreadId());
                    } else {
                        buffer.append(",").append(",").append(",").append(",").append(",").append(",").append(",").append(",").append(",").append(",");
                    }
                    CBESituation sit = cbe.getSituation();
                    if (sit != null) {
                        buffer.append(",").append(this.getCSVFormat(sit.getCategoryName())).append(",").append(this.getCSVFormat(sit.getReasoningScope()));
                    } else {
                        buffer.append(",").append(",");
                    }
                    Iterator iterator = cbe.getExtendedProperties().iterator();
                    while (iterator.hasNext()) {
                        Object obj = iterator.next();
                        if (obj == null || !(obj instanceof CBEDefaultElement)) continue;
                        CBEDefaultElement ev = (CBEDefaultElement)obj;
                        buffer.append(",").append(this.getCSVFormat(ev.getName()));
                    }
                    buffer.append(newLine);
                }
                ++idx;
            }
        }
        try {
            writer.write(buffer.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected String getCSVFormat(String text) {
        if (text == null) {
            return text;
        }
        if (text.indexOf(",") == -1 && text.indexOf("\"") == -1) {
            return text;
        }
        text = text.replaceAll("\"", "\"\"");
        return "\"" + text + "\"";
    }
}

