/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.log.views.internal.reports;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEComponentIdentification;
import org.eclipse.hyades.models.cbe.CBEDefaultElement;
import org.eclipse.hyades.models.cbe.CBESituation;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDLabelProvider;
import org.eclipse.hyades.trace.ui.internal.reports.HTMLTraceStatReportWizard;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.log.views.internal.LogViewsMessages;
import org.eclipse.tptp.platform.log.views.internal.LogViewsPlugin;

public class HTMLReportLogFileWizard
extends HTMLTraceStatReportWizard {
    public HTMLReportLogFileWizard() {
        this.setWindowTitle(LogViewsPlugin.getString("23"));
    }

    public boolean isAvailable(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        Object object = ((StructuredSelection)selection).getFirstElement();
        if (object == null) {
            return false;
        }
        if (object instanceof TRCMonitor) {
            TRCMonitor mon = (TRCMonitor)object;
            Iterator nodes = mon.getNodes().iterator();
            while (nodes.hasNext()) {
                TRCNode node = (TRCNode)nodes.next();
                Iterator processes = node.getProcessProxies().iterator();
                while (processes.hasNext()) {
                    TRCProcessProxy proces = (TRCProcessProxy)processes.next();
                    Iterator agents = proces.getAgentProxies().iterator();
                    while (agents.hasNext()) {
                        TRCAgentProxy ag = (TRCAgentProxy)agents.next();
                        if (ag.getType() == null || !ag.getType().equals("Logging")) continue;
                        return true;
                    }
                }
            }
        } else if (object instanceof TRCNode) {
            TRCNode node = (TRCNode)object;
            Iterator processes = node.getProcessProxies().iterator();
            while (processes.hasNext()) {
                TRCProcessProxy proces = (TRCProcessProxy)processes.next();
                Iterator agents = proces.getAgentProxies().iterator();
                while (agents.hasNext()) {
                    TRCAgentProxy ag = (TRCAgentProxy)agents.next();
                    if (ag.getType() == null || !ag.getType().equals("Logging")) continue;
                    return true;
                }
            }
        } else if (object instanceof TRCProcessProxy) {
            TRCProcessProxy proces = (TRCProcessProxy)object;
            Iterator agents = proces.getAgentProxies().iterator();
            while (agents.hasNext()) {
                TRCAgentProxy ag = (TRCAgentProxy)agents.next();
                if (ag.getType() == null || !ag.getType().equals("Logging")) continue;
                return true;
            }
        } else if (object instanceof TRCAgentProxy && ((TRCAgentProxy)object).getType() != null && ((TRCAgentProxy)object).getType().equals("Logging")) {
            return true;
        }
        return false;
    }

    public IFile generate(IProgressMonitor monitor) throws Exception {
        Object object = ((StructuredSelection)this.getSelection()).getFirstElement();
        if (object == null) {
            return null;
        }
        monitor.beginTask("", 4);
        IFile reportFile = this.getReportFile();
        monitor.worked(1);
        this.export(object, reportFile.getLocation().toOSString());
        monitor.worked(1);
        reportFile.getProject().refreshLocal(2, null);
        monitor.done();
        return reportFile;
    }

    protected boolean export(Object selection, String fileName) {
        if (fileName == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)LogViewsMessages._44, (String)TraceMessages._6);
            return false;
        }
        OutputStreamWriter writer = null;
        try {
            File file = new File(fileName);
            if (file.isDirectory()) {
                MessageDialog.openError((Shell)this.getShell(), (String)LogViewsMessages._44, (String)TraceMessages._7);
                return false;
            }
            FileOutputStream outputStream = new FileOutputStream(file.toString(), false);
            writer = new OutputStreamWriter((OutputStream)outputStream, "UTF8");
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
            return false;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.printHeader());
        buffer.append(this.printTitle(new PDLabelProvider().getText(selection)));
        List agentList = this.getSelectionAgents(selection);
        this.generateCBEForAgent(agentList, buffer);
        buffer.append(this.printFooter());
        try {
            writer.write(buffer.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    private void generateCBEForAgent(List agentList, StringBuffer buffer) {
        PDLabelProvider label = new PDLabelProvider();
        int idx = 0;
        while (idx < agentList.size()) {
            TRCAgentProxy agent = (TRCAgentProxy)agentList.get(idx);
            this.printTitle(label.getText((Object)agent));
            this.generateCBEStatistics(agent, buffer);
            ++idx;
        }
    }

    private void generateCBEStatistics(TRCAgentProxy agent, StringBuffer buffer) {
        boolean color = true;
        Iterator events = agent.getAgent().getDefaultEvents().iterator();
        buffer.append("<table border=0 cellspacing=2 cellpadding=2 WIDTH=\"100%\">").append(newLine);
        this.printColumnsHeader(buffer);
        while (events.hasNext()) {
            Object event = events.next();
            if (!(event instanceof CBECommonBaseEvent)) continue;
            CBECommonBaseEvent cbe = (CBECommonBaseEvent)event;
            if (color) {
                buffer.append("<tr BGCOLOR=\"#ffffbb\">").append(newLine);
            } else {
                buffer.append("<tr>").append(newLine);
            }
            buffer.append("<td align=").append(this.getAlign()).append(">").append(cbe.getMsg()).append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append(cbe.getCreationTime()).append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append(cbe.getElapsedTime()).append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append(cbe.getGlobalInstanceId()).append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append(cbe.getLocalInstanceId()).append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append(cbe.getPriority()).append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append(cbe.getRepeatCount()).append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append(cbe.getSeverity()).append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append(cbe.getVersion()).append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append(cbe.getSequenceNumber()).append("</td>").append(newLine);
            CBEComponentIdentification cbei = cbe.getSourceComponentId();
            if (cbei != null) {
                buffer.append("<td align=").append(this.getAlign()).append(">").append(cbei.getApplication()).append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append(cbei.getComponent()).append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append(cbei.getComponentIdType()).append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append(cbei.getExecutionEnvironment()).append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append(cbei.getInstanceId()).append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append(cbei.getLocation()).append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append(cbei.getLocationType()).append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append(cbei.getProcessId()).append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append(cbei.getSubComponent()).append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append(cbei.getThreadId()).append("</td>").append(newLine);
            } else {
                buffer.append("<td align=").append(this.getAlign()).append(">").append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append("</td>").append(newLine);
            }
            CBESituation sit = cbe.getSituation();
            if (sit != null) {
                buffer.append("<td align=").append(this.getAlign()).append(">").append(sit.getCategoryName()).append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append(sit.getReasoningScope()).append("</td>").append(newLine);
            } else {
                buffer.append("<td align=").append(this.getAlign()).append(">").append("</td>").append(newLine).append("<td align=").append(this.getAlign()).append(">").append("</td>").append(newLine);
            }
            Iterator iterator = cbe.getExtendedProperties().iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (obj == null || !(obj instanceof CBEDefaultElement)) continue;
                CBEDefaultElement ev = (CBEDefaultElement)obj;
                buffer.append("<td align=").append(this.getAlign()).append(">").append(ev.getName()).append("</td>").append(newLine);
            }
            buffer.append("</tr>").append(newLine);
            boolean bl = color = !color;
        }
        buffer.append("</table>").append(newLine);
    }

    protected void printColumnsHeader(StringBuffer buffer) {
        buffer.append("<tr>").append(newLine).append("<th align=").append(this.getAlign()).append(">").append("msg").append("</th>").append(newLine).append("<th align=").append(this.getAlign()).append(">").append("creationTime").append("</th>").append(newLine).append("<th align=").append(this.getAlign()).append(">").append("elapsedTime").append("</th>").append(newLine).append("<th align=").append(this.getAlign()).append(">").append("globalInstanceId").append("</th>").append(newLine).append("<th align=").append(this.getAlign()).append(">").append("localInstanceId").append("</th>").append(newLine).append("<th align=").append(this.getAlign()).append(">").append("priority").append("</th>").append(newLine).append("<th align=").append(this.getAlign()).append(">").append("repeatCount").append("</th>").append(newLine).append("<th align=").append(this.getAlign()).append(">").append("severity").append("</th>").append(newLine).append("<th align=").append(this.getAlign()).append(">").append("version").append("</th>").append(newLine).append("<th align=").append(this.getAlign()).append(">").append("sequenceNumber").append("</th>").append(newLine).append("<th align=").append(this.getAlign()).append(">").append("sourceComponentId_application").append("</th>").append(newLine).append("<th align=").append(this.getAlign()).append(">").append("sourceComponentId_component").append("</th>").append(newLine).append("<th align=").append(this.getAlign()).append(">").append("sourceComponentId_componentIdType").append("</th>").append(newLine).append("<th align=").append(this.getAlign()).append(">").append("sourceComponentId_executionEnvironment").append("</th>").append(newLine).append("<th align=").append(this.getAlign()).append(">").append("sourceComponentId_instanceId").append("</th>").append(newLine).append("<th align=").append(this.getAlign()).append(">").append("sourceComponentId_location").append("</th>").append(newLine).append("<th align=").append(this.getAlign()).append(">").append("sourceComponentId_locationType").append("</th>").append(newLine).append("<th align=").append(this.getAlign()).append(">").append("sourceComponentId_processId").append("</th>").append(newLine).append("<th align=").append(this.getAlign()).append(">").append("sourceComponentId_subComponent").append("</th>").append(newLine).append("<th align=").append(this.getAlign()).append(">").append("sourceComponentId_threadId").append("</th>").append(newLine).append("<th align=").append(this.getAlign()).append(">").append("situation_categoryName").append("</th>").append(newLine).append("<th align=").append(this.getAlign()).append(">").append("situation_reasoningScope").append("</th>").append(newLine).append("<th align=").append(this.getAlign()).append(">").append("extendedProperties_name").append("</th>").append(newLine).append("</tr>").append(newLine);
    }

    private List getSelectionAgents(Object object) {
        ArrayList<Object> agentList = new ArrayList<Object>();
        if (object instanceof TRCMonitor) {
            TRCMonitor mon = (TRCMonitor)object;
            Iterator nodes = mon.getNodes().iterator();
            while (nodes.hasNext()) {
                TRCNode node = (TRCNode)nodes.next();
                Iterator processes = node.getProcessProxies().iterator();
                while (processes.hasNext()) {
                    TRCProcessProxy proces = (TRCProcessProxy)processes.next();
                    Iterator agents = proces.getAgentProxies().iterator();
                    while (agents.hasNext()) {
                        TRCAgentProxy ag = (TRCAgentProxy)agents.next();
                        if (ag.getType() == null || !ag.getType().equals("Logging")) continue;
                        agentList.add(ag);
                    }
                }
            }
        } else if (object instanceof TRCNode) {
            TRCNode node = (TRCNode)object;
            Iterator processes = node.getProcessProxies().iterator();
            while (processes.hasNext()) {
                TRCProcessProxy proces = (TRCProcessProxy)processes.next();
                Iterator agents = proces.getAgentProxies().iterator();
                while (agents.hasNext()) {
                    TRCAgentProxy ag = (TRCAgentProxy)agents.next();
                    if (ag.getType() == null || !ag.getType().equals("Logging")) continue;
                    agentList.add(ag);
                }
            }
        } else if (object instanceof TRCProcessProxy) {
            TRCProcessProxy proces = (TRCProcessProxy)object;
            Iterator agents = proces.getAgentProxies().iterator();
            while (agents.hasNext()) {
                TRCAgentProxy ag = (TRCAgentProxy)agents.next();
                if (ag.getType() == null || !ag.getType().equals("Logging")) continue;
                agentList.add(ag);
            }
        } else if (object instanceof TRCAgentProxy && ((TRCAgentProxy)object).getType() != null && ((TRCAgentProxy)object).getType().equals("Logging")) {
            agentList.add(object);
        }
        return agentList;
    }
}

