/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.log.views.internal.reports;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.trace.ui.internal.reports.HTMLTraceStatReportWizard;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.extension.IExportViewer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.log.views.internal.LogViewsMessages;
import org.eclipse.tptp.platform.log.views.internal.reports.ReportHTMLLogWizardSelectionPage;
import org.eclipse.tptp.platform.log.views.internal.util.RecordTableElement;
import org.eclipse.tptp.platform.log.views.internal.views.LogContentProvider;
import org.eclipse.tptp.platform.log.views.internal.views.LogPaneTreeViewer;
import org.eclipse.tptp.platform.log.views.internal.views.LogViewer;
import org.eclipse.tptp.platform.log.views.internal.views.RecordPaneContentProvider;

public class ReportHTMLLogWizard
extends HTMLTraceStatReportWizard {
    protected ReportHTMLLogWizardSelectionPage selectionPage;
    protected List cbeList;
    protected RecordPaneContentProvider propertiesContentProvider;

    public ReportHTMLLogWizard() {
        this.setWindowTitle(LogViewsMessages._146);
    }

    protected void addReportPages() throws Exception {
        super.addReportPages();
        this.addPage((IWizardPage)this.selectionPage);
    }

    protected void initPages() {
        super.initPages();
        Object sel = this.getSelection().getFirstElement();
        if (sel == null || !(sel instanceof LogViewer)) {
            return;
        }
        Viewer[] viewers = ((LogViewer)sel).getExportViewer();
        if (viewers != null && viewers.length > 0 && viewers[0] != null && viewers[0] instanceof LogPaneTreeViewer && viewers[1] != null && viewers[1] instanceof TableViewer) {
            this.cbeList = ((LogContentProvider)((LogPaneTreeViewer)viewers[0]).getContentProvider()).getCachedElements();
            this.propertiesContentProvider = (RecordPaneContentProvider)((TableViewer)viewers[1]).getContentProvider();
            this.selectionPage = new ReportHTMLLogWizardSelectionPage("selectionPage", ((LogContentProvider)((LogPaneTreeViewer)viewers[0]).getContentProvider()).getTotalPages());
            this.selectionPage.setTitle(TraceMessages._14);
            this.selectionPage.setDescription(LogViewsMessages._147);
        }
    }

    public boolean canFinish() {
        boolean canFinish = super.canFinish();
        canFinish = canFinish && this.selectionPage.isPageComplete();
        return canFinish;
    }

    protected boolean export(IExportViewer viewer, String fileName) {
        if (fileName == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)LogViewsMessages._44, (String)TraceMessages._6);
            return false;
        }
        OutputStreamWriter writer = null;
        try {
            File file = new File(fileName);
            if (file.isDirectory()) {
                MessageDialog.openError((Shell)this.getShell(), (String)LogViewsMessages._44, (String)TraceMessages._7);
                return false;
            }
            FileOutputStream outputStream = new FileOutputStream(file.toString(), false);
            writer = new OutputStreamWriter((OutputStream)outputStream, "UTF8");
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
            return false;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.printHeader());
        buffer.append(this.printTitle(((LogViewer)viewer).getPartName()));
        this.printContent(buffer, (LogViewer)viewer);
        buffer.append(this.printFooter());
        try {
            writer.write(buffer.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    protected void printContent(StringBuffer buffer, LogViewer viewer) {
        int s = this.cbeList.size();
        if (s <= 0) {
            return;
        }
        this.printColumnsHeader(this.propertiesContentProvider.getElements(this.cbeList.get(0)), buffer);
        short option = this.selectionPage.getOption();
        Viewer[] viewers = viewer.getExportViewer();
        switch (option) {
            case 2: {
                this.cbeList = ((LogContentProvider)((LogPaneTreeViewer)viewers[0]).getContentProvider()).getCachedElements();
                this.printDetails(this.cbeList, buffer, 0, this.cbeList.size());
                break;
            }
            case 3: {
                this.cbeList = ((LogContentProvider)((LogPaneTreeViewer)viewers[0]).getContentProvider()).getPageList(((LogPaneTreeViewer)viewers[0]).getInput());
                this.printDetails(this.cbeList, buffer, 0, this.cbeList.size());
                break;
            }
            case 4: {
                this.cbeList = ((LogContentProvider)((LogPaneTreeViewer)viewers[0]).getContentProvider()).getPageList(((LogPaneTreeViewer)viewers[0]).getInput());
                IStructuredSelection sel = (IStructuredSelection)((LogPaneTreeViewer)viewers[0]).getSelection();
                Object[] properties = null;
                boolean color = true;
                Iterator iter = sel.iterator();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    if (element == null || (properties = this.propertiesContentProvider.getElements(element)) == null || properties.length <= 0) continue;
                    this.printLine(properties, buffer, color);
                    boolean bl = color = !color;
                }
                break;
            }
            case 5: {
                this.cbeList = ((LogContentProvider)((LogPaneTreeViewer)viewers[0]).getContentProvider()).getCachedElements();
                int lower = this.selectionPage.getLowerBound();
                int upper = this.selectionPage.getUpperBound();
                int startPos = (lower - 1) * LogContentProvider.PAGE_SIZE;
                int endPos = Math.min((upper - 1) * LogContentProvider.PAGE_SIZE, this.cbeList.size());
                this.printDetails(this.cbeList, buffer, startPos, endPos);
            }
        }
        buffer.append("</table>").append(newLine);
    }

    protected void printDetails(List recordList, StringBuffer buffer, int lowerBound, int upperBound) {
        boolean color = true;
        Object[] properties = null;
        int i = lowerBound;
        while (i < upperBound) {
            properties = this.propertiesContentProvider.getElements(this.cbeList.get(i));
            this.printLine(properties, buffer, color);
            color = !color;
            ++i;
        }
    }

    protected void printColumnsHeader(Object[] table, StringBuffer buffer) {
        buffer.append("<table border=0 cellspacing=2 cellpadding=2 WIDTH=\"100%\">").append(newLine);
        buffer.append("<tr>").append(newLine);
        int l = table.length;
        int idx = 0;
        while (idx < l) {
            String columnName = ((RecordTableElement)table[idx]).getName();
            if (columnName.indexOf("<") == 0) {
                columnName = "&lt;" + columnName;
            } else if (columnName.indexOf(">") == 0) {
                columnName = "&gt;" + columnName;
            }
            buffer.append("<th align=").append(this.getAlign()).append(">").append(columnName).append("</th>").append(newLine);
            ++idx;
        }
        buffer.append("</tr>").append(newLine);
    }

    protected void printLine(Object[] table, StringBuffer buffer, boolean color) {
        int l = table.length;
        if (color) {
            buffer.append("<tr BGCOLOR=\"#ffffbb\">").append(newLine);
        } else {
            buffer.append("<tr>").append(newLine);
        }
        int idx = 0;
        while (idx < l) {
            String columnValue = ((RecordTableElement)table[idx]).getValue();
            buffer.append("<td align=").append(this.getAlign()).append(">").append(columnValue).append("</td>").append(newLine);
            ++idx;
        }
        buffer.append("</tr>").append(newLine);
    }

    public boolean isAvailable(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        Object sel = ((StructuredSelection)selection).getFirstElement();
        if (!(sel instanceof IExportViewer)) {
            return false;
        }
        if (!(sel instanceof LogViewer)) {
            return false;
        }
        Viewer[] viewers = ((IExportViewer)sel).getExportViewer();
        if (viewers == null) {
            return false;
        }
        int idx = 0;
        while (idx < viewers.length) {
            if (!(viewers[idx] instanceof LogPaneTreeViewer) && !(viewers[idx] instanceof TableViewer)) {
                return false;
            }
            ++idx;
        }
        return true;
    }
}

