/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.log.views.internal.reports;

import org.eclipse.hyades.uml2sd.util.SDMessages;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tptp.platform.log.views.internal.LogViewsMessages;

public class ReportHTMLLogWizardSelectionPage
extends WizardPage {
    private Button allPages;
    private Button currentPage;
    private Button selection;
    private Button pageRange;
    private Text fromPage;
    private Text toPage;
    private int size;
    private final short FROM = 0;
    private final short TO = 1;
    private int fromValue = -1;
    private int toValue = -1;
    private SelectionListener selectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            ReportHTMLLogWizardSelectionPage.this.setErrorMessage(null);
            if (ReportHTMLLogWizardSelectionPage.this.currentPage.getSelection() || ReportHTMLLogWizardSelectionPage.this.allPages.getSelection() || ReportHTMLLogWizardSelectionPage.this.selection.getSelection()) {
                ReportHTMLLogWizardSelectionPage.this.fromPage.setEnabled(false);
                ReportHTMLLogWizardSelectionPage.this.toPage.setEnabled(false);
            } else {
                ReportHTMLLogWizardSelectionPage.this.fromPage.setEnabled(true);
                ReportHTMLLogWizardSelectionPage.this.toPage.setEnabled(true);
            }
            ReportHTMLLogWizardSelectionPage.this.setPageComplete(ReportHTMLLogWizardSelectionPage.this.validatePage());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            ReportHTMLLogWizardSelectionPage.this.setErrorMessage(null);
            ReportHTMLLogWizardSelectionPage.this.setPageComplete(ReportHTMLLogWizardSelectionPage.this.validateRange());
        }
    };
    public static final short ALL = 2;
    public static final short CURRENT = 3;
    public static final short SELECTION = 4;
    public static final short RANGE = 5;

    public ReportHTMLLogWizardSelectionPage(String name, int size) {
        super(name);
        this.size = size;
    }

    public void createControl(Composite parent) {
        Composite options = new Composite(parent, 0);
        options.setLayoutData((Object)new GridData());
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        options.setLayout((Layout)layout);
        this.createSpace(options);
        Label label = new Label(options, 0);
        label.setText(LogViewsMessages._148);
        label.setLayoutData((Object)this.createGridData());
        this.createSpace(options);
        this.allPages = new Button(options, 16);
        this.allPages.setText(SDMessages._108);
        this.allPages.setLayoutData((Object)this.createGridData());
        this.allPages.addSelectionListener(this.selectionListener);
        this.currentPage = new Button(options, 16);
        this.currentPage.setText(LogViewsMessages._152);
        this.currentPage.setLayoutData((Object)this.createGridData());
        this.currentPage.setEnabled(true);
        this.currentPage.setSelection(true);
        this.currentPage.addSelectionListener(this.selectionListener);
        this.selection = new Button(options, 16);
        this.selection.setText(LogViewsMessages._149);
        this.selection.setLayoutData((Object)this.createGridData());
        this.selection.addSelectionListener(this.selectionListener);
        this.pageRange = new Button(options, 16);
        this.pageRange.setText(SDMessages._103);
        this.pageRange.setLayoutData((Object)new GridData());
        this.pageRange.addSelectionListener(this.selectionListener);
        this.fromPage = new Text(options, 2052);
        this.fromPage.setData((Object)new Integer(0));
        GridData data = new GridData();
        data.widthHint = 100;
        this.fromPage.setLayoutData((Object)data);
        this.fromPage.setEnabled(false);
        Label labelTo = new Label(options, 0x1000000);
        labelTo.setText(SDMessages._105);
        this.toPage = new Text(options, 2052);
        this.toPage.setData((Object)new Integer(1));
        data = new GridData();
        data.widthHint = 100;
        this.toPage.setLayoutData((Object)data);
        this.toPage.setEnabled(false);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Widget widget = e.widget;
                ReportHTMLLogWizardSelectionPage.this.setErrorMessage(null);
                if (widget instanceof Text && widget.getData() != null && widget.getData() instanceof Integer) {
                    switch (((Integer)widget.getData()).shortValue()) {
                        case 0: {
                            ReportHTMLLogWizardSelectionPage.this.setPageComplete(ReportHTMLLogWizardSelectionPage.this.validateLowerLimit());
                            break;
                        }
                        case 1: {
                            ReportHTMLLogWizardSelectionPage.this.setPageComplete(ReportHTMLLogWizardSelectionPage.this.validateUpperLimit());
                        }
                    }
                }
            }
        };
        this.fromPage.addModifyListener(listener);
        this.toPage.addModifyListener(listener);
        this.toPage.addSelectionListener(this.selectionListener);
        this.setControl((Control)options);
    }

    public short getOption() {
        if (this.allPages.getSelection()) {
            return 2;
        }
        if (this.currentPage.getSelection()) {
            return 3;
        }
        if (this.selection.getSelection()) {
            return 4;
        }
        if (this.pageRange.getSelection()) {
            return 5;
        }
        return -1;
    }

    public int getLowerBound() {
        if (this.pageRange.getSelection()) {
            return this.fromValue;
        }
        return -1;
    }

    public int getUpperBound() {
        if (this.pageRange.getSelection()) {
            return this.toValue;
        }
        return -1;
    }

    private GridData createGridData() {
        GridData data = new GridData(4);
        data.horizontalSpan = 4;
        data.grabExcessHorizontalSpace = true;
        return data;
    }

    private void createSpace(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("");
        label.setLayoutData((Object)this.createGridData());
    }

    private boolean validatePage() {
        if (this.currentPage.getSelection() || this.allPages.getSelection() || this.selection.getSelection()) {
            return true;
        }
        return this.validateRange();
    }

    private boolean validateRange() {
        return this.validateLowerLimit() && this.validateUpperLimit();
    }

    private boolean validateLowerLimit() {
        if (this.fromPage.getText().trim().length() == 0) {
            this.setPageComplete(false);
            return false;
        }
        try {
            this.fromValue = Integer.parseInt(this.fromPage.getText());
            if (this.fromValue < 1 || this.fromValue > this.size) {
                this.setErrorMessage(NLS.bind((String)LogViewsMessages._151, (Object[])new Object[]{"1", "" + this.size}));
                this.setPageComplete(false);
                return false;
            }
            this.setErrorMessage(null);
        }
        catch (Exception exception) {
            this.setErrorMessage(NLS.bind((String)LogViewsMessages._153, (Object[])new Object[]{"1", "" + this.size}));
            this.setPageComplete(false);
            return false;
        }
        try {
            this.toValue = Integer.parseInt(this.toPage.getText());
            if (this.toValue < 1 || this.toValue > this.size) {
                this.setErrorMessage(NLS.bind((String)LogViewsMessages._151, (Object[])new Object[]{"1", "" + this.size}));
                this.setPageComplete(false);
                return false;
            }
            if (this.fromValue > this.toValue) {
                this.setErrorMessage(NLS.bind((String)LogViewsMessages._150, (Object)("" + this.toValue)));
                this.setPageComplete(false);
                return false;
            }
        }
        catch (Exception exception) {
            this.setPageComplete(false);
            return false;
        }
        this.setPageComplete(true);
        return true;
    }

    private boolean validateUpperLimit() {
        if (this.toPage.getText().trim().length() == 0) {
            this.setPageComplete(false);
            return false;
        }
        try {
            this.toValue = Integer.parseInt(this.toPage.getText());
            if (this.toValue < 1 || this.toValue > this.size) {
                this.setErrorMessage(NLS.bind((String)LogViewsMessages._151, (Object[])new Object[]{"1", "" + this.size}));
                this.setPageComplete(false);
                return false;
            }
            this.setErrorMessage(null);
        }
        catch (Exception exception) {
            this.setErrorMessage(NLS.bind((String)LogViewsMessages._153, (Object[])new Object[]{"1", "" + this.size}));
            this.setPageComplete(false);
            return false;
        }
        try {
            this.fromValue = Integer.parseInt(this.fromPage.getText());
            if (this.fromValue < 1 || this.fromValue > this.size) {
                this.setErrorMessage(NLS.bind((String)LogViewsMessages._151, (Object[])new Object[]{"1", "" + this.size}));
                this.setPageComplete(false);
                return false;
            }
            this.setErrorMessage(null);
            if (this.fromValue > this.toValue) {
                this.setErrorMessage(NLS.bind((String)LogViewsMessages._154, (Object)("" + this.fromValue)));
                this.setPageComplete(false);
                return false;
            }
        }
        catch (Exception exception) {
            this.setPageComplete(false);
            return false;
        }
        this.setPageComplete(true);
        return true;
    }
}

