/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.log.views.internal.reports;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.extension.IExportViewer;
import org.eclipse.hyades.ui.internal.util.UIMessages;
import org.eclipse.hyades.ui.internal.wizard.LocationPage;
import org.eclipse.hyades.ui.report.ReportGeneratorWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.log.views.internal.LogViewsPlugin;
import org.eclipse.tptp.platform.log.views.internal.util.CbeEmfUtility;

public class ReportXMLLogWizard
extends ReportGeneratorWizard {
    protected String FILE_EXTENSION = "xml";
    private LocationPage locationPage;

    public ReportXMLLogWizard() {
        this.setWindowTitle(LogViewsPlugin.getString("21"));
    }

    public boolean isAvailable(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        Object object = ((StructuredSelection)selection).getFirstElement();
        if (object == null) {
            return false;
        }
        if (object instanceof IExportViewer && (object = ((IExportViewer)object).getModelObject()) == null) {
            return false;
        }
        if (object instanceof CorrelationContainerProxy) {
            return true;
        }
        if (object instanceof TRCMonitor) {
            TRCMonitor mon = (TRCMonitor)object;
            Iterator nodes = mon.getNodes().iterator();
            while (nodes.hasNext()) {
                TRCNode node = (TRCNode)nodes.next();
                Iterator processes = node.getProcessProxies().iterator();
                while (processes.hasNext()) {
                    TRCProcessProxy proces = (TRCProcessProxy)processes.next();
                    Iterator agents = proces.getAgentProxies().iterator();
                    while (agents.hasNext()) {
                        TRCAgentProxy ag = (TRCAgentProxy)agents.next();
                        if (ag.getType() == null || !ag.getType().equals("Logging")) continue;
                        return true;
                    }
                }
            }
        } else if (object instanceof TRCNode) {
            TRCNode node = (TRCNode)object;
            Iterator processes = node.getProcessProxies().iterator();
            while (processes.hasNext()) {
                TRCProcessProxy proces = (TRCProcessProxy)processes.next();
                Iterator agents = proces.getAgentProxies().iterator();
                while (agents.hasNext()) {
                    TRCAgentProxy ag = (TRCAgentProxy)agents.next();
                    if (ag.getType() == null || !ag.getType().equals("Logging")) continue;
                    return true;
                }
            }
        } else if (object instanceof TRCProcessProxy) {
            TRCProcessProxy proces = (TRCProcessProxy)object;
            Iterator agents = proces.getAgentProxies().iterator();
            while (agents.hasNext()) {
                TRCAgentProxy ag = (TRCAgentProxy)agents.next();
                if (ag.getType() == null || !ag.getType().equals("Logging")) continue;
                return true;
            }
        } else if (object instanceof TRCAgentProxy && ((TRCAgentProxy)object).getType() != null && ((TRCAgentProxy)object).getType().equals("Logging")) {
            return true;
        }
        return false;
    }

    protected void initPages() {
        this.locationPage = new LocationPage("location", this.adjustLocation());
        this.locationPage.setTitle(TraceMessages._14);
        this.locationPage.setDescription(TraceMessages._15);
        this.locationPage.setFileExtension(this.FILE_EXTENSION);
    }

    protected IStructuredSelection adjustLocation() {
        IResource res;
        IContainer parent;
        IStructuredSelection structuredSelection = this.getSelection();
        Object selection = structuredSelection.getFirstElement();
        if (selection instanceof IResource && (parent = (res = (IResource)selection).getParent()) != null && parent.exists()) {
            structuredSelection = new StructuredSelection((Object)parent);
        }
        return structuredSelection;
    }

    public IFile generate(IProgressMonitor monitor) throws Exception {
        Object object = ((StructuredSelection)this.getSelection()).getFirstElement();
        if (object == null) {
            return null;
        }
        monitor.beginTask("", 4);
        IFile reportFile = this.getReportFile();
        monitor.worked(1);
        this.export(object, reportFile.getLocation().toOSString());
        monitor.worked(1);
        reportFile.getProject().refreshLocal(2, null);
        monitor.done();
        return reportFile;
    }

    private IFile getReportFile() {
        IFile file = null;
        IPath path = this.locationPage.getContainerFullPath();
        IContainer res = this.createContainer(path);
        path = new Path(this.locationPage.getFileName());
        file = res.getFile(path);
        return file;
    }

    protected void addReportPages() throws Exception {
        this.addPage((IWizardPage)this.locationPage);
    }

    public boolean canFinish() {
        return this.locationPage.getItemName().length() > 0 && this.locationPage.getContainerFullPath() != null;
    }

    private IContainer createContainer(IPath path) {
        IFolder container = null;
        IWorkspace workbench = ResourcesPlugin.getWorkspace();
        int segCount = path.segmentCount();
        int idx = 0;
        while (idx < segCount) {
            if (idx == 0) {
                IProject project = workbench.getRoot().getProject(path.uptoSegment(idx + 1).toString());
                if (project == null || !project.exists()) {
                    try {
                        project.create(null);
                    }
                    catch (Exception e) {
                        UIPlugin.getDefault().log((Throwable)e);
                        e.printStackTrace();
                    }
                }
                try {
                    project.open(null);
                }
                catch (Exception exception) {}
                container = project;
            } else {
                IFolder folder = workbench.getRoot().getFolder(path.uptoSegment(idx + 1));
                if (folder == null || !folder.exists()) {
                    try {
                        folder.create(false, true, null);
                    }
                    catch (Exception e) {
                        UIPlugin.getDefault().log((Throwable)e);
                        e.printStackTrace();
                    }
                }
                container = folder;
            }
            ++idx;
        }
        try {
            container.getProject().refreshLocal(2, null);
        }
        catch (CoreException exc) {
            UIPlugin.getDefault().log((Throwable)exc);
            exc.printStackTrace();
        }
        return container;
    }

    protected void export(Object sel, String fileName) {
        ArrayList recordList = new ArrayList();
        Hashtable associationMap = new Hashtable();
        Object selection = sel;
        if (sel instanceof IExportViewer) {
            selection = ((IExportViewer)sel).getModelObject();
        }
        if (selection instanceof CorrelationContainerProxy) {
            CorrelationContainerProxy proxy = (CorrelationContainerProxy)selection;
            Object[] agentProxys = proxy.getCorrelatedAgents().toArray();
            int i = 1;
            while (i < agentProxys.length) {
                this.createAssociationsMap((TRCAgentProxy)agentProxys[i], associationMap, recordList);
                ++i;
            }
        }
        this.createAssociationsMap(selection, associationMap, recordList);
        this.saveToFile(fileName, recordList, null, associationMap);
    }

    private void createAssociationsMap(Object resource, Hashtable associationMap, List recordList) {
        int i;
        CorrelationEngine ce;
        if (resource instanceof CorrelationContainerProxy && (ce = ((CorrelationContainerProxy)resource).getCorrelationEngine()) != null) {
            AssociationEngine asoE = CbeEmfUtility.createAssociationEngine(ce);
            associationMap.put((CorrelationContainerProxy)resource, asoE);
            return;
        }
        if (resource instanceof TRCMonitor) {
            Object[] nodes = ((TRCMonitor)resource).getNodes().toArray();
            i = 0;
            while (i < nodes.length) {
                this.createAssociationsMap((TRCNode)nodes[i], associationMap, recordList);
                ++i;
            }
        }
        if (resource instanceof TRCNode) {
            Object[] processes = ((TRCNode)resource).getProcessProxies().toArray();
            i = 0;
            while (i < processes.length) {
                this.createAssociationsMap((TRCProcessProxy)processes[i], associationMap, recordList);
                ++i;
            }
        }
        if (resource instanceof TRCProcessProxy) {
            Object[] agents = ((TRCProcessProxy)resource).getAgentProxies().toArray();
            i = 0;
            while (i < agents.length) {
                this.createAssociationsMap((TRCAgentProxy)agents[i], associationMap, recordList);
                ++i;
            }
        }
        if (resource instanceof TRCAgentProxy) {
            Object[] correlationContainerProxys = ((TRCAgentProxy)resource).getInternalCorrelations().toArray();
            recordList.addAll(((TRCAgentProxy)resource).getAgent().getDefaultEvents());
            i = 0;
            while (i < correlationContainerProxys.length) {
                this.createAssociationsMap((CorrelationContainerProxy)correlationContainerProxys[i], associationMap, recordList);
                ++i;
            }
        }
    }

    protected void saveToFile(String filePath, List events, int[] index, Hashtable associationMap) {
        File path = new File(new File(filePath).getParent());
        path.mkdirs();
        PrintWriter file = null;
        try {
            file = new PrintWriter(new FileOutputStream(filePath));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        if (file == null) {
            return;
        }
        file.println("<CommonBaseEvents xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd\">");
        if (associationMap != null && associationMap.size() > 0) {
            Iterator i = associationMap.values().iterator();
            while (i.hasNext()) {
                AssociationEngine asoE = (AssociationEngine)i.next();
                String asoEString = EventFormatter.toCanonicalXMLString((AssociationEngine)asoE);
                file.println(asoEString);
            }
        }
        if (events != null) {
            int idx = 0;
            while (idx < events.size()) {
                Object event = events.get(idx);
                if (event instanceof CBECommonBaseEvent) {
                    CBECommonBaseEvent cbe = (CBECommonBaseEvent)event;
                    CommonBaseEvent cbe2 = CbeEmfUtility.convertCbe(cbe, associationMap);
                    String cbeString = EventFormatter.toCanonicalXMLString((CommonBaseEvent)cbe2);
                    file.println(cbeString);
                }
                ++idx;
            }
        }
        file.println("</CommonBaseEvents>");
        file.close();
    }

    public boolean performFinish() {
        IFile reportFile = this.getReportFile();
        if (reportFile.exists() && !MessageDialog.openQuestion((Shell)this.getShell(), (String)UIMessages._158, (String)UIMessages._159)) {
            return false;
        }
        return super.performFinish();
    }
}

