/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.log.views.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.hyades.models.hierarchy.util.IFilterElement;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.log.views.internal.LogViewsMessages;
import org.eclipse.tptp.platform.log.views.internal.LogViewsPlugin;
import org.eclipse.tptp.platform.log.views.internal.util.ColumnData;
import org.eclipse.tptp.platform.log.views.internal.util.FilterElementModifier;
import org.eclipse.tptp.platform.log.views.internal.util.FilterList;
import org.eclipse.tptp.platform.log.views.internal.util.FilterListContentProvider;
import org.eclipse.tptp.platform.log.views.internal.util.FilterListLabelProvider;
import org.eclipse.tptp.platform.log.views.internal.util.FilterTableElement;
import org.eclipse.tptp.platform.log.views.internal.util.LogAnalyzerUI;
import org.eclipse.tptp.platform.log.views.internal.util.LogViewsContextIds;
import org.eclipse.ui.PlatformUI;

public class CBEAdvFilterUI
extends LogAnalyzerUI {
    private Composite result;
    private Button _addBtn;
    private Button _editBtn;
    private Button _removeBtn;
    private Button _upBtn;
    private Button _downBtn;
    private CheckboxTableViewer _tableViewer;
    private Table _table;
    private FilterList _filterList;
    private static String[] tableColumnProperties = new String[]{"attribute_combo", "operator_combo", "value_string"};
    public static String[] fAttributeValues;
    public static String[] fOperatorValues;
    private int iType;

    static {
        fOperatorValues = new String[]{LogViewsMessages._104, LogViewsMessages._105, LogViewsMessages._106, LogViewsMessages._107};
    }

    public CBEAdvFilterUI(int type, IPreferenceStore store) {
        super(store);
        this.iType = type;
    }

    public Control createControl(Composite parent) {
        return this.createControl(parent, LogViewsMessages._111);
    }

    public Control createControl(Composite parent, String contentLabel) {
        this.initializeAttribute();
        this.result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 0;
        this.result.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        this.result.setLayoutData((Object)data);
        Label _contentLabel = new Label(this.result, 0);
        _contentLabel.setText(contentLabel);
        data = new GridData();
        data.horizontalSpan = 2;
        _contentLabel.setLayoutData((Object)data);
        Composite tableGroup = new Composite(this.result, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        tableGroup.setLayout((Layout)layout);
        data = GridUtil.createFill();
        data.heightHint = 180;
        tableGroup.setLayoutData((Object)data);
        this.initializeTable(tableGroup);
        Composite btnGroup = new Composite(this.result, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        btnGroup.setLayout((Layout)layout);
        btnGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        Composite addGroup = new Composite(btnGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        addGroup.setLayout((Layout)layout);
        addGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        this._addBtn = new Button(addGroup, 8);
        this._addBtn.setText(LogViewsMessages._112);
        this._addBtn.setToolTipText(LogViewsMessages._113);
        this._addBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editBtn = new Button(addGroup, 8);
        this._editBtn.setText(LogViewsMessages._114);
        this._editBtn.setToolTipText(LogViewsMessages._115);
        this._editBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._removeBtn = new Button(addGroup, 8);
        this._removeBtn.setText(LogViewsMessages._116);
        this._removeBtn.setToolTipText(LogViewsMessages._117);
        this._removeBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        Composite moveGroup = new Composite(btnGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        moveGroup.setLayout((Layout)layout);
        moveGroup.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._upBtn = new Button(moveGroup, 8);
        this._upBtn.setText(LogViewsMessages._98);
        this._upBtn.setToolTipText(LogViewsMessages._99);
        this._upBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._downBtn = new Button(moveGroup, 8);
        this._downBtn.setText(LogViewsMessages._100);
        this._downBtn.setToolTipText(LogViewsMessages._101);
        this._downBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._editBtn.setEnabled(false);
        this._removeBtn.setEnabled(false);
        this._upBtn.setEnabled(false);
        this._downBtn.setEnabled(false);
        this._upBtn.addSelectionListener((SelectionListener)this);
        this._downBtn.addSelectionListener((SelectionListener)this);
        this._addBtn.addSelectionListener((SelectionListener)this);
        this._editBtn.addSelectionListener((SelectionListener)this);
        this._removeBtn.addSelectionListener((SelectionListener)this);
        this._table.addSelectionListener((SelectionListener)this);
        this.setContextHelpIds();
        return this.result;
    }

    protected void initializeTable(Composite parent) {
        this.createTable(parent);
        this._tableViewer = new CheckboxTableViewer(this._table);
        this.createColumns();
        this._tableViewer.setContentProvider((IContentProvider)new FilterListContentProvider(this._tableViewer));
        this._tableViewer.setLabelProvider((IBaseLabelProvider)new FilterListLabelProvider());
        this._filterList = new FilterList((TableViewer)this._tableViewer);
        this._tableViewer.setInput((Object)this._filterList);
        CellEditor[] editors = new CellEditor[this._table.getColumnCount()];
        editors[0] = new ComboBoxCellEditor((Composite)this._table, fAttributeValues);
        editors[1] = new ComboBoxCellEditor((Composite)this._table, fOperatorValues);
        editors[2] = new TextCellEditor((Composite)this._table);
        this._tableViewer.setCellEditors(editors);
        FilterElementModifier modifier = new FilterElementModifier(this._tableViewer);
        this._tableViewer.setCellModifier((ICellModifier)modifier);
        this._tableViewer.setColumnProperties(tableColumnProperties);
    }

    private void setContextHelpIds() {
        switch (this.iType) {
            case 0: {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._addBtn, LogViewsContextIds.ACTLOG_VIEW_DIALOG_ADV_FILTER_ADD);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._editBtn, LogViewsContextIds.ACTLOG_VIEW_DIALOG_ADV_FILTER_EDIT);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._removeBtn, LogViewsContextIds.ACTLOG_VIEW_DIALOG_ADV_FILTER_REMOVE);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._upBtn, LogViewsContextIds.ACTLOG_VIEW_DIALOG_ADV_FILTER_UP);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._downBtn, LogViewsContextIds.ACTLOG_VIEW_DIALOG_ADV_FILTER_DOWN);
                break;
            }
            case 1: {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._addBtn, LogViewsContextIds.LOGINTER_VIEW_DIALOG_SEARCH_ADD);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._editBtn, LogViewsContextIds.LOGINTER_VIEW_DIALOG_SEARCH_EDIT);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._removeBtn, LogViewsContextIds.LOGINTER_VIEW_DIALOG_SEARCH_REMOVE);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._upBtn, LogViewsContextIds.LOGINTER_VIEW_DIALOG_SEARCH_MOVE_UP);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._downBtn, LogViewsContextIds.LOGINTER_VIEW_DIALOG_SEARCH_MOVE_DOWN);
                break;
            }
            case 2: {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._addBtn, LogViewsContextIds.ACTLOG_VIEW_DIALOG_SEARCH_ADD);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._editBtn, LogViewsContextIds.ACTLOG_VIEW_DIALOG_SEARCH_EDIT);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._removeBtn, LogViewsContextIds.ACTLOG_VIEW_DIALOG_SEARCH_REMOVE);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._upBtn, LogViewsContextIds.ACTLOG_VIEW_DIALOG_SEARCH_MOVE_UP);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._downBtn, LogViewsContextIds.ACTLOG_VIEW_DIALOG_SEARCH_MOVE_DOWN);
            }
        }
    }

    private void createTable(Composite parent) {
        this._table = new Table(parent, 68354);
        this._table.setLinesVisible(true);
        this._table.setLayoutData((Object)GridUtil.createFill());
    }

    private void createColumns() {
        TableLayout layout = new TableLayout();
        this._table.setLayout((Layout)layout);
        this._table.setHeaderVisible(true);
        String[] headers = new String[]{LogViewsMessages._108, LogViewsMessages._109, LogViewsMessages._110};
        ColumnLayoutData[] layouts = new ColumnLayoutData[]{new ColumnPixelData(120, true), new ColumnPixelData(70, true), new ColumnPixelData(130, true)};
        TableColumn[] columns = new TableColumn[headers.length];
        int i = 0;
        while (i < headers.length) {
            layout.addColumnData(layouts[i]);
            TableColumn tc = new TableColumn(this._table, 0, i);
            tc.setResizable(layouts[i].resizable);
            tc.setText(headers[i]);
            columns[i] = tc;
            ++i;
        }
    }

    public void initializeFilters(String advFilters) {
        List _tableElements = FilterTableElement.createFilterTableElementFromString(advFilters);
        this.populateTable(_tableElements);
    }

    public void initializeValues(boolean defaultValue) {
        IPreferenceStore store = LogViewsPlugin.getDefault().getPreferenceStore();
        String advFilters = defaultValue ? store.getDefaultString("pd_adv_filter_options") : store.getString("pd_adv_filter_options");
        this.initializeFilters(advFilters);
    }

    public void initializeAttribute() {
        int i;
        IPreferenceStore store = LogViewsPlugin.getDefault().getPreferenceStore();
        String pdFilters = store.getString("pd_sort_log_options");
        ArrayList<String> tempList = new ArrayList<String>();
        ArrayList list = ColumnData.createColumnDataFromString(pdFilters);
        if (list != null) {
            i = 0;
            while (i < list.size()) {
                ColumnData data = (ColumnData)list.get(i);
                tempList.add(data.name());
                ++i;
            }
        }
        Collections.sort(tempList);
        if (tempList.size() > 0) {
            fAttributeValues = new String[tempList.size()];
            i = 0;
            while (i < tempList.size()) {
                CBEAdvFilterUI.fAttributeValues[i] = (String)tempList.get(i);
                ++i;
            }
        }
    }

    public boolean hasFilterChanged() {
        int s = this._filterList.getFilters().size();
        String filtersString = FilterTableElement.getPreferenceString(this._filterList.getFilters().toArray(new IFilterElement[s]));
        return !this._store.getString("pd_adv_filter_options").equals(filtersString);
    }

    public boolean storeValues(String preferenceProperty) {
        return FilterTableElement.saveFilters(this._filterList.getFilters(), preferenceProperty, this._store);
    }

    public boolean storeValues() {
        return FilterTableElement.saveFilters(this._filterList.getFilters(), "pd_adv_filter_options", this._store);
    }

    public Composite getControl() {
        return this.result;
    }

    protected void enableButtons() {
        int selection = this._table.getSelectionIndex();
        int selectionCount = this._table.getSelectionCount();
        this._removeBtn.setEnabled(this._filterList.getSize() > 0 && selection != -1);
        this._editBtn.setEnabled(this._filterList.getSize() > 0 && selection != -1);
        this._upBtn.setEnabled(selection > 0 && selectionCount == 1);
        this._downBtn.setEnabled(selection >= 0 && selection < this._table.getItemCount() - 1 && selectionCount == 1);
    }

    protected void selectTableItem(Table table, int selection) {
        table.setFocus();
        table.setSelection(selection);
        table.showSelection();
    }

    private void showEditDialog(String title, String attribute, String operator, String value) {
        EditDialog dialog = new EditDialog(this.result.getShell(), title, attribute, operator, value);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            if (attribute == null) {
                FilterTableElement elem = new FilterTableElement(dialog.attribute(), dialog.operator(), dialog.value());
                this._filterList.add(elem, this._filterList.getSize());
                elem.setParent(this._filterList);
                this._tableViewer.refresh();
                this.selectTableItem(this._table, this._filterList.getSize() - 1);
            } else {
                int idx = this._table.getSelectionIndex();
                if (idx != -1) {
                    FilterTableElement sel = (FilterTableElement)this._filterList.getElementAt(idx);
                    sel.setAttribute(dialog.attribute());
                    sel.setOperator(dialog.operator());
                    sel.setValue(dialog.value());
                    this._tableViewer.refresh();
                }
            }
        }
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this._addBtn) {
            this.showEditDialog(LogViewsMessages._118, null, null, null);
            this.enableButtons();
        } else if (event.widget == this._editBtn) {
            int idx = this._table.getSelectionIndex();
            if (idx != -1) {
                FilterTableElement sel = (FilterTableElement)this._filterList.getElementAt(idx);
                String attribute = sel.getAttribute();
                String operator = sel.getOperator();
                String value = sel.getValue();
                this.showEditDialog(LogViewsMessages._119, attribute, operator, value);
            }
        } else {
            if (event.widget == this._table) {
                this.enableButtons();
                return;
            }
            if (event.widget == this._removeBtn) {
                int selection = this._table.getSelectionIndex();
                this._filterList.removeElements(this._table.getSelectionIndices());
                this._tableViewer.refresh();
                int size = this._filterList.getSize();
                if (size > 0) {
                    if (selection > 0 && selection < size) {
                        this.selectTableItem(this._table, selection - 1);
                    } else {
                        this.selectTableItem(this._table, 0);
                    }
                }
                this.enableButtons();
            } else if (event.widget == this._upBtn) {
                this._tableViewer.refresh();
                int selection = this._table.getSelectionIndex();
                if (selection > 0) {
                    FilterTableElement sel = (FilterTableElement)this._filterList.getElementAt(selection);
                    FilterTableElement previous = (FilterTableElement)this._filterList.getElementAt(selection - 1);
                    String attribute = sel.getAttribute();
                    String operator = sel.getOperator();
                    String value = sel.getValue();
                    sel.setAttribute(previous.getAttribute());
                    sel.setOperator(previous.getOperator());
                    sel.setValue(previous.getValue());
                    previous.setAttribute(attribute);
                    previous.setOperator(operator);
                    previous.setValue(value);
                    this.selectTableItem(this._table, selection - 1);
                }
                this._tableViewer.refresh();
                this.enableButtons();
            } else if (event.widget == this._downBtn) {
                this._tableViewer.refresh();
                int selection = this._table.getSelectionIndex();
                if (selection < this._table.getItemCount() - 1) {
                    FilterTableElement sel = (FilterTableElement)this._filterList.getElementAt(selection);
                    FilterTableElement next = (FilterTableElement)this._filterList.getElementAt(selection + 1);
                    String attribute = sel.getAttribute();
                    String operator = sel.getOperator();
                    String value = sel.getValue();
                    sel.setAttribute(next.getAttribute());
                    sel.setOperator(next.getOperator());
                    sel.setValue(next.getValue());
                    next.setAttribute(attribute);
                    next.setOperator(operator);
                    next.setValue(value);
                    this.selectTableItem(this._table, selection + 1);
                }
                this._tableViewer.refresh();
                this.enableButtons();
            }
        }
    }

    protected void populateTable(List tableElems) {
        this._filterList.removeAll();
        if (tableElems != null) {
            int idx = 0;
            while (idx < tableElems.size()) {
                FilterTableElement elem = (FilterTableElement)tableElems.get(idx);
                this._filterList.add(elem, this._filterList.getSize());
                elem.setParent(this._filterList);
                ++idx;
            }
            if (tableElems.size() > 0) {
                this._table.select(0);
            }
        }
        this._tableViewer.refresh();
        this.enableButtons();
    }

    protected void populateList() {
    }

    public Button getAddBtn() {
        return this._addBtn;
    }

    public Button getRemoveBtn() {
        return this._removeBtn;
    }

    public FilterList getFilterList() {
        return this._filterList;
    }

    class EditDialog
    extends Dialog {
        private String _attribute;
        private String _operator;
        private String _value;
        private Combo _AttributeText;
        private Combo _OperatorText;
        private Text _ValueText;
        private String _title;

        public EditDialog(Shell shell, String title, String attribute, String operator, String value) {
            super(shell);
            this._attribute = attribute;
            this._operator = operator;
            this._value = value;
            this._title = title;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this._title);
        }

        public void attribute(String attribute) {
            this._attribute = attribute;
        }

        public String attribute() {
            return this._attribute;
        }

        public void operator(String operator) {
            this._operator = operator;
        }

        public String operator() {
            return this._operator;
        }

        public void value(String value) {
            this._value = value;
        }

        public String value() {
            return this._value;
        }

        protected Control createDialogArea(Composite parent) {
            Composite dlgArea = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            dlgArea.setLayout((Layout)layout);
            GridData data = GridUtil.createFill();
            data.widthHint = 400;
            dlgArea.setLayoutData((Object)data);
            Label label = new Label(dlgArea, 0);
            label.setText(LogViewsMessages._108);
            this._AttributeText = new Combo(dlgArea, 2056);
            this._AttributeText.setLayoutData((Object)GridUtil.createHorizontalFill());
            int i = 0;
            while (i < fAttributeValues.length) {
                this._AttributeText.add(fAttributeValues[i]);
                ++i;
            }
            label = new Label(dlgArea, 0);
            label.setText(LogViewsMessages._109);
            this._OperatorText = new Combo(dlgArea, 2056);
            this._OperatorText.setLayoutData((Object)GridUtil.createHorizontalFill());
            i = 0;
            while (i < fOperatorValues.length) {
                this._OperatorText.add(fOperatorValues[i]);
                ++i;
            }
            label = new Label(dlgArea, 0);
            label.setText(LogViewsMessages._110);
            this._ValueText = new Text(dlgArea, 2048);
            this._ValueText.setLayoutData((Object)GridUtil.createHorizontalFill());
            this._AttributeText.select(0);
            this._OperatorText.select(0);
            if (this._attribute != null) {
                this._AttributeText.setText(this._attribute);
            }
            if (this._operator != null) {
                this._OperatorText.setText(this._operator);
            }
            if (this._value != null) {
                this._ValueText.setText(this._value);
            }
            this._AttributeText.setFocus();
            this.setContextHelpId((Control)dlgArea);
            return dlgArea;
        }

        protected void okPressed() {
            this._attribute = this._AttributeText.getText().trim();
            this._operator = this._OperatorText.getText().trim();
            this._value = this._ValueText.getText();
            super.okPressed();
        }

        private void setContextHelpId(Control control) {
            switch (CBEAdvFilterUI.this.iType) {
                case 0: {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp(control, LogViewsContextIds.ACTLOG_VIEW_DIALOG_FILTER);
                    break;
                }
                case 1: {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp(control, LogViewsContextIds.LOGINTER_VIEW_DIALOG_FILTER);
                    break;
                }
                case 2: {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp(control, LogViewsContextIds.ACTLOG_VIEW_DIALOG_SEARCH);
                }
            }
        }
    }
}

