/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.log.views.internal.util;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.tptp.platform.log.views.internal.LogViewsMessages;
import org.eclipse.tptp.platform.log.views.internal.LogViewsPlugin;
import org.eclipse.tptp.platform.log.views.internal.util.ColumnData;
import org.eclipse.tptp.platform.log.views.internal.util.LogAnalyzerUI;

public class CBEFilterUI
extends LogAnalyzerUI {
    private Composite result;

    public CBEFilterUI(IPreferenceStore store) {
        super(store);
    }

    public Control createControl(Composite parent) {
        this.result = (Composite)super.createControl(parent);
        this.setDescription(LogViewsMessages._32);
        this.populateList();
        return this.result;
    }

    protected void populateList() {
        this._pdList.removeAll();
        int idx = 0;
        while (idx < this._pdData.size()) {
            ColumnData data = (ColumnData)this._pdData.get(idx);
            TableItem item = new TableItem(this._pdList, 0);
            item.setText(data.name());
            item.setChecked(data.visible());
            item.setData((Object)data);
            ++idx;
        }
        if (this._pdList.getItemCount() > 0) {
            this._pdList.select(0);
            this._moveDown.setEnabled(true);
        }
    }

    public void initializeValues(boolean defaultValue) {
        IPreferenceStore store = LogViewsPlugin.getDefault().getPreferenceStore();
        String pdFilters = defaultValue ? store.getDefaultString("pd_filter_options") : store.getString("pd_filter_options");
        this.createColumnDataFromString(pdFilters, this._pdData);
        this.populateList();
    }

    public boolean storeValues() {
        this.loadColumnData("pd_filter_options", this._pdData, this._pdList, this._store);
        this._pdData.clear();
        return this.hasFilterChanged();
    }

    public String getFilterPreferenceString() {
        return this.getPreferenceString(this._pdData, this._pdList);
    }

    public boolean hasFilterChanged() {
        return !this._store.getString("pd_filter_options").equals(this.getFilterPreferenceString());
    }

    public boolean validate() {
        return this.validate(this._pdList);
    }

    private boolean validate(Table _list) {
        boolean valid = false;
        int idx = 0;
        while (idx < _list.getItemCount()) {
            TableItem item = _list.getItem(idx);
            if (item.getChecked()) {
                return true;
            }
            ++idx;
        }
        return valid;
    }

    public Composite getControl() {
        return this.result;
    }
}

