/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.log.views.internal.util;

import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tptp.platform.log.views.internal.LogViewsMessages;
import org.eclipse.tptp.platform.log.views.internal.LogViewsPlugin;
import org.eclipse.tptp.platform.log.views.internal.util.CBEFilterUI;
import org.eclipse.tptp.platform.log.views.internal.util.LogViewsContextIds;
import org.eclipse.tptp.platform.log.views.internal.util.RecordChangeEvent;
import org.eclipse.ui.PlatformUI;

public class ColumnsDialog
extends Dialog
implements SelectionListener {
    private CBEFilterUI _options;
    private static final int _restoreDefaultsButtonId = 1025;
    private String _title;

    public ColumnsDialog(Shell shell, String windowTitle, Image windowImage) {
        super(shell);
        this._title = windowTitle;
        ColumnsDialog.setDefaultImage((Image)windowImage);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this._title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 15;
        result.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        data.heightHint = 400;
        data.widthHint = 370;
        result.setLayoutData((Object)data);
        this._options = new CBEFilterUI(LogViewsPlugin.getDefault().getPreferenceStore());
        this._options.createControl(result);
        this._options.initializeValues(false);
        this._options.addListener(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)result, LogViewsContextIds.ACTLOG_VIEW_DIALOG_FILTER);
        return result;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, LogViewsMessages._37, false);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this._options.initializeValues(true);
            this.removeMessageOnColumnsDialog();
            this.getButton(0).setEnabled(true);
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void okPressed() {
        boolean flag = this._options.validate();
        if (flag) {
            this._options.removeListener(this);
        }
        if (this._options.hasFilterChanged()) {
            LogViewsPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(1, (Object)this));
        }
        this._options.storeValues();
        if (flag) {
            super.okPressed();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Widget widget = e.widget;
        if (widget == this._options._unselAll) {
            int idx = 0;
            while (idx < this._options._pdList.getItemCount()) {
                TableItem item = this._options._pdList.getItem(idx);
                item.setChecked(false);
                ++idx;
            }
            this.showMessageOnColumnsDialog();
            this.getButton(0).setEnabled(false);
        } else if (widget == this._options._selAll) {
            int idx = 0;
            while (idx < this._options._pdList.getItemCount()) {
                TableItem item = this._options._pdList.getItem(idx);
                item.setChecked(true);
                ++idx;
            }
            this.removeMessageOnColumnsDialog();
            this.getButton(0).setEnabled(true);
        } else if (widget == this._options._pdList) {
            if (this.ifAllItemsIsUncheckedOnColumnsDialog()) {
                this.showMessageOnColumnsDialog();
                this.getButton(0).setEnabled(false);
            } else {
                this.removeMessageOnColumnsDialog();
                this.getButton(0).setEnabled(true);
            }
        }
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected void showMessageOnColumnsDialog() {
        Color RED = null;
        Display display = Display.getDefault();
        RED = new Color((Device)display, new RGB(255, 0, 0));
        this._options._labelMessage.setVisible(true);
        this._options._labelMessage.setForeground(RED);
        this._options._labelMessage.setText(LogViewsMessages._92);
    }

    protected void removeMessageOnColumnsDialog() {
        this._options._labelMessage.setVisible(false);
    }

    protected boolean ifAllItemsIsUncheckedOnColumnsDialog() {
        int idx = 0;
        while (idx < this._options._pdList.getItemCount()) {
            if (this._options._pdList.getItem(idx).getChecked()) {
                return false;
            }
            ++idx;
        }
        return true;
    }
}

