/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.log.views.internal.util;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.hierarchy.util.IFilterElement;
import org.eclipse.tptp.platform.log.views.internal.LogViewsMessages;
import org.eclipse.tptp.platform.log.views.internal.util.FeatureNode;
import org.eclipse.tptp.platform.log.views.internal.util.LogUtil;
import org.eclipse.tptp.platform.log.views.internal.util.TerminalNode;

public class RecordFilterSearchUtil {
    private HashMap _methods = new HashMap();
    private ElementFilter _filter;
    private Collator collator = Collator.getInstance();
    static /* synthetic */ Class class$0;

    public RecordFilterSearchUtil() {
        this._filter = new ElementFilter();
    }

    public void dispose() {
        this._methods.clear();
    }

    public boolean isAdvFilterApply(EObject logRecord, IFilterElement[] filterTableElements) {
        if (filterTableElements == null) {
            return true;
        }
        EClass eClass = logRecord.eClass();
        EList attributes = eClass.getEAllAttributes();
        boolean filterApply = true;
        int l = filterTableElements.length;
        int idx = 0;
        while (idx < l) {
            IFilterElement filterTableElement = filterTableElements[idx];
            String elemAttribute = filterTableElement.getAttribute().toLowerCase();
            EAttribute attribute = this.findAttributeInList(elemAttribute, attributes);
            filterApply = attribute != null ? (filterApply &= this.matchFilter(logRecord, attribute, filterTableElement)) : (filterApply &= this.checkChildren(logRecord, elemAttribute, filterTableElement));
            ++idx;
        }
        return filterApply;
    }

    public EAttribute findAttributeInList(String name, EList attributeList) {
        int i = 0;
        while (i < attributeList.size()) {
            EAttribute attr = (EAttribute)attributeList.get(i);
            if (attr.getName().toLowerCase().equals(name)) {
                return attr;
            }
            ++i;
        }
        return null;
    }

    private boolean matchFilter(EObject logRecord, EAttribute attribute, IFilterElement filterTableElement) {
        Object value = logRecord.eGet((EStructuralFeature)attribute);
        String filterTableValue = filterTableElement.getValue();
        String filterTableOperator = filterTableElement.getOperator();
        if (value == null) {
            value = new String("");
        }
        if (filterTableValue == null) {
            filterTableValue = new String("");
        }
        if (attribute.getName().equals("creationTime")) {
            value = LogUtil.formatCreationTime((CBECommonBaseEvent)logRecord);
        }
        if (filterTableOperator.equals(LogViewsMessages._104)) {
            return this.checkEqual(value.toString(), filterTableValue);
        }
        if (filterTableOperator.equals(LogViewsMessages._105)) {
            return this.checkNotEqual(value.toString(), filterTableValue);
        }
        if (filterTableOperator.equals(LogViewsMessages._106)) {
            return this.checkLargerThan(value.toString(), filterTableValue);
        }
        if (filterTableOperator.equals(LogViewsMessages._107)) {
            return this.checkSmallerThan(value.toString(), filterTableValue);
        }
        return false;
    }

    private boolean checkChildren(EObject logRecord, String elemAttribute, IFilterElement filterTableElement) {
        boolean filterApply = true;
        boolean match = true;
        if (logRecord instanceof EObject && logRecord.eClass().getEPackage() == CBEPackage.eINSTANCE) {
            match = false;
            EClass eClass = logRecord.eClass();
            Iterator iter = eClass.getEAllStructuralFeatures().iterator();
            while (iter.hasNext()) {
                Object refs;
                EStructuralFeature feature = (EStructuralFeature)iter.next();
                if (!(feature instanceof EReference) || feature.getFeatureID() == 3) {
                    if (!(feature instanceof EAttribute) || !feature.isMany()) continue;
                    Class clazz = feature.getEType().getInstanceClass();
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz == clazz2) continue;
                }
                if ((refs = logRecord.eGet(feature, true)) == null) continue;
                if (refs instanceof EList) {
                    if (((EList)refs).size() <= 0) continue;
                    Object[] object = ((EList)refs).toArray();
                    int i = 0;
                    while (i < object.length) {
                        int matchAttri = this.containsAttribute((EObject)object[i], elemAttribute, filterTableElement);
                        if (matchAttri > 0) {
                            match = true;
                            filterApply |= matchAttri == 1;
                        }
                        ++i;
                    }
                    continue;
                }
                int matchAttri = this.containsAttribute((EObject)refs, elemAttribute, filterTableElement);
                if (matchAttri <= 0) continue;
                match = true;
                filterApply &= matchAttri == 1;
            }
        } else if (logRecord instanceof FeatureNode) {
            EStructuralFeature feature = ((FeatureNode)logRecord).getFeature();
            EObject cElem = ((FeatureNode)logRecord).getElement();
            match = false;
            if (feature instanceof EReference) {
                if (feature.isMany()) {
                    EList refs = (EList)cElem.eGet(feature, true);
                    if (refs.size() > 0) {
                        Object[] object = refs.toArray();
                        int i = 0;
                        while (i < object.length) {
                            int matchAttri = this.containsAttribute((EObject)object[i], elemAttribute, filterTableElement);
                            if (matchAttri > 0) {
                                match = true;
                                filterApply |= matchAttri == 1;
                            }
                            ++i;
                        }
                    }
                } else {
                    Object ref = cElem.eGet(feature, true);
                    int matchAttri = this.containsAttribute((EObject)ref, elemAttribute, filterTableElement);
                    if (matchAttri > 0) {
                        match = true;
                        filterApply &= matchAttri == 1;
                    }
                }
            }
        } else {
            boolean cfr_ignored_0 = logRecord instanceof TerminalNode;
        }
        return match && filterApply;
    }

    private int containsAttribute(EObject eObject, String elemAttribute, IFilterElement filterTableElement) {
        EClass eClass = eObject.eClass();
        EList attributes = eClass.getEAllAttributes();
        EAttribute attribute = this.findAttributeInList(elemAttribute, attributes);
        if (attribute != null) {
            return this.matchFilter(eObject, attribute, filterTableElement) ? 1 : -1;
        }
        return 0;
    }

    private boolean checkEqual(String recordValue, String filterValue) {
        try {
            float recordFloat = Float.parseFloat(recordValue);
            float filterFloat = Float.parseFloat(filterValue);
            return recordFloat == filterFloat;
        }
        catch (NumberFormatException numberFormatException) {
            return this._filter.match(recordValue, filterValue);
        }
    }

    private boolean checkNotEqual(String recordValue, String filterValue) {
        return !this.checkEqual(recordValue, filterValue);
    }

    private boolean checkLargerThan(String recordValue, String filterValue) {
        try {
            float recordFloat = Float.parseFloat(recordValue);
            float filterFloat = Float.parseFloat(filterValue);
            return recordFloat > filterFloat;
        }
        catch (NumberFormatException numberFormatException) {
            int value = this.collator.compare(recordValue, filterValue);
            return value > 0;
        }
    }

    private boolean checkSmallerThan(String recordValue, String filterValue) {
        return !this.checkLargerThan(recordValue, filterValue) && !this.checkEqual(recordValue, filterValue);
    }

    public class ElementFilter {
        protected String _pattern;
        protected String _prefix = "";
        protected String _suffix = "";
        protected ArrayList _textList;
        protected boolean _caseSensitive = true;
        protected boolean _exactMatch;
        protected boolean _noPattern = true;

        private void setPattern(String pattern, boolean caseSensitive) {
            this._caseSensitive = caseSensitive;
            this._pattern = this._caseSensitive ? pattern : pattern.toLowerCase();
            this._noPattern = pattern == "*" || pattern == "";
            this._exactMatch = this._pattern.indexOf("*") == -1;
            StringTokenizer st = new StringTokenizer(this._pattern, "*");
            this._textList = new ArrayList();
            while (st.hasMoreTokens()) {
                this._textList.add(st.nextToken());
            }
            if (this._pattern.startsWith("*")) {
                this._prefix = "";
            } else if (this._textList.size() > 0) {
                this._prefix = (String)this._textList.get(0);
                this._textList.remove(0);
            }
            if (this._pattern.endsWith("*")) {
                this._suffix = "";
            } else if (this._textList.size() > 0) {
                this._suffix = (String)this._textList.get(this._textList.size() - 1);
                this._textList.remove(this._textList.size() - 1);
            }
        }

        public boolean match(String recordValue, String userValue) {
            this.setPattern(userValue, true);
            boolean flag = true;
            String compareText = "";
            if (this._noPattern) {
                return true;
            }
            compareText = recordValue;
            if (!this._caseSensitive) {
                compareText = compareText.toLowerCase();
            }
            if (this._exactMatch) {
                return RecordFilterSearchUtil.this.collator.compare(compareText, this._prefix) == 0;
            }
            if (this._prefix != "") {
                flag = compareText.startsWith(this._prefix);
            }
            if (flag && this._suffix != "") {
                flag = compareText.endsWith(this._suffix);
            }
            if (flag) {
                int k = 0;
                while (k < this._textList.size()) {
                    String str1 = (String)this._textList.get(k);
                    int index = compareText.indexOf(str1);
                    if (index == -1) {
                        flag = false;
                        break;
                    }
                    compareText = compareText.substring(index + str1.length());
                    ++k;
                }
            }
            return flag;
        }
    }
}

