/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.log.views.internal.util;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;

public class Splitter
extends Composite {
    protected SplitterLayout fLayout;
    protected int fDirection;
    protected int fGap = 3;
    protected boolean fResizable;

    public Splitter(Composite parent, int direction, boolean resizable) {
        super(parent, 0);
        this.fDirection = direction;
        this.fResizable = resizable;
        this.fLayout = new SplitterLayout();
        this.setLayout(this.fLayout);
    }

    public Sash addSash() {
        final Sash sash = new Sash((Composite)this, this.fDirection == 256 ? 512 : 256);
        if (this.fResizable) {
            sash.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    Splitter.this.dragSash(sash, event);
                }
            });
        }
        return sash;
    }

    void dragSash(Sash sash, Event event) {
        Rectangle clientArea = this.getClientArea();
        Control[] children = this.getChildren();
        int count = children.length;
        if (event.detail == 1) {
            int limit = 20;
            if (this.fDirection == 256) {
                event.x = Math.min(Math.max(limit, event.x), clientArea.width - limit);
            } else {
                event.y = Math.min(Math.max(limit, event.y), clientArea.height - limit);
            }
            return;
        }
        Rectangle bounds = event.getBounds();
        int ix = -1;
        int i = 0;
        while (i < count) {
            Control child = children[i];
            if (child == sash) {
                ix = i;
                break;
            }
            ++i;
        }
        Control w1 = children[ix - 1];
        Rectangle b1 = w1.getBounds();
        Rectangle oldBounds = sash.getBounds();
        Control w2 = children[ix + 1];
        Rectangle b2 = w2.getBounds();
        if (this.fDirection == 256) {
            int shift = bounds.x - oldBounds.x;
            b1.width += shift;
            b2.x += shift;
            b2.width -= shift;
            if (b1.width < 20 || b2.width < 20) {
                return;
            }
        } else {
            int shift = bounds.y - oldBounds.y;
            b1.height += shift;
            b2.y += shift;
            b2.height -= shift;
            if (b1.height < 20 || b2.height < 20) {
                return;
            }
        }
        w1.setBounds(b1.x, b1.y, b1.width, b1.height);
        sash.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
        w2.setBounds(b2.x, b2.y, b2.width, b2.height);
    }

    public void flipDirection() {
        this.fDirection = this.fDirection == 256 ? 512 : 256;
        Control[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            Control w = children[i];
            if (w instanceof Sash) {
                Sash s = this.addSash();
                s.moveAbove(w);
                w.dispose();
            } else {
                Point e = w.getSize();
                w.setSize(e.y, e.x);
            }
            ++i;
        }
    }

    public Point[] getSizes() {
        Control[] children = this.getChildren();
        Point[] p = new Point[children.length];
        int i = 0;
        while (i < children.length) {
            p[i] = children[i].getSize();
            ++i;
        }
        return p;
    }

    Weight getWeight(Control window) {
        Object data = window.getLayoutData();
        if (data instanceof Weight) {
            return (Weight)data;
        }
        Weight w = null;
        if (window instanceof Sash) {
            Point ee = window.computeSize(-1, -1, true);
            int e = this.fDirection == 256 ? ee.x : ee.y;
            w = new Weight(e, 0);
        } else {
            w = data instanceof Integer ? new Weight((Integer)data) : new Weight(50);
        }
        window.setLayoutData((Object)w);
        return w;
    }

    int getWindowSize(Control window, boolean flushCache) {
        int e;
        Point ee = window.getSize();
        int n = e = this.fDirection == 256 ? ee.x : ee.y;
        if (e == 0) {
            e = this.getWeight((Control)window).fSize;
        }
        return e;
    }

    void internalMaximize(Control w) {
        Layout layout = this.getLayout();
        boolean maximized = layout instanceof MaximizeLayout;
        Control[] ws = this.getChildren();
        int i = 0;
        while (i < ws.length) {
            if (ws[i] != w) {
                ws[i].setVisible(maximized);
            }
            ++i;
        }
        if (maximized) {
            w.setSize(((MaximizeLayout)layout).fOldSize);
            this.setLayout(this.fLayout);
        } else {
            this.setLayout(new MaximizeLayout(w));
        }
        w = this.getParent();
        if (w instanceof Splitter) {
            ((Splitter)w).internalMaximize((Control)this);
        } else {
            this.layout(true);
        }
    }

    boolean isFixed(Control window) {
        if (window instanceof Sash) {
            return true;
        }
        return this.getWeight((Control)window).fGrow <= 0;
    }

    public void maximize(Control w) {
        this.setRedraw(false);
        this.internalMaximize(w);
        this.setRedraw(true);
    }

    public void setSizes(Point[] sizes) {
        this.setRedraw(false);
        Control[] children = this.getChildren();
        int i = 0;
        while (i < sizes.length) {
            children[i].setSize(sizes[i]);
            ++i;
        }
        this.layout(true);
        this.setRedraw(true);
    }

    public static class Weight {
        public int fSize;
        public int fGrow;
        public int fShrink;

        public Weight(int size) {
            this.fSize = size;
            this.fGrow = 50;
            this.fShrink = 50;
        }

        public Weight(int size, int w) {
            this.fSize = size;
            this.fGrow = w;
            this.fShrink = w;
        }

        public Weight(int size, int g, int s) {
            this.fSize = size;
            this.fGrow = g;
            this.fShrink = s;
        }
    }

    public static class MaximizeLayout
    extends Layout {
        Control fChild;
        Point fOldSize;

        MaximizeLayout(Control w) {
            this.fChild = w;
            this.fOldSize = w.getSize();
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            return this.fChild.getSize();
        }

        protected void layout(Composite composite, boolean flushCache) {
            this.fChild.setBounds(composite.getClientArea());
        }
    }

    public class SplitterLayout
    extends Layout {
        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Control[] children = composite.getChildren();
            int max = 0;
            int total = 0;
            if (Splitter.this.fDirection == 256) {
                int i = 0;
                while (i < children.length) {
                    Point pt = children[i].computeSize(-1, -1, flushCache);
                    total += pt.x;
                    max = Math.max(max, pt.y);
                    ++i;
                }
                return new Point(total, max);
            }
            int i = 0;
            while (i < children.length) {
                Point pt = children[i].computeSize(-1, -1, flushCache);
                total += pt.y;
                max = Math.max(max, pt.x);
                ++i;
            }
            return new Point(max, total);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle clientArea = composite.getClientArea();
            Control[] children = composite.getChildren();
            int count = children.length;
            int newSize = Splitter.this.fDirection == 256 ? clientArea.width : clientArea.height;
            int totalSize = 0;
            int[] size = new int[count];
            int totalGrow = 0;
            int totalShrink = 0;
            int i = 0;
            while (i < count) {
                int e = Splitter.this.getWindowSize(children[i], flushCache);
                totalSize += e;
                size[i] = e;
                Weight w = Splitter.this.getWeight(children[i]);
                totalGrow += w.fGrow;
                totalShrink += w.fShrink;
                ++i;
            }
            int diff = newSize - totalSize;
            boolean allfixed = true;
            int total = 0;
            int i2 = 0;
            while (i2 < count) {
                int d;
                Weight w = Splitter.this.getWeight(children[i2]);
                if (diff > 0) {
                    if (w.fGrow > 0) {
                        d = diff * w.fGrow / totalGrow;
                        int n = i2;
                        size[n] = size[n] + d;
                        allfixed = false;
                    }
                } else if (w.fShrink > 0) {
                    d = diff * w.fShrink / totalShrink;
                    int n = i2;
                    size[n] = size[n] + d;
                    allfixed = false;
                }
                total += size[i2];
                ++i2;
            }
            if (!allfixed) {
                i2 = 0;
                while (total < newSize) {
                    if (!Splitter.this.isFixed(children[i2 % count])) {
                        int n = i2 % count;
                        size[n] = size[n] + 1;
                        ++total;
                    }
                    ++i2;
                }
            }
            if (Splitter.this.fDirection == 256) {
                int x = clientArea.x;
                int i3 = 0;
                while (i3 < count) {
                    children[i3].setBounds(x, clientArea.y, size[i3], clientArea.height);
                    x += size[i3];
                    ++i3;
                }
            } else {
                int y = clientArea.y;
                int i4 = 0;
                while (i4 < count) {
                    children[i4].setBounds(clientArea.x, y, clientArea.width, size[i4]);
                    y += size[i4];
                    ++i4;
                }
            }
        }
    }
}

