/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.log.views.internal.util;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.log.views.internal.LogViewsMessages;
import org.eclipse.tptp.platform.log.views.internal.util.LogViewsContextIds;
import org.eclipse.tptp.platform.log.views.internal.util.SymptomDBSelectionGroup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.eclipse.ui.dialogs.SelectionDialog;

public class SymptomDBSelectionDialog
extends SelectionDialog
implements ISelectionValidator,
Listener {
    private SymptomDBSelectionGroup group;
    private Label statusMessage;

    public SymptomDBSelectionDialog(Shell parentShell, String message) {
        this(parentShell, message, 0, 1);
    }

    public SymptomDBSelectionDialog(Shell parentShell, String message, int style, int type) {
        super(parentShell);
        this.setTitle(LogViewsMessages._42);
        if (message != null) {
            this.setMessage(message);
        } else {
            this.setMessage(LogViewsMessages._43);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control result = super.createButtonBar(parent);
        this.statusMessage.setForeground(this.statusMessage.getDisplay().getSystemColor(3));
        this.statusMessage.setText(LogViewsMessages._43);
        this.getOkButton().setEnabled(false);
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.group = new SymptomDBSelectionGroup(dialogArea, this, true);
        this.statusMessage = new Label(parent, 0);
        this.statusMessage.setLayoutData((Object)new GridData(1808));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialogArea, LogViewsContextIds.SYMDB_PREF_DATABASE_ADD_DIALOG);
        return dialogArea;
    }

    public void handleEvent(Event event) {
        if (this.statusMessage != null) {
            String errorMsg = this.isValid(this.group.getContainerFullPath());
            if (errorMsg == null || errorMsg.equals("")) {
                this.statusMessage.setText("");
                this.getOkButton().setEnabled(true);
            } else {
                this.statusMessage.setForeground(this.statusMessage.getDisplay().getSystemColor(3));
                this.statusMessage.setText(errorMsg);
                this.getOkButton().setEnabled(false);
            }
        }
    }

    public String isValid(Object selection) {
        IPath path = (IPath)selection;
        if (path == null) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource res = root.findMember(path);
        if (res != null && res instanceof IContainer) {
            return LogViewsMessages._43;
        }
        return null;
    }

    protected void okPressed() {
        ArrayList<IPath> chosenContainerPathList = new ArrayList<IPath>();
        chosenContainerPathList.add(this.group.getContainerFullPath());
        this.setResult(chosenContainerPathList);
        super.okPressed();
    }
}

