/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.log.views.internal.util;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.tptp.platform.log.views.internal.LogViewsMessages;
import org.eclipse.tptp.platform.log.views.internal.util.SymptomDBContentProvider;
import org.eclipse.tptp.platform.log.views.internal.util.SymptomDBDrillDownComposite;
import org.eclipse.tptp.platform.log.views.internal.util.SymptomDBLabelProvider;

public class SymptomDBSelectionGroup
extends Composite {
    private Listener listener;
    private Object selectedContainer;
    private TreeViewer treeViewer;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 250;
    private static final int SIZING_SELECTION_PANE_WIDTH = 250;

    public SymptomDBSelectionGroup(Composite parent, Listener listener, boolean allowNewContainerName) {
        this(parent, listener, allowNewContainerName, null);
    }

    public SymptomDBSelectionGroup(Composite parent, Listener listener, boolean allowNewContainerName, String message) {
        super(parent, 0);
        this.listener = listener;
        this.setFont(parent.getFont());
        this.createContents();
    }

    public void containerSelectionChanged(Object container) {
        this.selectedContainer = container;
        if (this.listener != null) {
            Event changeEvent = new Event();
            changeEvent.type = 13;
            changeEvent.widget = this;
            this.listener.handleEvent(changeEvent);
        }
    }

    public void createContents() {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        Label label = new Label((Composite)this, 64);
        label.setText(LogViewsMessages._41);
        label.setFont(this.getFont());
        new Label((Composite)this, 0);
        this.createTreeViewer();
    }

    protected void createTreeViewer() {
        SymptomDBDrillDownComposite drillDown = new SymptomDBDrillDownComposite(this, 2048);
        GridData spec = new GridData(1808);
        spec.widthHint = 250;
        spec.heightHint = 250;
        drillDown.setLayoutData(spec);
        this.treeViewer = new TreeViewer((Composite)drillDown, 0);
        drillDown.setChildTree(this.treeViewer);
        this.treeViewer.setContentProvider((IContentProvider)new SymptomDBContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new SymptomDBLabelProvider());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                SymptomDBSelectionGroup.this.containerSelectionChanged(selection.getFirstElement());
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (SymptomDBSelectionGroup.this.treeViewer.getExpandedState(item)) {
                        SymptomDBSelectionGroup.this.treeViewer.collapseToLevel(item, 1);
                    } else {
                        SymptomDBSelectionGroup.this.treeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
    }

    public IPath getContainerFullPath() {
        if (this.selectedContainer == null) {
            return null;
        }
        if (this.selectedContainer instanceof IResource) {
            return ((IResource)this.selectedContainer).getFullPath();
        }
        return new Path(this.selectedContainer.toString());
    }

    public void setInitialFocus() {
        this.treeViewer.getTree().setFocus();
    }

    public void setSelectedContainer(Object container) {
        this.selectedContainer = container;
        ArrayList<IContainer> itemsToExpand = new ArrayList<IContainer>();
        if (container instanceof IContainer) {
            IContainer parent = ((IContainer)container).getParent();
            while (parent != null) {
                itemsToExpand.add(0, parent);
                parent = parent.getParent();
            }
            this.treeViewer.setExpandedElements(itemsToExpand.toArray());
            this.treeViewer.setSelection((ISelection)new StructuredSelection(container), true);
        }
    }
}

