/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.log.views.internal.views;

import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.cbe.CBEDefaultEvent;
import org.eclipse.hyades.trace.ui.internal.util.HyperlinkText;
import org.eclipse.hyades.ui.internal.util.AnalysisHelper;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tptp.platform.log.views.internal.LogViewsMessages;
import org.eclipse.tptp.platform.log.views.internal.util.RecordTableElement;
import org.eclipse.ui.part.PageBook;

public class LogAnalysisPageBook
extends PageBook
implements ISelectionChangedListener {
    private CTabFolder tabFolder;
    private CTabItem detailsTabItem;
    private CTabItem analysisTabItem;
    private HyperlinkText detailsTabText;
    private HyperlinkText analysisTabText;
    private String resultString = "";
    private String detailsString = "";
    private final String LINESEPARATOR = System.getProperty("line.separator");

    public LogAnalysisPageBook(Composite parent, int style) {
        super(parent, style);
        this.populateUI();
    }

    public void populateUI() {
        this.tabFolder = new CTabFolder((Composite)this, 128);
        this.detailsTabText = new HyperlinkText((Composite)this.tabFolder, 842);
        this.detailsTabItem = new CTabItem(this.tabFolder, 0);
        this.detailsTabItem.setText(LogViewsMessages._30);
        this.detailsTabItem.setControl((Control)this.detailsTabText);
        this.analysisTabText = new HyperlinkText((Composite)this.tabFolder, 842);
        this.analysisTabItem = new CTabItem(this.tabFolder, 0);
        this.analysisTabItem.setText(LogViewsMessages._29);
        this.analysisTabItem.setControl((Control)this.analysisTabText);
        this.tabFolder.setSelection(this.detailsTabItem);
        this.showPage((Control)this.tabFolder);
    }

    public void setInputNull() {
        this.analysisTabText.setText("");
        this.analysisTabItem.setControl((Control)this.analysisTabText);
        this.detailsTabText.setText("");
        this.detailsTabItem.setControl((Control)this.detailsTabText);
        this.tabFolder.setSelection(this.detailsTabItem);
        this.showPage((Control)this.tabFolder);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object singleSelection = null;
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        singleSelection = ((IStructuredSelection)selection).getFirstElement();
        if (singleSelection != null) {
            if (singleSelection instanceof CBEDefaultEvent) {
                Object[] results;
                EList directivesList;
                this.resultString = AnalysisHelper.getInstance().isXMI((CBEDefaultEvent)singleSelection) ? ((directivesList = ((CBEDefaultEvent)singleSelection).getSymptoms()).isEmpty() ? (((CBEDefaultEvent)singleSelection).isAnalyzed() ? LogViewsMessages._31 : "") : AnalysisHelper.getInstance().formatSymptoms((List)directivesList)) : ((results = AnalysisHelper.getInstance().getResults((CBEDefaultEvent)singleSelection)) != null ? (results.length == 0 ? LogViewsMessages._31 : AnalysisHelper.getInstance().formatSymptoms(results)) : "");
            } else if (singleSelection instanceof RecordTableElement) {
                this.detailsString = this.replaceNewLineChars(((RecordTableElement)singleSelection).getValue());
                this.detailsTabItem.setText(String.valueOf(LogViewsMessages._30) + " " + ((RecordTableElement)singleSelection).getName());
            } else if (singleSelection instanceof EObject) {
                this.resultString = "";
            } else if (singleSelection instanceof Object[]) {
                this.detailsString = "";
                this.detailsTabItem.setText(LogViewsMessages._30);
                this.resultString = "";
            }
        }
        this.analysisTabItem.setControl((Control)this.analysisTabText);
        this.analysisTabText.setText(this.resultString);
        this.detailsTabText.setText(this.detailsString);
        this.detailsTabItem.setControl((Control)this.detailsTabText);
        this.showPage((Control)this.tabFolder);
    }

    private String replaceNewLineChars(String input) {
        StringBuffer analysisBuffer = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(input, "\r\n\f");
        while (tokens.hasMoreTokens()) {
            analysisBuffer.append(tokens.nextToken().trim());
            analysisBuffer.append(this.LINESEPARATOR);
        }
        return analysisBuffer.toString();
    }

    public void dispose() {
        if (this.analysisTabText != null) {
            this.analysisTabText.dispose();
        }
        if (this.detailsTabText != null) {
            this.detailsTabText.dispose();
        }
    }
}

