/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.log.views.internal.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.hyades.analysis.engine.ILogAnalyzer;
import org.eclipse.hyades.loaders.util.IPagingList;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.ui.internal.util.AnalysisHelper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.tptp.platform.log.views.internal.LogViewsMessages;
import org.eclipse.tptp.platform.log.views.internal.LogViewsPlugin;
import org.eclipse.tptp.platform.log.views.internal.util.LogViewsContextIds;
import org.eclipse.tptp.platform.log.views.internal.util.ProgressMonitorAdapter;
import org.eclipse.tptp.platform.log.views.internal.views.ExtensionPointHandler;
import org.eclipse.tptp.platform.log.views.internal.views.LogAnalyzerWrapper;
import org.eclipse.tptp.platform.log.views.internal.views.LogContentProvider;
import org.eclipse.tptp.platform.log.views.internal.views.LogPaneTreeViewer;
import org.eclipse.tptp.platform.log.views.internal.views.LogViewer;
import org.eclipse.tptp.platform.log.views.internal.views.LogViewerUI;
import org.eclipse.ui.PlatformUI;

public class LogPaneTreeViewer
extends TreeViewer {
    private LogViewerUI _logViewUI = null;
    private ExtensionPointHandler eph = ExtensionPointHandler.getExtensionPointHandler();
    private Collection _analyzedObjects;
    private ISelection sel;
    protected Action _updateAction;
    protected Action _analyzeAllAction;
    protected Action _analyzeAction;
    protected boolean _enableAnalyze = true;

    public LogPaneTreeViewer(LogViewerUI logViewUI, Composite parent, String role) {
        super(parent);
        this._logViewUI = logViewUI;
        this._updateAction = new UpdateAction(LogViewsPlugin.getResourceString(LogViewsMessages._103));
    }

    public void setMenuListener(IMenuListener menuListener) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(menuListener);
        Menu menu = menuMgr.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    public void addSelectionListener(SelectionListener listener) {
        ((Tree)this.getControl()).addSelectionListener(listener);
    }

    public void fillContextMenu(IMenuManager menu) {
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            this.updateMenu(menu, ((IStructuredSelection)selection).getFirstElement());
        }
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this._updateAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
    }

    public void updateMenu(IMenuManager menu, Object logObject) {
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            MenuManager manager = new MenuManager(LogViewsPlugin.getResourceString(LogViewsMessages._25));
            menu.add((IContributionItem)manager);
            this.fillMenu((IContributionManager)manager, logObject);
            menu.add((IContributionItem)new Separator());
            manager = new MenuManager(LogViewsPlugin.getResourceString(LogViewsMessages._26));
            menu.add((IContributionItem)manager);
            this.fillMenu((IContributionManager)manager);
        }
    }

    public void dispose() {
        List logAnalyzers = this.eph.getLogAnalyzers();
        Iterator iter = logAnalyzers.iterator();
        while (iter.hasNext()) {
            ILogAnalyzer element = ((ExtensionPointHandler.ConfigurationElement)iter.next()).getAnalyzer();
            element.unloadDatabase();
        }
    }

    public void resetAnalyzedObjects() {
        this._analyzedObjects = null;
    }

    public Collection getAnalyzedObjects() {
        if (this._analyzedObjects == null) {
            this._analyzedObjects = new HashSet();
        }
        return this._analyzedObjects;
    }

    private List getObjectsToAnalyze(boolean analyzeAll) {
        if (!analyzeAll) {
            ArrayList<Object> objectsToAnalyze = null;
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    LogPaneTreeViewer.this.sel = LogPaneTreeViewer.this.getSelection();
                }
            });
            if (this.sel instanceof IStructuredSelection) {
                Iterator iterator = ((IStructuredSelection)this.sel).iterator();
                Object object = null;
                objectsToAnalyze = new ArrayList<Object>();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (object == null || !(object instanceof CBECommonBaseEvent)) continue;
                    objectsToAnalyze.add(object);
                }
            }
            return objectsToAnalyze != null ? objectsToAnalyze : Collections.EMPTY_LIST;
        }
        return ((LogContentProvider)this.getContentProvider()).getCachedElements();
    }

    private void fillMenu(IContributionManager innerMgr) {
        innerMgr.removeAll();
        List logAnalyzers = this.eph.getLogAnalyzers();
        if (logAnalyzers != null) {
            Iterator iter = logAnalyzers.iterator();
            while (iter.hasNext()) {
                ExtensionPointHandler.ConfigurationElement config = (ExtensionPointHandler.ConfigurationElement)iter.next();
                ILogAnalyzer analyzer = config.getAnalyzer();
                this._analyzeAllAction = new AnalyzeAction(config.getName(), new LogAnalyzerWrapper(analyzer), true);
                innerMgr.add((IAction)this._analyzeAllAction);
            }
        }
    }

    private void fillMenu(IContributionManager innerMgr, Object logObject) {
        innerMgr.removeAll();
        List logAnalyzers = this.eph.getLogAnalyzer(logObject);
        if (logAnalyzers != null) {
            Iterator iter = logAnalyzers.iterator();
            while (iter.hasNext()) {
                ExtensionPointHandler.ConfigurationElement config = (ExtensionPointHandler.ConfigurationElement)iter.next();
                ILogAnalyzer analyzer = config.getAnalyzer();
                this._analyzeAction = new AnalyzeAction(config.getName(), new LogAnalyzerWrapper(analyzer), false);
                innerMgr.add((IAction)this._analyzeAction);
            }
        }
    }

    public Action get_analyzeAction() {
        return this._analyzeAction;
    }

    public Action get_analyzeAllAction() {
        return this._analyzeAllAction;
    }

    static /* synthetic */ List access$1(LogPaneTreeViewer logPaneTreeViewer, boolean bl) {
        return logPaneTreeViewer.getObjectsToAnalyze(bl);
    }

    class UpdateAction
    extends Action {
        public UpdateAction(String name) {
            super(name);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, LogViewsContextIds.ACTLOG_VIEW_POPUP_REFRESH);
        }

        public void run() {
            ((LogViewer)LogPaneTreeViewer.this._logViewUI.getViewerPage().getTraceViewer()).refresh();
        }
    }

    abstract class BasicLoadAction
    extends Action {
        private LogAnalyzerWrapper logAnalyzer = null;

        public BasicLoadAction(String label, LogAnalyzerWrapper logAnalyzer) {
            super(label);
            this.logAnalyzer = logAnalyzer;
        }

        public LogAnalyzerWrapper getLogAnalyzer() {
            return this.logAnalyzer;
        }

        public boolean isEnabled() {
            return true;
        }
    }

    class AnalyzeAction
    extends BasicLoadAction {
        boolean analyzeAll = false;
        boolean analyzeSelectionOnly = true;
        protected LogAnalyzerWrapper aLogAnalyzer;
        protected List result;

        public AnalyzeAction(String label, LogAnalyzerWrapper logAnalyzer) {
            super(label, logAnalyzer);
        }

        public AnalyzeAction(String label, LogAnalyzerWrapper logAnalyzer, boolean analyzeAll) {
            super(label, logAnalyzer);
            this.analyzeAll = analyzeAll;
        }

        public void run() {
            Job analyzeJob = new Job(this, LogViewsMessages._27){
                final /* synthetic */ AnalyzeAction this$1;
                {
                    this.this$1 = analyzeAction;
                }

                public IStatus run(IProgressMonitor m) {
                    ProgressMonitorAdapter monitor = new ProgressMonitorAdapter(m);
                    List listToAnalyze = LogPaneTreeViewer.access$1(AnalyzeAction.access$0(this.this$1), this.this$1.analyzeAll);
                    int size = listToAnalyze.size();
                    monitor.beginTask(LogViewsMessages._27, size > 100 ? 100 : size);
                    monitor.subTask(LogViewsPlugin.getResourceString(LogViewsMessages._28));
                    this.this$1.getLogAnalyzer().loadDatabase();
                    if (this.this$1.getLogAnalyzer().errorMsg() == null) {
                        if (this.this$1.result == null) {
                            this.this$1.result = new ArrayList<E>();
                        }
                        if (!((LogContentProvider)AnalyzeAction.access$0(this.this$1).getContentProvider()).isInputXMI(AnalyzeAction.access$0(this.this$1).getInput())) {
                            List events = ((LogContentProvider)AnalyzeAction.access$0(this.this$1).getContentProvider()).getCachedElements();
                            if (events instanceof IPagingList) {
                                AnalysisHelper.getInstance().setPagingList((IPagingList)events);
                            } else {
                                AnalysisHelper.getInstance().setPagingList(null);
                            }
                        }
                        this.this$1.getLogAnalyzer().analyze(listToAnalyze, this.this$1.result, monitor);
                    }
                    monitor.done();
                    return new Status(0, LogViewsPlugin.getPluginId(), 0, "", null);
                }
            };
            analyzeJob.addJobChangeListener(new IJobChangeListener(this){
                final /* synthetic */ AnalyzeAction this$1;
                {
                    this.this$1 = analyzeAction;
                }

                public void aboutToRun(IJobChangeEvent event) {
                }

                public void awake(IJobChangeEvent event) {
                }

                public void done(IJobChangeEvent event) {
                    if (this.this$1.getLogAnalyzer().errorMsg() != null) {
                        MessageDialog.openError((Shell)AnalyzeAction.access$0(this.this$1).getControl().getShell(), (String)LogViewsMessages._44, (String)this.this$1.getLogAnalyzer().errorMsg());
                    }
                    Display.getDefault().syncExec(new Runnable(this){
                        final /* synthetic */ 2 this$2;
                        {
                            this.this$2 = var1_1;
                        }

                        public void run() {
                            AnalyzeAction.access$0(2.access$0(this.this$2)).refresh();
                            if (((Tree)AnalyzeAction.access$0(2.access$0(this.this$2)).getControl()).getSelection().length > 0) {
                                Event selEvent = new Event();
                                selEvent.item = ((Tree)AnalyzeAction.access$0(2.access$0(this.this$2)).getControl()).getSelection()[0];
                                AnalyzeAction.access$0(2.access$0(this.this$2)).getControl().notifyListeners(13, selEvent);
                            }
                        }
                    });
                }

                public void running(IJobChangeEvent event) {
                }

                public void scheduled(IJobChangeEvent event) {
                }

                public void sleeping(IJobChangeEvent event) {
                }

                static /* synthetic */ AnalyzeAction access$0(2 var0) {
                    return var0.this$1;
                }
            });
            analyzeJob.schedule();
        }

        static /* synthetic */ LogPaneTreeViewer access$0(AnalyzeAction analyzeAction) {
            return analyzeAction.LogPaneTreeViewer.this;
        }
    }
}

