/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.log.views.internal.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.impl.CBEPackageImpl;
import org.eclipse.hyades.models.cbe.util.LogQueryBuilder;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.util.ILogFilterCriteria;
import org.eclipse.hyades.models.hierarchy.util.internal.HierarchyXMIQueryEngine;
import org.eclipse.hyades.models.hierarchy.util.internal.QueryUtils;
import org.eclipse.hyades.trace.ui.FilterTraceViewer;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceAssociationMapping;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tptp.platform.log.views.internal.LogViewsMessages;
import org.eclipse.tptp.platform.log.views.internal.LogViewsPlugin;
import org.eclipse.tptp.platform.log.views.internal.LogViewsPluginImages;
import org.eclipse.tptp.platform.log.views.internal.actions.provider.ILogFilterProvider;
import org.eclipse.tptp.platform.log.views.internal.actions.provider.ILogFindProvider;
import org.eclipse.tptp.platform.log.views.internal.util.ColumnsDialog;
import org.eclipse.tptp.platform.log.views.internal.util.FeatureNode;
import org.eclipse.tptp.platform.log.views.internal.util.FilterTableElement;
import org.eclipse.tptp.platform.log.views.internal.util.FiltersDialog;
import org.eclipse.tptp.platform.log.views.internal.util.LogFindCriteria;
import org.eclipse.tptp.platform.log.views.internal.util.LogRecordSearch;
import org.eclipse.tptp.platform.log.views.internal.util.LogUtil;
import org.eclipse.tptp.platform.log.views.internal.util.RecordChangeEvent;
import org.eclipse.tptp.platform.log.views.internal.util.SearchRecordDialog;
import org.eclipse.tptp.platform.log.views.internal.util.SortDialog;
import org.eclipse.tptp.platform.log.views.internal.util.TerminalNode;
import org.eclipse.tptp.platform.log.views.internal.util.TreeNode;
import org.eclipse.tptp.platform.log.views.internal.views.LogContentProvider;
import org.eclipse.tptp.platform.log.views.internal.views.LogPage;
import org.eclipse.tptp.platform.log.views.internal.views.LogViewerUI;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPage;

public class LogViewer
extends FilterTraceViewer
implements ILogFindProvider,
ILogFilterProvider,
IPartListener {
    protected final String _title = LogViewsPlugin.getResourceString("1");
    private LogPage logPage;
    private Action pageDown;
    private Action pageUp;
    private Action goToPage;
    private LogRecordSearch logRecordSearch = null;
    private Object lastMatch = null;
    private List cbeList;
    private SearchRecordDialog searchDialog = null;
    private EObject prevEObject = null;
    private boolean handleRefreshEvent = false;
    private boolean filterRefreshEvent = false;

    public TraceViewerPage createPage(EObject mofObject) {
        this.logPage = new LogPage(mofObject, (TraceViewer)this);
        return this.logPage;
    }

    public void handleProfileEvent(ProfileEvent event) {
        if (event.getType() == 4608) {
            this.setViewTitle(this._mofObject);
        }
        if (event.getType() == 64 || event.getType() == 2048) {
            if (!this.fPartVisible) {
                this.fRefreshView = true;
                return;
            }
            this.refresh();
        }
        if (event.getType() == 4096) {
            this.refresh();
        }
    }

    protected void refresh() {
        this.handleRefreshEvent = true;
        if (this.logPage != null && this.logPage.getView() != null && this.logPage.getView().getViewer() != null) {
            this.logPage.getView().getViewer().refresh();
        }
        this.handleRefreshEvent = false;
    }

    public void dispose() {
        super.dispose();
    }

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        super.makeActions();
        this.initializedMenu(true);
        String STR_SORT = LogViewsMessages._45;
        Action sort = new Action(STR_SORT){

            public void run() {
                IPage page;
                SortDialog dialog = new SortDialog(LogViewer.this.getViewSite().getShell(), LogViewsPlugin.getResourceString(LogViewsMessages._24), null);
                dialog.open();
                if (dialog.getReturnCode() == 0 && (page = LogViewer.this.getCurrentPage()) != null && page instanceof LogPage) {
                    BusyIndicator.showWhile(null, (Runnable)new Runnable(this, page){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ IPage val$page;
                        {
                            this.this$1 = var1_1;
                            this.val$page = iPage;
                        }

                        public void run() {
                            ((LogPage)this.val$page).getView().update();
                        }
                    });
                }
            }
        };
        sort.setText(STR_SORT);
        LogViewsPluginImages.setImageDescriptors((IAction)sort, "lcl16", "sortrecords_co.gif");
        sort.setDescription(STR_SORT);
        sort.setToolTipText(STR_SORT);
        String STR_FILTER = LogViewsMessages._38;
        Action filter = new Action(STR_FILTER){

            public void run() {
                ColumnsDialog dialog = new ColumnsDialog(LogViewer.this.getViewSite().getShell(), LogViewsMessages._38, null);
                dialog.open();
            }
        };
        filter.setText(STR_FILTER);
        LogViewsPluginImages.setImageDescriptors((IAction)filter, "lcl16", "filter_ps.gif");
        filter.setDescription(STR_FILTER);
        filter.setToolTipText(STR_FILTER);
        Action searchRecord = this.createSearchButton();
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)searchRecord);
        this.createPageUpButton();
        this.createPageDownButton();
        this.createGoToPageButton();
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add((IAction)sort);
        tbm.add((IAction)filter);
        tbm.add((IAction)searchRecord);
        tbm.add((IAction)this.pageUp);
        tbm.add((IAction)this.pageDown);
        tbm.add((IAction)this.goToPage);
        this.getViewSite().getActionBars().updateActionBars();
    }

    private Action createSearchButton() {
        String STR_FIND_RECORD = LogViewsMessages._127;
        Action searchRecord = new Action(STR_FIND_RECORD){

            public void run() {
                LogViewer.this.find();
            }
        };
        searchRecord.setText(STR_FIND_RECORD);
        LogViewsPluginImages.setImageDescriptors((IAction)searchRecord, "lcl16", "searchrecord.gif");
        searchRecord.setDescription(STR_FIND_RECORD);
        searchRecord.setToolTipText(STR_FIND_RECORD);
        return searchRecord;
    }

    private Action createPageUpButton() {
        String STR_PAGE_UP = LogViewsMessages._120;
        this.pageUp = new Action(STR_PAGE_UP){

            public void run() {
                IPage page = LogViewer.this.getCurrentPage();
                if (page != null && page instanceof LogPage) {
                    BusyIndicator.showWhile(null, (Runnable)new Runnable(this, page){
                        final /* synthetic */ 5 this$1;
                        private final /* synthetic */ IPage val$page;
                        {
                            this.this$1 = var1_1;
                            this.val$page = iPage;
                        }

                        public void run() {
                            LogContentProvider logContentProvider = (LogContentProvider)((LogPage)this.val$page).getView().getViewer().getContentProvider();
                            LogViewer.access$0(5.access$0(this.this$1)).setEnabled(logContentProvider.pageUp());
                            ((LogPage)this.val$page).getView().update();
                            LogViewer.access$1(5.access$0(this.this$1), this.val$page, logContentProvider);
                        }
                    });
                }
            }

            static /* synthetic */ LogViewer access$0(5 var0) {
                return var0.LogViewer.this;
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this.pageUp);
        this.pageUp.setText(STR_PAGE_UP);
        LogViewsPluginImages.setImageDescriptors((IAction)this.pageUp, "lcl16", "pageup.gif");
        this.pageUp.setDescription(STR_PAGE_UP);
        this.pageUp.setToolTipText(STR_PAGE_UP);
        return this.pageUp;
    }

    private void setSelectionOnPageLoad(IPage page, LogContentProvider logContentProvider) {
        EObject mofObject = HyadesUtil.getObjectToView((EObject)HyadesUtil.getMofObject());
        List elements = logContentProvider.getPageList(((LogPage)page).getView().getViewer().getInput());
        if (elements.size() > 0 && ((LogPage)page).getView().getViewer().getSelection().isEmpty()) {
            UIPlugin.getDefault().getSelectionModel(mofObject).add(elements.get(0));
            ((LogPage)page).getView().getViewer().setSelection((ISelection)new StructuredSelection(elements.get(0)), true);
            this.notifySelectionChanged((EObject)elements.get(0));
        }
    }

    private Action createGoToPageButton() {
        String STR_GO_TO_PAGE = LogViewsMessages._122;
        this.goToPage = new Action(STR_GO_TO_PAGE){

            public void run() {
                IPage page = LogViewer.this.getCurrentPage();
                LogContentProvider logContentProvider = (LogContentProvider)((LogPage)page).getView().getViewer().getContentProvider();
                int totalPages = logContentProvider.getTotalPages();
                if (totalPages < 2) {
                    LogViewer.this.goToPage.setEnabled(false);
                    return;
                }
                Object[] variables = new String[]{"1", "" + totalPages};
                String dialogTitle = LogViewsMessages._123;
                String dialogMessage = NLS.bind((String)LogViewsMessages._124, (Object[])variables);
                InputDialog inputDialog = new InputDialog(LogViewer.this.getSite().getShell(), dialogTitle, dialogMessage, null, new IInputValidator(this, totalPages){
                    final /* synthetic */ 7 this$1;
                    private final /* synthetic */ int val$totalPages;
                    {
                        this.this$1 = var1_1;
                        this.val$totalPages = n;
                    }

                    public String isValid(String newText) {
                        if (newText == null || newText.length() == 0) {
                            return "";
                        }
                        try {
                            int pageNr = Integer.parseInt(newText);
                            if (pageNr < 1 || pageNr > this.val$totalPages) {
                                return LogViewsMessages._125;
                            }
                        }
                        catch (Exception exception) {
                            return LogViewsMessages._126;
                        }
                        return null;
                    }
                });
                inputDialog.open();
                if (inputDialog.getReturnCode() != 0) {
                    return;
                }
                int pageNr = Integer.parseInt(inputDialog.getValue());
                if (page != null && page instanceof LogPage) {
                    BusyIndicator.showWhile(null, (Runnable)new Runnable(this, logContentProvider, pageNr, page){
                        final /* synthetic */ 7 this$1;
                        private final /* synthetic */ LogContentProvider val$logContentProvider;
                        private final /* synthetic */ int val$pageNr;
                        private final /* synthetic */ IPage val$page;
                        {
                            this.this$1 = var1_1;
                            this.val$logContentProvider = logContentProvider;
                            this.val$pageNr = n;
                            this.val$page = iPage;
                        }

                        public void run() {
                            boolean res = this.val$logContentProvider.goToPage(this.val$pageNr);
                            if (this.val$pageNr == 1) {
                                LogViewer.access$0(7.access$0(this.this$1)).setEnabled(false);
                            }
                            LogViewer.access$2(7.access$0(this.this$1)).setEnabled(res);
                            ((LogPage)this.val$page).getView().update();
                            LogViewer.access$1(7.access$0(this.this$1), this.val$page, this.val$logContentProvider);
                        }
                    });
                }
            }

            static /* synthetic */ LogViewer access$0(7 var0) {
                return var0.LogViewer.this;
            }
        };
        this.goToPage.setText(STR_GO_TO_PAGE);
        this.getViewSite().getActionBars().setGlobalActionHandler("navigate/goToPage", (IAction)this.goToPage);
        LogViewsPluginImages.setImageDescriptors((IAction)this.goToPage, "lcl16", "gotopage.gif");
        this.goToPage.setDescription(STR_GO_TO_PAGE);
        this.goToPage.setToolTipText(STR_GO_TO_PAGE);
        return this.goToPage;
    }

    private Action createPageDownButton() {
        String STR_PAGE_DOWN = LogViewsMessages._121;
        this.pageDown = new Action(STR_PAGE_DOWN){

            public void run() {
                IPage page = LogViewer.this.getCurrentPage();
                if (page != null && page instanceof LogPage) {
                    BusyIndicator.showWhile(null, (Runnable)new Runnable(this, page){
                        final /* synthetic */ 10 this$1;
                        private final /* synthetic */ IPage val$page;
                        {
                            this.this$1 = var1_1;
                            this.val$page = iPage;
                        }

                        public void run() {
                            LogContentProvider logContentProvider = (LogContentProvider)((LogPage)this.val$page).getView().getViewer().getContentProvider();
                            LogViewer.access$3(10.access$0(this.this$1)).setEnabled(logContentProvider.pageDown());
                            ((LogPage)this.val$page).getView().update();
                            LogViewer.access$1(10.access$0(this.this$1), this.val$page, logContentProvider);
                        }
                    });
                }
            }

            static /* synthetic */ LogViewer access$0(10 var0) {
                return var0.LogViewer.this;
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this.pageDown);
        this.pageDown.setText(STR_PAGE_DOWN);
        LogViewsPluginImages.setImageDescriptors((IAction)this.pageDown, "lcl16", "pagedown.gif");
        this.pageDown.setDescription(STR_PAGE_DOWN);
        this.pageDown.setToolTipText(STR_PAGE_DOWN);
        return this.pageDown;
    }

    public void setFocus() {
        if (this.getCurrentPage() != null) {
            this.getCurrentPage().setFocus();
        }
    }

    public boolean isHandlingRefresh() {
        return this.handleRefreshEvent || this.filterRefreshEvent;
    }

    public EObject getObjectToView(EObject selObject) {
        if (selObject == null) {
            return selObject;
        }
        List list = null;
        if (selObject instanceof TRCMonitor) {
            return selObject;
        }
        if (selObject instanceof TRCNode) {
            return selObject;
        }
        if (selObject instanceof TRCProcessProxy) {
            list = this.getLogAgentInProcess((EObject)((TRCProcessProxy)selObject));
        }
        if (list != null && list.size() == 1) {
            return (EObject)list.get(0);
        }
        return selObject;
    }

    private List getLogAgentInProcess(EObject selObject) {
        int nrOfAgents = 0;
        EList agents = ((TRCProcessProxy)selObject).getAgentProxies();
        int size = agents.size();
        TRCAgentProxy a = null;
        ArrayList<TRCAgentProxy> list = new ArrayList<TRCAgentProxy>();
        int idx = 0;
        while (idx < size && nrOfAgents < 2) {
            a = (TRCAgentProxy)agents.get(idx);
            if (a != null && !a.eIsProxy() && (a.getType().equals("Logging") || TraceAssociationMapping.getDefault().isViewForType("org.eclipse.tptp.platform.log.views.internal.views.LogViewer", a.getType()))) {
                ++nrOfAgents;
                list.add(a);
            }
            ++idx;
        }
        return list;
    }

    public String getViewTitle() {
        return this._title;
    }

    public void setRecordSelection(final EObject record, EObject treeSel) {
        final LogViewerUI ui = this.logPage.getView();
        if (ui != null && ui.getViewer() != null) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                public void run() {
                    ui.revealObject(record);
                }
            });
        }
    }

    protected void setViewTitle(Object selection) {
        if (selection != null && selection instanceof TRCAgentProxy) {
            TRCAgentProxy a = (TRCAgentProxy)selection;
            if (a.getProcessProxy() != null) {
                String name = a.getName();
                if (UIPlugin.getDefault().getPreferenceStore().getBoolean("hyde_logtype")) {
                    this.setPartName(this._title + " - " + HyadesUtil.resolveLogAgentDisplayName((String)name));
                } else {
                    this.setPartName(this._title + " - " + HyadesUtil.resolveLogAgentType((String)name) + " " + HyadesUtil.resolveLogAgentDisplayName((String)name));
                }
            }
            return;
        }
        this.setPartName(this.getViewTitle());
    }

    public Action getPageDownAction() {
        return this.pageDown;
    }

    public Action getPageUpAction() {
        return this.pageUp;
    }

    public Action getGotPageAction() {
        return this.goToPage;
    }

    public void find() {
        this.searchDialog = LogUtil.getSearchDialog(this.getViewSite().getShell(), LogViewsMessages._128, null, this);
        this.initializeRecordSearchEngine();
        this.searchDialog.open();
        LogUtil.setSearchDialog(null);
    }

    public void filter() {
        FiltersDialog dialog = new FiltersDialog(this.getViewSite().getShell(), LogViewsMessages._39, null, this, false);
        dialog.open();
    }

    public boolean findRecord(LogFindCriteria criteria) {
        Object sel = null;
        LogRecordSearch searchUtil = this.getRecordSearchEngine();
        if (searchUtil.getType() == 0) {
            searchUtil.initStartNode(this.getStartNode(), 0, criteria.isForwardDirection());
            sel = this.getRecordSearchEngine().search(criteria.getFilters(), criteria.isForwardDirection() ? 1 : -1, this.lastMatch);
        } else if (searchUtil.getType() == 1) {
            Object inputObject = this.logPage.getView().getViewer().getInput();
            SimpleSearchQuery query = (SimpleSearchQuery)((LogContentProvider)this.logPage.getView().getViewer().getContentProvider()).getQuery();
            searchUtil.initStartNode(this.getStartNode(), 1, criteria.isForwardDirection());
            if (query != null) {
                sel = searchUtil.search(query, criteria);
            } else {
                ILogFilterCriteria filterCriteria = ((LogContentProvider)this.logPage.getView().getViewer().getContentProvider()).getFilterCriteria();
                sel = searchUtil.search((SimpleSearchQuery)LogQueryBuilder.createQuery((List)((List)HyadesUtil.getLogAgents((EObject)((EObject)inputObject))), (ILogFilterCriteria)filterCriteria), criteria);
            }
        }
        this.setSelection(sel);
        return true;
    }

    public boolean filterRecord(ILogFilterCriteria criteria) {
        LogViewsPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(5, this));
        return true;
    }

    public LogRecordSearch getRecordSearchEngine() {
        if (this.logRecordSearch == null) {
            this.logRecordSearch = new LogRecordSearch();
            this.initializeRecordSearchEngine();
        }
        return this.logRecordSearch;
    }

    protected void initializeRecordSearchEngine() {
        Object inputObject = this.logPage.getView().getViewer().getInput();
        if (!(inputObject instanceof EObject)) {
            return;
        }
        LogViewerUI ui = this.logPage.getView();
        if (ui != null && ui.getViewer() != null) {
            LogContentProvider logContentProvider = (LogContentProvider)ui.getViewer().getContentProvider();
            this.cbeList = logContentProvider.getCachedElements();
        }
        Object start = this.getStartNode();
        if (this.logRecordSearch == null) {
            this.logRecordSearch = new LogRecordSearch();
        }
        if (this.isInputXMI((EObject)inputObject)) {
            this.logRecordSearch.initialize(this.cbeList, start, 0);
        } else {
            this.logRecordSearch.initialize(this.cbeList, start, 1);
        }
    }

    private void setSelection(Object sel) {
        if (sel == null && this.searchDialog != null) {
            this.searchDialog.updateMessage(LogViewsMessages._135);
            return;
        }
        if (sel != null) {
            this.setRecordSelection((EObject)sel, null);
        }
        this.lastMatch = sel;
        this.logPage.getView().getViewer().reveal(this.lastMatch);
        this.notifySelectionChanged((EObject)sel);
    }

    private void notifySelectionChanged(EObject sel) {
        LogUtil.notifyViewSelectionChanged(this.logPage.getView(), this.logPage.getView().getViewer().getInput() instanceof EObject ? (EObject)this.logPage.getView().getViewer().getInput() : HyadesUtil.getMofObject(), sel);
    }

    private Object getStartNode() {
        IStructuredSelection sel = (IStructuredSelection)this.logPage.getView().getViewer().getSelection();
        Object object = sel.getFirstElement();
        if (object instanceof CBECommonBaseEvent) {
            return object;
        }
        if (object instanceof EObject) {
            return this.getCBENode(object);
        }
        if (object instanceof FeatureNode) {
            return this.getCBENode(((FeatureNode)object).getElement());
        }
        if (object instanceof TreeNode) {
            return this.getCBENode(((TreeNode)object).getParent());
        }
        if (object instanceof TerminalNode) {
            return this.getCBENode(((TerminalNode)object).getTreeParent());
        }
        return null;
    }

    private Object getCBENode(Object object) {
        if (object instanceof CBECommonBaseEvent) {
            return object;
        }
        if (object instanceof EObject) {
            return this.getCBENode(((EObject)object).eContainer());
        }
        return null;
    }

    private boolean isInputXMI(EObject inputObject) {
        List agentProxies = (List)HyadesUtil.getLogAgents((EObject)inputObject);
        TRCAgentProxy proxy = null;
        TRCAgent agent = null;
        int s = agentProxies.size();
        int i = 0;
        while (i < s) {
            proxy = (TRCAgentProxy)agentProxies.get(i);
            agent = (TRCAgent)proxy.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false);
            if (agent != null && EcoreUtil.getURI((EObject)agent).path().endsWith("xmi")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean storeFindOptions(LogFindCriteria criteria) {
        FilterTableElement.saveFilters(criteria.getFilters(), "pd_src_filter_options", LogViewsPlugin.getDefault().getPreferenceStore());
        LogViewsPlugin.getDefault().getPreferenceStore().setValue("pd_src_direction_options", criteria.isForwardDirection() ? "1" : "-1");
        return true;
    }

    public String loadFindPreferenceString() {
        IPreferenceStore store = LogViewsPlugin.getDefault().getPreferenceStore();
        return store.getString("pd_src_filter_options");
    }

    public boolean loadFindDirection() {
        return LogViewsPlugin.getDefault().getPreferenceStore().getString("pd_src_direction_options").equals("1");
    }

    public LogPage getLogPage() {
        return this.logPage;
    }

    public void addViewPage(EObject object) {
        this.prevEObject = object;
        boolean oldValue = this.handleRefreshEvent;
        super.addViewPage(this.prevEObject);
        this.handleRefreshEvent = oldValue;
    }

    protected void refreshVisiblePage() {
        this.addViewPage(this.prevEObject);
        EObject sel = this.getObjectToView(this.prevEObject);
        this.filterRefreshEvent = false;
        this.refreshPage(sel);
        this.selectionChanged(sel);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        boolean openView = ((INavigator)part).isLinkingEnabled();
        Object obj = null;
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            obj = ((IStructuredSelection)selection).getFirstElement();
            this.searchDialog = LogUtil.getSearchDialog();
            if (this.searchDialog != null) {
                this.searchDialog.setFindProvider(this);
                this.logRecordSearch = null;
            }
        }
        if (openView && obj != null && obj instanceof EObject) {
            this.prevEObject = (EObject)obj;
            this.fRefreshView = true;
            if (this.fPartVisible) {
                this.refreshVisiblePage();
            }
        } else {
            super.selectionChanged(part, selection);
        }
    }

    public String[] getFilterScope() {
        String[] scope = new String[]{"LoggingAgentScope"};
        return scope;
    }

    public void filterUpdated() {
        if (this.fPartVisible) {
            this.refresh();
        } else {
            this.fForceRefresh = true;
            this.filterRefreshEvent = true;
        }
    }

    private List getFilteredElements(SimpleSearchQuery filter, List source, EClass output) {
        if (source == null) {
            return new ArrayList();
        }
        if (filter == null) {
            return new ArrayList();
        }
        filter.getSources().clear();
        Resource resource = null;
        int i = 0;
        while (i < source.size()) {
            if (source.get(i) instanceof EObject) {
                filter.getSources().add((Object)EcoreUtil.getURI((EObject)((EObject)source.get(i))).toString());
                if (resource == null) {
                    resource = ((EObject)source.get(i)).eResource();
                }
            }
            ++i;
        }
        if (resource == null) {
            return new ArrayList();
        }
        filter.getOutputElements().clear();
        SimpleOperand outputElement = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        outputElement.setType(output);
        filter.getOutputElements().add((Object)outputElement);
        HierarchyXMIQueryEngine engine = new HierarchyXMIQueryEngine();
        QueryResult result = engine.executeQuery((Query)filter, resource.getResourceSet(), (Collection)Collections.EMPTY_LIST);
        if (result == null) {
            return new ArrayList();
        }
        return (List)((ResultEntry)result.getResultEntries().get(0)).getValue();
    }

    protected List getFilteredLogRecords(List source) {
        SimpleSearchQuery filter = this.getCurrentFilter();
        if (filter == null) {
            filter = QueryUtils.getEmptyQuery();
        }
        return this.getFilteredElements(filter, source, CBEPackageImpl.init().getCBECommonBaseEvent());
    }

    public void partActivated(IWorkbenchPart part) {
        this.searchDialog = LogUtil.getSearchDialog();
        if (part == this && this.searchDialog != null) {
            this.searchDialog.setFindProvider(this);
            this.searchDialog.enableButton(true);
            this.logRecordSearch = null;
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
        this.searchDialog = LogUtil.getSearchDialog();
        if (part == this && this.searchDialog != null) {
            this.searchDialog.enableButton(false);
        }
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.getSite().getPage().addPartListener((IPartListener)this);
    }

    public Viewer[] getExportViewer() {
        LogViewerUI ui = this.logPage.getView();
        if (ui != null) {
            return new Viewer[]{ui.getViewer(), ui.getPropertiesViewer()};
        }
        return new Viewer[0];
    }

    static /* synthetic */ Action access$0(LogViewer logViewer) {
        return logViewer.pageUp;
    }

    static /* synthetic */ void access$1(LogViewer logViewer, IPage iPage, LogContentProvider logContentProvider) {
        logViewer.setSelectionOnPageLoad(iPage, logContentProvider);
    }

    static /* synthetic */ Action access$3(LogViewer logViewer) {
        return logViewer.pageDown;
    }
}

